# $Date: 1995/05/17 08:43:53 $ $Author: kg $ $Revision: 1.13 $ #
#++
AbelianGroup -- the category of abelian groups

An AbelianGroup is a CancellationAbelianMonoid where the operation '+'
is invertible.

Methods:-
negate(x)     - returns the (additive) inverse of x
minus(x,y)    - returns z such that y+z = x
equal(x,y)    - returns TRUE iff x = y
++#

AbelianGroup:= CategoryConstructor(
    AbelianGroup,
    [],
    [],
    NIL,
    [ CancellationAbelianMonoid ],
    [],

    "negate",
    
    "minus" = proc(x,y) begin this::_plus(x, this::negate(y)) end_proc,

    "equal" = proc(x,y) begin
	this::iszero(this::minus(x, y))
    end_proc,

    "intmult" = domains::repeatedSquaring(this, "_plus", "zero", "negate")

)():

