#
| This file contains the definition of the
| procedure sg_one(), describing the single
| soliton solution of the so called Sine-
| Gordon equation.
| The parameter c of the procedure describes
| the asymptotic velocity of the single wave.
|
| At the end of this file an example plot
| command has been added.
|
| Author: T.S.
#

#                                                  
| the single soliton solution                      
#                                                  

sg_one := proc(x, t, c)

local e1;

begin
  e1   := (x - c*t)/((1-c^2)^(1/2)):
  2*atan(e1):
end_proc:

#
| example plot command
#

 plot3d(Axes = Box, Ticks = 0, Scaling = UnConstrained,
        CameraPoint = [-50, -20, 40],
        [Mode = Surface, 
              [u, v, hold(sg_one(u,v,1/2))],
              u = [-10, 10], v = [-10, 10], Grid = [30, 30],
              Style = [ColorPatches, AndMesh],
              Color = [Height, [0,0,65335],[65335,0,65335]]]);



