#
| This file contains the definition of the procedure
| kdv_vir(), describing the so called virtual soliton
| of the corresponding two soliton solution of the so
| called Korteweg-de Vries equation.
|
| At the end of this file an example plot command
| has been added.
|
| Author: T.S.
#

kdv_vir := proc(x, t, c1, c2)

local e1, e2, e12, a12, f, fc1, fc2, fcc;

begin
  e1  := exp(c1*x - c1^3*t):
  e2  := exp(c2*x - c2^3*t):
  a12 := ((c1-c2)/(c1+c2))^2:
  e12 := a12*e1*e2:

  f   := 1 +      e1 +      e2 +           e12:
  fc2 :=                 c2*e2 +        c2*e12:
  fc1 :=       c1*e1 +                  c1*e12;
  fcc :=                             c1*c2*e12:

  (fcc*f - fc1*fc2)/f^2:
end_proc:

#
| example plot command
#

 plot3d(Axes = None, Scaling = UnConstrained,
        [Mode = Surface,
              [u, v, hold(-30*kdv_vir(2*u, 2*v, 1/2, 4/5))],
              u = [-15, 15], v = [-15, 15], Grid = [50, 50],
              Smoothness = [1, 0],
              Style = [ColorPatches, AndMesh],
              Color = [Height, [0,0, 65335],[0,65335,65335]]]);

