
# 		The Klein Bottle 		#

klein := proc()
  local bx, by, pi, rad, u, v, x, y, z;
begin

  bx := proc(u) begin 6*cos(u)*(1+sin(u)) end_proc;
  
  by := proc(u) begin 16*sin(u) end_proc;

  rad := proc(u) begin 4-2*cos(u) end_proc;

  x := proc(u, v) 
    begin 
      if pi < u and u <= 2*pi then
         bx(u)+rad(u)*cos(v+pi)
      else   
         bx(u)+rad(u)*cos(u)*cos(v)
      end_if
  end_proc;

  y := proc(u, v)
    begin
      if pi < u and u <= 2*pi then
         by(u)
      else
         by(u)+rad(u)*sin(u)*cos(v)
      end_if
  end_proc;

  z := proc(u, v) begin rad(u)*sin(v) end_proc;
      
  pi := float(PI);

  plot3d(Axes=None, CameraPoint=[50,-90,-60], FocalPoint= [-2,2,0],
          [Mode=Surface, [ hold(x(u,v)), hold(y(u,v)), hold(z(u, v))], 
          u=[0,2*PI], v=[0,2*PI], Style=[HiddenLine,Mesh]
         ]);

end_proc():
          
          
  
