#
| This file contains the definitions of the three
| procedures plen_x(), plen_y() and plen_x(), des-
| cribing the coordinates of threedimensional sur-
| faces, the so called minimal surfaces with one
| planar end.
|
| At the end of this file an example plot command
| has been added.
| 
| Author: T.S.
#

#
| We use the following files:
#

read("complex.mu"):
read("radial.mu"):

plen_x := proc(u,v,n)
local w;
begin
  w := u + I*v:
  if float(abs(w)) <> 0 then
    real(1/2*(-1/w - w^(2*n+1)/(2*n+1))):
  else
    0:
  end_if:
end_proc:

plen_y := proc(u,v,n)
local w;
begin
  w := u + I*v:
  if float(abs(w)) <> 0 then
    real(1/2*I*(-1/w + w^(2*n+1)/(2*n+1))):
  else
    0:
  end_if:
end_proc:

plen_z := proc(u,v,n)
local w;
begin
  w := u + I*v:
  real(w^n/n):
end_proc:

#
| example plot command
|
| Change the third parameter to increase the
| number of windings at the non planar end.
#

 plot3d(Axes = None, Scaling = UnConstrained,
       [Mode = Surface,
             [hold(plen_x(U(u,v),V(u,v),1)),
              hold(plen_y(U(u,v),V(u,v),1)),
              hold(2*plen_z(U(u,v),V(u,v),1))],
             u = [-PI, PI], v = [1/3, 6/5],
             Grid = [50, 15],
             Style = [HiddenLine, Mesh],
             Color = [Height,[65335,0,65335],[0,65335,65335]]]);

