#
| This file contains the definitions of the three
| procedures hen_x(), hen_y() and hen_z(), descri-
| bing a threedimensional surface, the so called
| Henneberg minimal surface.
| 
| At the end of this file an example plot command
| has been added.
|
| Author: T.S.
#

hen_x := proc(u,v)
begin
  cosh(2*u)*cos(2*v)-1:
end_proc:

hen_y := proc(u,v)
begin
  -sinh(u)*sin(v) - 1/3*sinh(3*u)*sin(3*v):
end_proc:

hen_z := proc(u,v)
begin
  -sinh(u)*cos(v) + 1/3*sinh(3*u)*cos(3*v):
end_proc:

#
| example plot command
|
| Change the ranges for u and v and you see
| the evolution of this surface.
#

plot3d(Axes = None, Scaling = UnConstrained,
       [Mode = Surface, 
             [hold(3/2*hen_x(u,v)),
              hold(hen_y(u,v)),
              hold(hen_z(u,v))],
             u = [-1,1], v= [-1,1],       
             Grid = [30, 30], Style = [ColorPatches, AndMesh]]);

