#
| This file contains the definitions of the three
| procedures enn_x(), enn_y() and enn_z(), descri-
| bing a threedimensional surface, the so called
| Enneper minimal surface.
|
| At the end of this file an example plot command
| has been added.
|
| Author: T.S.
#

#
| We use the following file to calculate real
| and imaginary parts.
#

read("complex.mu"):

enn_x := proc(u,v)
local w;
begin
  w := u + I*v:
  real(0.5*(w-w^3/3)):
end_proc:

enn_y := proc(u,v)
local w;
begin
  w := u + I*v:
  real(0.5*I*(w+w^3/3)):
end_proc:

enn_z := proc(u,v)
local w;
begin
  w := u + I*v:
  real(0.5*(w^2)):
end_proc:

#
| example plot command
|
| Change the ranges for both u and v and
| you will see how the surface changes.
#

plot3d(Axes = None, Scaling = UnConstrained,
       [Mode = Surface, 
             [hold(enn_x(u,v)),
              hold(enn_y(u,v)),
              hold(enn_z(u,v))
             ],
             u = [-1,1], v = [-1,1],
             Grid = [30, 30],
             Color = [Height, [30000,0,65000],[65000,30000,45000]],
             Style = [HiddenLine, Mesh]]);
