#
| tetra_eder.mu
| the different colors are computed out of the 
| colors of the differen points
#

new_point := proc(p1, p2)
local x, y, z, red, green, blue;
begin
    x := op(p1,1) + (op(p2,1)-op(p1,1))/2.0:
    y := op(p1,2) + (op(p2,2)-op(p1,2))/2.0:
    z := op(p1,3) + (op(p2,3)-op(p1,3))/2.0:
    red   := (op(p1,[4,1])+op(p2,[4,1]))/2.0:
    green := (op(p1,[4,2])+op(p2,[4,2]))/2.0:
    blue  := (op(p1,[4,3])+op(p2,[4,3]))/2.0:
    point(x, y, z, Color = [red, green, blue]):
end_proc:

tetra_rec := proc(p1, p2, p3, p4, n)
local np1, np2, np3, np4, np5, np6;
begin
    if n = 0 then
        polygon(p1, p2, p4, Closed = TRUE, Filled = TRUE),
        polygon(p1, p3, p4, Closed = TRUE, Filled = TRUE),
        polygon(p2, p3, p4, Closed = TRUE, Filled = TRUE):
    else
        np1 := new_point(p1, p2):
        np2 := new_point(p2, p3):
        np3 := new_point(p3, p1):
        np4 := new_point(p1, p4):
        np5 := new_point(p2, p4):
        np6 := new_point(p3, p4):
        tetra_rec(p1, np1, np3, np4, n-1),
        tetra_rec(np1, p2, np2, np5, n-1),
        tetra_rec(np2, p3, np3, np6, n-1),
        tetra_rec(np4, np5, np6, p4, n-1):
    end_if:
end_proc:
   
XMIN := -0.7:
XMAX :=  1.0:
YMIN := -0.5*sqrt(3.0):
YMAX :=  0.5*sqrt(3.0):
ZMIN :=  0.0:
ZMAX :=  2*YMAX:

a := point(XMAX, 0, 0, Color = [1, 0, 0]):
b := point(XMIN, YMAX, 0, Color = [0, 1, 0]):
c := point(XMIN, YMIN, 0, Color = [0, 0, 1]):
d := point(XMIN + (XMAX-XMIN)/2.0, 0, ZMAX, Color = [1, 1, 1]):

plot3d(Axes = None, CameraPoint = [0.15, -0.1, 10.0],
       ForeGround = [0,0,0],
       BackGround = [1,1,1],
       [Mode = List,
             [tetra_rec(a,b,c,d,4)]]);
