attractor := proc(x_coord, y_coord, z_coord, u_val, v_val)

local max_it, root, old_z, new_z, eps, i, value;

begin
  max_it  := 100:
  eps     := 0.01:
  root[0] := 1.0 + I*0.0:
  root[1] := -0.5 + I*0.5*(3.0)^(1/2):
  root[2] := -0.5 - I*0.5*(3.0)^(1/2):
  old_z   := float(u_val) + I*float(v_val):
  i       := 1: found := 0:
  while i < max_it and found = 0 do
     if abs(old_z) < eps 
     then found := 1:
          new_z := old_z:
     else
         new_z := old_z - ((old_z^3-1)/(3*old_z^2)):
         if abs(new_z-old_z) < eps then
            found := 1:
         else
            i := i + 1:
            old_z := new_z:
         end_if:
     end_if:
  end_while:
  value := 1.0-i/max_it:
  if abs(root[0]-new_z) < eps then
     [value, 0, 0]:
  elif abs(root[1]-new_z) < eps then
     [0, value, 0]:
  elif abs(root[2]-new_z) < eps then
     [0, 0, value]:
  else
     [1, 1, 1]:
  end_if:
end_proc:

complex_surf := proc(u, v)
begin
    1/((u+I*v)^3-1):
end_proc:

plot3d(Axes = None,
       [Mode = Surface, 
             [u, v, min(abs(complex_surf(u,v)), 2)],
             u = [-2, 2], v = [-2, 2],
             Grid = [20, 20], Smoothness = [2, 2],
             Style = [ColorPatches, AndMesh],
             Color = [Function, attractor]
        ]);
