#include <linux/fs.h>
#include <X11/Xlib.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "glove.h"
#include "mode.h"
#include "posture.h"
#include "gesture.h"


/* globals */
Display *mydisplay;
Window   mywindow, rootwin, childwin;
int      myscreen;
unsigned long black, white;
XEvent   myevent;
char     text[10];
int      width, height, centrex, centrey, lastx, lasty, lastz = 0, rec;
int      x, y, z, key;
char     *message = " POWERGLOVE (C) 26/11/1993 STU"; 
GC       mygc;
Colormap cmap;
XColor   color;
int      box = 90;
int      flag = 1;
long int col = -1;

/* variables for gesture recognition */

int           client1;
gestureData_t gesture;
postureData_t *pos;

/* prototypes */

void quit();


int main(int argc, char *argv[])
{
  mydisplay = XOpenDisplay("");  /* connect to server */

  if(mydisplay == NULL)
  {
     fprintf(stderr, "cannot connect to X server !\n");
     exit(1);
  }
  printf("connected to X server...\n");

  myscreen = DefaultScreen(mydisplay);  /* get a screen */

  white = WhitePixel(mydisplay, myscreen);  /* look up colours */
  black = BlackPixel(mydisplay, myscreen);

  printf("got foreground/background...\n");

  width = DisplayWidth(mydisplay, myscreen) / 2;  /* get width and height of root window */
  height = DisplayHeight(mydisplay, myscreen) / 2;
  printf("got screen width/height (%d/%d)...\n",width,height);

  /* create a window at based on screen size */

  mywindow = XCreateSimpleWindow(mydisplay, DefaultRootWindow(mydisplay),
                                 0, 0, width-4, height-4, 2, white, black);
   
  if(mywindow == BadAlloc)
  {
     fprintf(stderr, "cannot open window !\n");
     exit(1);
  }

  mygc = XCreateGC(mydisplay, mywindow, 0, 0);  /* create a GC */
  printf("created GC...\n");

  cmap = DefaultColormap(mydisplay, myscreen);  /* make colour map */                                          
  XSetForeground(mydisplay, mygc, white);                     
  XSetBackground(mydisplay, mygc, black);
  printf("set foreground/background colours...\n");

  XSelectInput(mydisplay, mywindow, ExposureMask);  /* get events */

  XMapRaised(mydisplay, mywindow);  /* pop this window up on the screen */
  printf("popped window...\n");

  XNextEvent(mydisplay, &myevent);
  printf("window now displayed...\n");

  XDrawImageString(mydisplay, mywindow, mygc, ((width-4)/2)-(((strlen(message)*8)/2)), height-30, message, strlen(message));

  XFlush(mydisplay);
  printf("flushing X server buffer...\n");

  col = white;

  centrex = width/2;
  centrey = height/2;

  /* init gesture recognition routines */

  client1 = init_gestures();
  if (client1 < 0)
  {
    fprintf(stderr, "%s: could not initialise gestures\n", argv[0]);
    exit(1);
  }

  for(;;)
  {
    lastx = x;
    lasty = y;
    lastz = z;

    if (realtime_tracking(&gesture) < 0)
      quit();

    x = getX(gesture.glove);
    y = getY(gesture.glove);
    z = getZ(gesture.glove);

    pos = gesture.posture;  /* point to posture data */

    if (pos)  /* if we got a valid posture... */
    {
      fprintf(stderr, "P '%s'       \r", pos->name);

      /* trail mode */

      if (pos->id == 10)
      {
        flag = FALSE;
      }
      else
      {
        flag = TRUE;
      }

      if (pos->id == 9)
      {
        fprintf(stderr, "\nP '%s' ... QUIT\n", pos->name);
        break;
      }
    }
    else
      fprintf(stderr, "P 'none'       \r");

    key = getKey(gesture.glove);

    switch (key)
    {

      case 0x80: fprintf(stderr, "\nKey '%x' ... QUIT\n", key);
                 quit();

      case 0xa:
      case 0xb:  XClearWindow(mydisplay, mywindow);
                 break;

      case 0xc:  fprintf(stderr, "\nKey '%x' ... FILTER-ON\n", key);
                 client_set_filter(client1, PGFILTER_ON);    /* filter */
                 break;

      case 0xf:  fprintf(stderr, "\nKey '%x' ... FILTER-OFF\n", key);
                 client_set_filter(client1, PGFILTER_OFF);   /* no filter */
                 break;

      default:   break;
    }


    if(flag)  /* no trails */
    {
      rec = box+lastz*2;
      rec -= rec/2;
      XSetForeground(mydisplay, mygc, black);                     
      XDrawRectangle(mydisplay, mywindow, mygc, centrex+lastx*2, centrey-lasty*2, rec, rec);            
    }
    rec = box+z*2;
    rec -= rec/2;
    XSetForeground(mydisplay, mygc, col);
    XDrawRectangle(mydisplay, mywindow, mygc, centrex+x*2, centrey-y*2, rec, rec);            
    XFlush(mydisplay);
  }

  quit();
}


void quit()
{
  XDestroyWindow(mydisplay, mywindow);
  printf("\nclosing window...\n");

  XCloseDisplay(mydisplay);
  printf("closing display...\n");

  quit_gestures();

  fprintf(stderr, "exit\n");

  exit(0);
}
