/*
 * posture.h
 *
 * (c)28/11/1993 Stuart N. John
 *
 *
 * History:
 *
 *   28-11-1993 - Created file
 *
 */

#ifndef POSTURE_H
#define POSTURE_H


#define TRUE 1
#define FALSE 0

#define POSTURE_FILE "/tmp/posture_file"

/*
 * Posture Data Structure
 *
 * Contains:
 *
 *   posture name
 *   numeric identifier for posture
 *   flag to indicate sub-posture or main class posture
 *   finger flex min/max values
 *   rotation min/max values
 *   pointer to next posture data structure
 *
 *   N.B. The little finger has no flex sensor
 *
 */

typedef struct
{
  Flex min, max;
} Minmax_f_t;

typedef struct
{
  int min, max;
} Minmax_w_t;

typedef struct pd
{
  char        *name;
  int         id;
  char        sub_posture;
  struct pd   *parent;
  Minmax_f_t  thumb, index, middle, ring;
  Minmax_w_t  rotation;
  struct pd   *next;
} postureData_t;


/* function prototypes */

extern int create_posture_table();
extern int save_posture_table();
extern int delete_posture_table();
extern postureData_t *classify_posture(Flex t, Flex i, Flex m, Flex r, int w);

#endif
