%{

/* Lexical analyser for a posture definition file */

#include "posture.tab.h"    /* token codes from the parser */

int yylex (void);

%}

%%

[ \t\n]+        ;
[0-9]+          { printf("got number '%s'\n", yytext); return NUMBER; }
\"[^"\n#]*["\n] { printf("got name %s\n", yytext); return NAME; }
#+[^\n]*\n      { printf("got comment '%s'\n", yytext); }
\{              { printf("got block start '%s'\n", yytext); return BLOCK_START; }
\}              { printf("got block end '%s'\n", yytext); return BLOCK_END; }
T               { printf("got thumb '%s'\n", yytext); return THUMB; }
I               { printf("got index '%s'\n", yytext); return INDEX; }
M               { printf("got middle '%s'\n", yytext); return MIDDLE; }
R               { printf("got ring '%s'\n", yytext); return RING; }
W               { printf("got wrist '%s'\n", yytext); return WRIST; }
.               ;

%%
