/***********************************************************************/
/*                                                                     */
/* Project      : GRAV                                                 */
/* Current Rel. : 3.1                                                  */
/* Creator      : Michael Knigge                                       */
/* Creation Date: 01/21/95                                             */
/* Description  : input a single filename                              */
/*                                                                     */
/* Functions    : grav_input_filename()                                */
/*                                                                     */
/***********************************************************************/

#include <stdio.h>
#include <ncurses.h>
#include "defines.h"
#include "keys.h"
#include "input.h"
#include "error.h"
#include "directory.h"

int grav_input_filename(int use_color, DIRTAB single[])
{

   int key_ok;
   int key;
   int pos;
   int rc;
   int type;
   int tmp;
   
   char filename[80];
   char current_dir[61];
   
   /*
    * first, set color...
    */
    
   if (use_color)
      attron(COLOR_PAIR(WHITE_ON_BLUE));
   else
      attroff(A_REVERSE);

   mvaddstr(5, 5, "[                                                                    ]");

   /*
    * set the cursor and so a screen-refresh
    */
    
   curs_set(CURSOR_NORMAL);
   move(5,6);
   refresh();

   filename[0] = 0;
   pos         = 0;
         
   do
   {
      key_ok = FALSE;
      key    = getch();
      
      if ((key > 42 && key < 58)  ||          /* numbers, "/", "." etc */
          key == 95               ||                     /* Underscore */
          key == 92               ||                      /* Bachslash */
          key > 64 && key < 91    ||                          /* A - Z */
          key > 96 && key < 123)                              /* a - z */
      {
          if (pos < 68)
          {
             pos++;
             move(5, 5 + pos);
             printw("%c", key);
             key_ok           = TRUE;
             filename[pos -1] = key;
          }
      }

      /*
       * the TAB-Key will abort this "dialog"
       */
      
      if (key == 9)
      {
         filename[0] = 0;
         key         = KEY_ENTER;
      }
    
    
      if (key == KEY_BACKSPACE)
      {
         if (pos > 0)
         {
            move(5, 5 + pos);
            printw(" ");
            pos--;
            move(5, 5 + pos + 1);
            filename[pos] = 0;
            key_ok = TRUE;
         }
      }
     
      if (key == KEY_ENTER)
      {
         filename[pos] = 0;
         rc            = GRAV_NO_ERROR;
         key_ok        = TRUE;
      }
      
      if (key_ok == FALSE)
      {
         beep();
         refresh();
      }
   }
   while(key != KEY_ENTER);
   
   curs_set(CURSOR_INVISIBLE);
   getcwd(current_dir,60);
   mvaddstr(5,5,"Directory of                                                          ");
   mvaddstr(5,18,current_dir);

   /*
    * if we erased the length of the filename, we will return NO_ERROR
    * to main()...
    */
   if (strlen(filename) == 0)
      return(GRAV_NO_ERROR);
      
   /*
    * is the given filename a file (does it exist and is not a directory)??
    */
   tmp = grav_check_filename(filename);
   
   if (tmp == IS_DIRECTORY)
      return(GRAV_ERROR_DIRECTORY);
      
   if (tmp == IS_NOT_FOUND)
      return(GRAV_ERROR_EXIST);
   
   /*
    * can we view that file?
    */
   if ((grav_guess_filetype(filename, &type)) == FALSE)
      return(GRAV_ERROR_TYPE);

   /*
    * if we got here, everything is all right!
    */

   single[0].filetype = IS_FILE;
   single[0].gfx_type = type;
   single[0].tagged   = TRUE;
   strcpy(single[0].filename, filename);
   
   return(GRAV_NO_ERROR);
}
