/***********************************************************************/
/*                                                                     */
/* Project      : GRAV                                                 */
/* Current Rel. : 3.1                                                  */
/* Creator      : Michael Knigge                                       */
/* Creation Date: 01/30/95                                             */
/* Description  : error-handling                                       */
/*                                                                     */
/* Functions    : grav_show_error()                                    */
/*                                                                     */
/***********************************************************************/

#include <stdio.h>
#include <ncurses.h>
#include "standard.h"
#include "defines.h"
#include "error.h"

int grav_show_error(int where, int use_color, int error)
{
   int pos1;
   int pos2;
   int pos3;

   char line1[23];
   char line2[23];
   char line3[23];
   
   switch (error)
   {
   case  GRAV_NO_ERROR:
         break;
         
   case  GRAV_ERROR_TYPE:
         strcpy(line1, "Unknown type of");
         strcpy(line2, "\0");
         strcpy(line3, "graphic");
         break;
            
   case  GRAV_ERROR_OPEN:
         strcpy(line1, "\0");
         strcpy(line2, "Can't open file");
         strcpy(line3, "\0");
         break;
            
   case  GRAV_ERROR_HEADER:
         strcpy(line1, "\0");
         strcpy(line2, "Can't read header");
         strcpy(line3, "\0");
         break;
            
   case  GRAV_ERROR_PALETTE:
         strcpy(line1, "\0");
         strcpy(line2, "Can't read palette");
         strcpy(line3, "\0");
         break;
            
   case  GRAV_ERROR_ALLOC:
         strcpy(line1, "\0");
         strcpy(line2, "Out of memory");
         strcpy(line3, "\0");
         break;
            
   case  GRAV_ERROR_READ:
         strcpy(line1, "\0");
         strcpy(line2, "Can't read file");
         strcpy(line3, "\0");   
         break;
            
   case  GRAV_ERROR_SUPPORT:
         strcpy(line1, "NO MSG DEFINED\0");
         strcpy(line2, "\0");
         strcpy(line3, "FOR ERR_SUPPORT\0");
         break;
            
   case  GRAV_ERROR_CREATE:
         strcpy(line1, "\0");
         strcpy(line2, "Can't create file");
         strcpy(line3, "\0");
         break;
            
   case  GRAV_ERROR_FORMAT:
         strcpy(line1, "NO MSG DEFINED\0");
         strcpy(line2, "\0");
         strcpy(line3, "FOR ERR_FORMAT");
         break;
            
   case  GRAV_ERROR_WRITE:
         strcpy(line1, "\0");
         strcpy(line2, "Can't write file");
         strcpy(line3, "\0");
         break;
            
   case  GRAV_ERROR_MAXCOLOR:
         strcpy(line1, "NO MSG DEFINED\0");
         strcpy(line2, "\0");
         strcpy(line3, "FOR ERR_MAXCOLOR");
         break;
            
   case  GRAV_ERROR_COLORS:
         strcpy(line1, "Too much colors for");
         strcpy(line2, "\0");
         strcpy(line3, "that Graphic-Mode");
         break;
            
   case  GRAV_ERROR_CHDIR:
         strcpy(line1, "\0");
         strcpy(line2, "Can't change directory");
         strcpy(line3, "\0");
         break;
         
   case  GRAV_ERROR_JPEGLIB:
         strcpy(line1, "\0");
         strcpy(line2, "Error reading JPEG");
         strcpy(line3, "\0");
         break;
         
   case  GRAV_ERROR_EXIST:
         strcpy(line1, "\0");
         strcpy(line2, "File does not exist");
         strcpy(line3, "\0");
         break;
         
   case  GRAV_ERROR_DIRECTORY:
         strcpy(line1, "\0");
         strcpy(line2, "File is a directory");
         strcpy(line3, "\0");
         break;
         
   case  GRAV_ERROR_PNGLIB:
         strcpy(line1, "\0");
         strcpy(line2, "Error reading PNG");
         strcpy(line3, "\0");
         break;

   case  GRAV_ERROR_SCALE:
         strcpy(line1, "\0");
         strcpy(line2, "Error scaling bitmap");
         strcpy(line3, "\0");
         break;
         
   case  GRAV_ERROR_FLIP:
         strcpy(line1, "\0");
         strcpy(line2, "Error while flipping");
         strcpy(line3, "\0");
         break;
         
   case  GRAV_ERROR_MIRROR:
         strcpy(line1, "\0");
         strcpy(line2, "Error while mirroring");
         strcpy(line3, "\0");
         break;
         
   default: strcpy(line1, "\0");
            strcpy(line2, "Don't know that error");
            strcpy(line3, "\0");
            break;      
   }


   if (where == MSG_WINDOW)
      if (use_color)
      {
         attron(A_BOLD);
         grav_draw_box(5,24,18,54,YELLOW_ON_RED);
         attron(COLOR_PAIR(YELLOW_ON_RED));
      }
      else
      {
         grav_draw_box(5,24,18,54,COLOR_REVERSE);
         attron(A_REVERSE);
      }

   if (where == MSG_WINDOW)
   {
      pos1 = ((23 - strlen(line1)) / 2) + 54;
      pos2 = ((23 - strlen(line2)) / 2) + 54;
      pos3 = ((23 - strlen(line3)) / 2) + 54;
      mvaddstr(18, pos1, line1);
      mvaddstr(19, pos2, line2);
      mvaddstr(20, pos3, line3);
   }
   else
      printf("\nERROR: %s %s %s\n\n", line1, line2, line3);

   if (where == MSG_WINDOW)
      if (use_color)
         attroff(A_BOLD);
      else
         attroff(A_REVERSE);

   return(TRUE);
}

