/***********************************************************************/
/*                                                                     */
/* Project      : GRAV                                                 */
/* Current Rel. : 3.1                                                  */
/* Creator      : Michael Knigge                                       */
/* Creation Date: 02/06/95                                             */
/* Description  : reading and writing .gravrc                          */
/*                                                                     */
/* Functions    : grav_read_config()                                   */
/*                grav_write_config()                                  */
/*                                                                     */
/***********************************************************************/

#include <stdio.h>
#include <ncurses.h>
#include "defines.h"
#include "config.h"

int grav_read_config(int *mode_index)
{
   char in_file[256];
   char data[256];
   char mode[5];
   FILE *gravrc;

   *mode_index = 0;
   
   /*
    * first, generate the full pathname  of .gravrc
    */
    
   sprintf(in_file, "%s/.gravrc", getenv("HOME"));
      
   /*
    * open the file
    */
    
   if ((gravrc = fopen(in_file, "r")) == NULL)
      return(FALSE);
      
   /*
    * skip the header-lines
    */
    
   fgets(data, 255, gravrc);
   fgets(data, 255, gravrc);
   fgets(data, 255, gravrc);
   fgets(data, 255, gravrc);      
   fgets(data, 255, gravrc);
   
   /*
    * read the line containing the mode-info
    */
    
   fscanf(gravrc, "%s %s", data, mode);
   *mode_index = atoi(mode);

   fclose(gravrc);
   
   return(TRUE);   
}

int grav_write_config(int mode_index)
{
   char out_file[256];
   FILE *gravrc;

   /*
    * generate the full pathname of the .gravrc file
    */
    
   sprintf(out_file, "%s/.gravrc", getenv("HOME"));
   
   if ((gravrc = fopen(out_file, "w")) == NULL)
      return(FALSE);
      
   fprintf(gravrc, "#\n");
   fprintf(gravrc, "# THIS FILE WAS GENERATED AUTOMATICALLY BY GRAV 3.1\n");
   fprintf(gravrc, "#\n");
   fprintf(gravrc, "# DO NOT EDIT THIS FILE!!!\n");
   fprintf(gravrc, "#\n");
   fprintf(gravrc, "mode: %d\n", mode_index);
   
   fclose(gravrc);
   
   return(TRUE);
}
