/********************************************************************************
 *  Projektname		: AERO - Teilprojekt FSB
 *  Filename		: kraft.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: kraft.o
 *  letzte Aenderung	: 10.03.93
 *  Autor		: Horst Stolz (HUS)
 *  
 *  Beschreibung:
 *    Definiert die Anwendung von Kraeften auf einen Koerper.  
 *
 *  Exportierte Funktionen/Makros:
 * 
 *  Noch zu machen:
 *
 *  Versionsgeschichte:
 *  10.03.93	Erstellungsdatum
 *  
 ********************************************************************************/
#ifndef KRAFT_H
#define KRAFT_H

#ifndef GRUNDTYPEN_H
#include "grundtypen.h"
#endif


/****************************************************************************
 * Die Kraftstruktur(en) sollten in den entsprechenden Eintrag der 
 * Koerper-Struktur eingehaengt werden.
 *
 * Eine Kraft ist ein Vektor der an Angriffspunkt eines Koerpers ansetzt.
 * Die Kraft ist nur waehrend der StartZeit<= (Zustand->Zeit) <=EndZeit
 * wirksam. Der Kraftvektor wirkt konstant in diesem Zeitpunkt auf den
 * Koerper und erzeugt eine Beschleunigung bzw. Rotation des Koerpers.
 * Durch die Verkettung per Naechste ist es moeglich mehrer Kraft an
 * verschiedenen Stellen bzw. verschiedenen Zeiten anzulegen.
 *
 * (=> StartZeit & EndZeit immer belegen mit StartZeit<=EndZeit !)
 * (Der Angriffspunkt der Kraft ist immer in kooerperfesten Koordinaten
 *  anzugeben!)
 * 
 *
 * Eine Kraft kann von folgendem Typ sein:
 * RAUMFEST:
 *   Der Kraftvektor in KD.Kraft ist in raumfesten Koordinaten angegeben.
 *
 * KOERPERFEST:
 *   Der Kraftvektor in KD.Kraft ist in koerperfesten Koordinaten angegeben.
 *
 * GERICHTET:
 *   Der Kraftvektor zeigt immer in Richtung eines koerperfesten Punktes eines
 *   anderen Koerpers(kann auch der geleiche sein).
 *   Dazu muss dann der Koerper auf den die Kraft zeigen soll in
 *   KD.GerKraft.ZielKoerper eingetragen werden und in KD.GerKraft.Zielpunkt ein
 *   koerperfeste Punkt auf diesem Koerper angegeben werden.
 *   Schliesslich ist noch der konstante Betrag der Kraft in
 *   KD.GerKraft.Kraftbetrag zu setzen.
 *  
 * 
 * Kraftstruktur 
 */

typedef enum TKrafttyp {RAUMFEST, KOERPERFEST, GERICHTET} TKrafttyp;

typedef struct TGerichteteKraft {
    struct TKoerper *ZielKoerper;   /* Koerper auf den Kraft zeigt */
    TVektor          Zielpunkt;     /* koerperfester Zielpunkt */
    TReal            Kraftbetrag;   /* Konstanter Kraftbetrag */
} TGerichteteKraft;

typedef union TKraftdef {
    TVektor           Kraft;         /* RAUMFEST oder KOERPERFEST */
    TGerichteteKraft  GerKraft;      /* GERICHTET */
} TKraftdef;


typedef struct TKraft {
    struct TKraft  *Naechste;	    /* Naechste Kraft */
    
    TReal	    StartZeit;	    /* Zeit zwischen der die Kraft wirkt */
    TReal           EndZeit;
    
    TVektor         Angriffspunkt;  /* immer Koerperfest */
    
    TKrafttyp       Typ;	    /* RAUMFEST oder KOERPERFEST oder GERICHTET */
    TKraftdef       KD;
} TKraft;


extern int kr_debug_level;

void KraefteEinbringen(struct TKoerper *k, TReal t);

#endif
