 /********************************************************************************
 *  Projektname		: AERO
 *  Filename		: kollision.c
 *  Filetyp		: C-Source
 ********************************************************************************
 *  Modulname		: kollision.o
 *  letzte Aenderung	: 02.04.93
 *  Autor		: Horst Stolz (HUS)
 *  Status:		: veraendert
 *  
 *  Beschreibung:
 *  
 *  Noch zu machen:
 *
 *  Versionsgeschichte:
 *  27.01.93     KollisionsTest Kugel gegen Ebene! 
 *  14.02.93     KugelvsQuader neu implementiert und KugelvsZylinder eingebaut
 *               beides aber noch nicht getestet
 *  17.02.93     Test fuer KvsQ und KvsZ erfolgreich abgeschlossen->OK
 *  22.03.93     Kein Kollisionstest zwischen Masselosen Koerpern
 *  30.03.93     Simuliere statt einem Zylinder durch einen Quader beim
 *               Kollisionstest
 *  02.04.93     Kollisionserkennung fuer ZusGesObjekte
 *  22.04.93     Kollisionsroutine Zylinder gegen Ebene
 *  04.05.93     ZvsE wieder rausgenommen da falsch!
 *  18.05.93     ZvsE verbesser und wieder eingebaut
 *
 ********************************************************************************/

#include <math.h>
#include "koerper.h"
#include "fehler.h"
#include "kollision.h"
#include "integration.h"
#include "gleichungsloeser.h"
#include "vektor.h"
#include "ausgabe.h"




int ke_debug_level = 0;

/*
#define DEBUG_QvsE
#define DEBUG_KvsZ
#define DEBUG_KvsQ
*/
/*
#define DEBUG_QvsQ

#define DEBUG_ZvsE

*/



#define MAXFORM		EBENE+1


static void KvsZ(TKollision **K, TKoerper *kk, TKoerper *kz);
static void KvsQ(TKollision **K, TKoerper *kk, TKoerper *kq);
static void KvsK(TKollision **K, TKoerper *k1, TKoerper *k2);
static void KvsE(TKollision **K, TKoerper *kk, TKoerper *ke);
static void QvsE(TKollision **K, TKoerper *kq, TKoerper *ke);
static void QvsQ(TKollision **K, TKoerper *kq1, TKoerper *kq2);
static void ZvsE(TKollision **K, TKoerper *kz, TKoerper *ke);
static void CvsX(TKollision **K, TKoerper *kz, TKoerper *kx);



static void (*KolRoutine[MAXFORM][MAXFORM])(TKollision **, TKoerper *, TKoerper *)= 
{  /* [zeile][spalte] */
/*	      ZYLINDER QUADER   KUGEL  MPUNKT   PUNKT   NAGEL ZUSGESOBJ EBENE */
/* ZYLINDER */	QvsQ,	QvsQ,	KvsZ,	NULL,	NULL,	NULL,	CvsX,	ZvsE,
/* QUADER */	QvsQ,	QvsQ,	KvsQ,	NULL,	NULL,	NULL,	CvsX,	QvsE,
/* KUGEL */	KvsZ,	KvsQ,	KvsK,	NULL,	NULL,	NULL,	CvsX,	KvsE,
/* MPUNKT */	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
/* PUNKT */	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
/* NAGEL */	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,
/* ZUSGESOBJ */	CvsX,	CvsX,	CvsX,	NULL,	NULL,	NULL,	CvsX,	CvsX,
/* EBENE */	ZvsE,	QvsE,	KvsE,	NULL,	NULL,	NULL,	CvsX,	NULL
};

/* 0 - keine Routine verfuegbar , <0 Argumententausch vornehmen */
/* Spalte->1.Argument */
static signed char KolArg[MAXFORM][MAXFORM] = {
/*	      ZYLINDER QUADER   KUGEL  MPUNKT   PUNKT   NAGEL ZUSGESOBJ EBENE */
/* ZYLINDER */	1,	1,	1,	0,	0,	0,	1,	-1,
/* QUADER */	1,	1,	1,	0,	0,	0,	1,	-1,
/* KUGEL */	-1,	-1,	1,	0,	0,	0,	1,	-1,
/* MPUNKT */	0,	0,	0,	0,	0,	0,	0,	0,
/* PUNKT */	0,	0,	0,	0,	0,	0,	0,	0,
/* NAGEL */	0,	0,	0,	0,	0,	0,	0,	0,
/* ZUSGESOBJ */	-1,	-1,	-1,	0,	0,	0,	1,	-1,
/* EBENE */	1,	1,	1,	0,	0,	0,	1,	0
};


/****************************************************************************
 * Routinen zur schnellen Bereitstellung einer Kollisionsstruktur
 ****************************************************************************
 */
#define KOLLFELDGROESSE		100

struct KollisionsBlock {
    struct KollisionsBlock *Naechster, *Erster;
    unsigned int AnzFrei;
    TKollision KollisionsFeld[KOLLFELDGROESSE];
};

static struct KollisionsBlock *AktuellerKB = NULL;


static TKollision *KollStrukturAnfordern()
/****************************************************************************
 * Zweck:
 *   schnelles bereitstellen EINER Kollisionsstruktur(uninitialisiert)
 *   statt immer nur einer Koll-Struktur per malloc anzufordern werden 
 *   viele angeforderd und die Verwaltung selber vorgenommen.
 *   =>malloc-Aufrufe werden eingespart!
 *
 * Siehe weiter:
 *   KollBloeckeLoeschen() - KollisionsBloeck auf frei setzten (Speicher nicht
 *                           freigeben
 *   KollBlockSpeicherFreigeben() - Speicher fuer Kollisionsbloecke freigeben
 *
 */
{
    struct KollisionsBlock **pkb, **first;
    

    pkb = & AktuellerKB;
    if (*pkb) first = &((*pkb)->Erster); else first = pkb;

    /* bis zum KB mit freien Elementen oder Leerem KB gehen
     */    
    while (*pkb && (*pkb)->AnzFrei==0)
	pkb = &((*pkb)->Naechster);

    /* Falls noetig Kollisionsblock belegen
     */
    if ((*pkb) == NULL) {
	*pkb = (struct KollisionsBlock *)malloc(sizeof(struct KollisionsBlock));
	if (*pkb==NULL) {
	    FehlerOrt("KollStrukturAnfordern()");
	    Fehler("kein Speicher mehr fuer KollisionsBlock!");
	}
	(*pkb)->Erster = *first;
	(*pkb)->AnzFrei = KOLLFELDGROESSE;
        (*pkb)->Naechster = NULL;
    }

    /* Oberstes Element runternehmen
     */
    AktuellerKB = *pkb;
    AktuellerKB->AnzFrei--;
    return &(AktuellerKB->KollisionsFeld[AktuellerKB->AnzFrei]);
}

static void KollBloeckeLoeschen()
{
    struct KollisionsBlock *kb;
 
    if (kb = AktuellerKB) kb = AktuellerKB->Erster;

    AktuellerKB = kb;
    for (;kb; kb=kb->Naechster)
	kb->AnzFrei = KOLLFELDGROESSE;
}

static void KollBlockSpeicherFreigeben()
{
    struct KollisionsBlock *kb;
 
    if (kb = AktuellerKB) kb = AktuellerKB->Erster;

    while (AktuellerKB = kb) {
	kb = kb->Naechster;
	free(AktuellerKB);
    }

    AktuellerKB = NULL;
}




/****************************************************************************
 * Kollisionserkennungsroutinen fuer die Einzelnen Koerper
 ****************************************************************************
 */



static void ZvsE(TKollision **K, TKoerper *kz, TKoerper *ke)
/***************************************************************************
 * Zylinder kz auf Kollision mit Ebene testen
 *
 */
{
    TKollision *k;
    TVektor n, h, r, a, b, p, x, z, pe;
    TReal ba, bb, bq, xx, dd, zh;		/* Hilfsvariablen */
    int i;

    /* y' -Normale der Ebene in raumfesten Koordinaten
     */
    n[0] = ke->RotTrans1[0][1];   
    n[1] = ke->RotTrans1[1][1];
    n[2] = ke->RotTrans1[2][1];

    /* Abstand zwischen Zylinderschwerpunkt und Ebenen-Nullpunkt
     */
    V_SUB(a, kz->ty->p, ke->ty->p);

    /* Schnelltest ob Kollision moeglich 
     */
    ba = V_PRODUKT(a, n);

#ifdef DEBUG_ZvsE
    printvektor("n = ", n);
    printvektor("a = ", a);
    printf("a*n = %f\n", ba); 
#endif

    if (fabs(ba) > kz->Kugelhuellenradius) return;

    /* Normalenrichtung entsprechend der Lage des Zylinderschwerpunktes
     * ausrichten
     */
    if (ba<0) {
	V_NEG(n, n);
    }


    /* z'-Hoehe des Zylinders in raumfesten Koordinaten
     */
    zh = 0.5 * kz->Form.Zylinder.Hoehe;
 
    h[0] = zh * kz->RotTrans1[0][2];   
    h[1] = zh * kz->RotTrans1[1][2];
    h[2] = zh * kz->RotTrans1[2][2];


    /* Berechne Vektor Parallel zur Ebene und in der Ebene des Kreisabschlusses,
     * also im rechten Winkel zu h und n!
     */
    V_MUL(pe, h, n);

    bb = V_BETRAG(pe);
    if (bb < 1e-10) { /* Zylinder steht mit Kreisenden auf Ebene */
	pe[0] = kz->RotTrans1[0][0];
	pe[1] = kz->RotTrans1[1][0];
	pe[2] = kz->RotTrans1[2][0];
    }

    /* Berechne Vektore der vom Kreismittelpunkt auf direktem(kuerztem Weg)
     * durch die Ebene zeigt, also imrechten Winkel zu h und r steht.
     */
    V_MUL(r, h, pe);
    bb = kz->Form.Zylinder.Radius / V_BETRAG(r);
    r[0] *= bb;
    r[1] *= bb;
    r[2] *= bb;
    
	
#ifdef DEBUG_ZvsE
	printvektor("pe = ", pe);
	printvektor("r = ", r);
#endif

    for (i=0; i<4; i++) {
	switch(i) {
	  case 0:
	    p[0] = a[0] + h[0] + r[0];
	    p[1] = a[1] + h[1] + r[1];
	    p[2] = a[2] + h[2] + r[2];
	    break;

	  case 1:
	    p[0] = a[0] + h[0] - r[0];
	    p[1] = a[1] + h[1] - r[1];
	    p[2] = a[2] + h[2] - r[2];
	    break;

	  case 2:
	    p[0] = a[0] - h[0] + r[0];
	    p[1] = a[1] - h[1] + r[1];
	    p[2] = a[2] - h[2] + r[2];
	    break;

	  default:
	    p[0] = a[0] - h[0] - r[0];
	    p[1] = a[1] - h[1] - r[1];
	    p[2] = a[2] - h[2] - r[2];
	    break;

	}
	

	ba = V_PRODUKT(p, n);
	
#ifdef DEBUG_ZvsE
	printvektor("p = ", p);
	printf("p*n = %f\n", ba); 
#endif
	
	if (ba<=0) {
#ifdef DEBUG_ZvsE
	    printf("Kollision mit Tiefe %f\n", -ba);
#endif       
	    k = KollStrukturAnfordern();
	    k->Koerper1 = kz->OberKoerper;
	    k->Koerper2 = ke->OberKoerper;
	    k->TeilKoerper1 = kz;
	    k->TeilKoerper2 = ke;
	    k->Tiefe = -ba;
	    k->Naechste = *K;
	    *K = k;
	    
	    V_NEG(k->Normale, n);
	    V_LET(k->Ort2, p);
	    V_ADD(k->Ort, p, ke->ty->p);
	    V_SUB(k->Ort1, k->Ort, kz->OberKoerper->ty->p);
	
	    EbenenVektoren(k->EbenenVek1, k->EbenenVek2, k->Normale);
	}
    }
}

static void ZvsE_old(TKollision **K, TKoerper *kz, TKoerper *ke)
/***************************************************************************
 * Zylinder kz auf Kollision mit Ebene testen
 *
 */
{
    TKollision *k;
    TVektor n, h, r, a, b, p, x, z;
    TReal ba, bb, bq, xx, dd, zh;		/* Hilfsvariablen */
    int i;

    /* y' -Normale der Ebene in raumfesten Koordinaten
     */
    n[0] = ke->RotTrans1[0][1];   
    n[1] = ke->RotTrans1[1][1];
    n[2] = ke->RotTrans1[2][1];

    /* Abstand zwischen Zylinderschwerpunkt und Ebenen-Nullpunkt
     */
    V_SUB(a, kz->ty->p, ke->ty->p);

    /* Schnelltest ob Kollision moeglich 
     */
    ba = V_PRODUKT(a, n);

#ifdef DEBUG_ZvsE
    printvektor("n = ", n);
    printvektor("a = ", a);
    printf("a*n = %f\n", ba); 
#endif

    if (fabs(ba) > kz->Kugelhuellenradius) return;

    /* Normalenrichtung entsprechend der Lage des Zylinderschwerpunktes
     * ausrichten
     */
    if (ba<0) {
	V_NEG(n, n);
    }


    /* z'-Hoehe des Zylinders in raumfesten Koordinaten
     */
    zh = 0.5 * kz->Form.Zylinder.Hoehe;
 
    h[0] = zh * kz->RotTrans1[0][2];   
    h[1] = zh * kz->RotTrans1[1][2];
    h[2] = zh * kz->RotTrans1[2][2];

    /* Abstand der Schwerpunkte in Normalenrichtung
     */

    bb = V_PRODUKT(a, n);
    if (bb==0.0) {
	/* Schwerpunkt des Zylinders liegt in der Ebene 
	 */
	return;
    }
    V_SKALAR(b, n, bb);


    /* Abstand in Richtung des Hoehenvektors (z-Achse des Zylinders)
     */
    bq = (V_PRODUKT(h, b)) / zh;

    xx = bb*bb - bq*bq;

#ifdef DEBUG_ZvsE
	printf("xx = %e\n", xx);
#endif

/* test auf x==0.0! */
    if (xx > 1e-12 ) {
	xx = bq * kz->Form.Zylinder.Radius / sqrt(xx);
	dd = sqrt(QUADRAT(kz->Form.Zylinder.Radius)+xx*xx);
	
#ifdef DEBUG_ZvsE
	printvektor("h = ", h);
	printvektor("b = ", b);
	printf("|b| = %f\n", bb);
	printf("|q| = %f\n", bq);
	printf("x = %f\n", xx);
	printf("d = %f\n", dd);
#endif

	xx = xx / zh;
	
	/* Radiusvektor der zur max. Durchdringungstiefe fuehrt
	 */

	r[0] = xx * h[0] - dd * n[0];
	r[1] = xx * h[1] - dd * n[1];
	r[2] = xx * h[2] - dd * n[2];

#ifdef DEBUG_ZvsE
	printvektor("r = ", r);
#endif
    }
    else {
	/* Zylinder steht auf der Ebene
	 */
	r[0] = kz->Form.Zylinder.Radius * kz->RotTrans1[0][0];   
	r[1] = kz->Form.Zylinder.Radius * kz->RotTrans1[1][0];
	r[2] = kz->Form.Zylinder.Radius * kz->RotTrans1[2][0];
    }


    for (i=0; i<4; i++) {
	switch(i) {
	  case 0:
	    p[0] = a[0] + h[0] + r[0];
	    p[1] = a[1] + h[1] + r[1];
	    p[2] = a[2] + h[2] + r[2];
	    break;

	  case 1:
	    p[0] = a[0] + h[0] - r[0];
	    p[1] = a[1] + h[1] - r[1];
	    p[2] = a[2] + h[2] - r[2];
	    break;

	  case 2:
	    p[0] = a[0] - h[0] + r[0];
	    p[1] = a[1] - h[1] + r[1];
	    p[2] = a[2] - h[2] + r[2];
	    break;

	  default:
	    p[0] = a[0] - h[0] - r[0];
	    p[1] = a[1] - h[1] - r[1];
	    p[2] = a[2] - h[2] - r[2];
	    break;

	}
	

	ba = V_PRODUKT(p, n);
	
#ifdef DEBUG_ZvsE
	printvektor("p = ", p);
	printf("p*n = %f\n", ba); 
#endif
	
	if (ba<=0) {
#ifdef DEBUG_ZvsE
	    printf("Kollision mit Tiefe %f\n", -ba);
#endif       
	    k = KollStrukturAnfordern();
	    k->Koerper1 = kz->OberKoerper;
	    k->Koerper2 = ke->OberKoerper;
	    k->TeilKoerper1 = kz;
	    k->TeilKoerper2 = ke;
	    k->Tiefe = -ba;
	    k->Naechste = *K;
	    *K = k;
	    
	    V_NEG(k->Normale, n);
	    V_LET(k->Ort2, p);
	    V_ADD(k->Ort, p, ke->ty->p);
	    V_SUB(k->Ort1, k->Ort, kz->OberKoerper->ty->p);
	
	    EbenenVektoren(k->EbenenVek1, k->EbenenVek2, k->Normale);
	}
    }
}





TBoolean QuaderDurchstosspunkt(TVektor d, TVektor k2, TVektor p, TVektor normale)
/* gibt Punkt d zurueck der auf der Quaderoberflache liegt sowie auf der
 * durch die Normalenrichtung festgelegten Linie!
 * Die Normalenrichtung wird am Punkt p angesetzt, dieser muss INNERHALB 
 * des Quaders mit der halben Kantenlaenge k2 sein!
 * Der Punkt p darf nicht am Rand liegen, sonsten wird FALSE zurueckgegeben!
 * wenn ein Durchstosspunkt gefunden wurde wird TRUE zurueckgegeben.
 */ 
{
    int i;
    TReal minx, x;

    /*   : p + x * normale : <= k2 */

    minx = -1.0;

    for (i=0; i<3; i++) {
	if (normale[i] != 0.0 && fabs(p[i]) < k2[i]) {
	    x = (k2[i] - p[i]) / normale[i];
	    if (x > 0.0) {
		if (minx<0.0 || x<minx) minx = x;
	    }
	    x = (-k2[i] - p[i]) / normale[i];
	    if (x > 0.0) {
		if (minx<0.0 || x<minx) minx = x;
	    }
	  }
    }

    if (minx<0.0) {
#ifdef DEBUG_QvsQ
	printf("Fehler in QuaderDurch..() kein Durchstosspunkt!\n");
	printvektor("k2 = ", k2);
	printvektor("p = ", p);
	printvektor("normale = ", normale);
#endif
/*
        Fehler("Kann Durchstosspunkt durch Quader nicht ermitteln!");
*/
	return FALSE;
    }

    V_ADDSKAL(d, p, minx, normale);

    return TRUE;
}



static void QvsP(TKollision **K,
		 TKoerper *kq, TVektor k2,
		 TKoerper *kq2, TVektor p, TVektor k2_q2,
		 int anz_normalen, TVektor normale[3], TVektor normale_q1[3])

/****************************************************************************
 * Testet ob der Punkt p (in Koerperkoordinaten vom Quader kq) innerhalb des
 * Quaders kq liegt. Der Quader kq hat die halbe Kantenlaenge k2. Der Punkt p
 * gehoert zum Koerper kq2.
 * Falls p im Quader liegt wird dieser in die Kollisionsliste K gehaengt.
 * Auch werden die Quadranten(von kq) Hochgezaehlt in denen p liegt.
 * Als Tiefe wird eine -1.0 eingesetzt da auch noch keine Normalenrichtung 
 * bestimmbar ist. Ausserdem wird als Normalenrichtung noch p abgespeichert
 * (in koerperkoord).
 *
 * k2 - halbe Kantenlaenge des Quaders
 * p  - (Eck)Punkt eines anderen Quaders
 * Punkt p sowie k2 in Koerperkoord. von Q1, rq in Absolutkoord.
 */
{
    TKollision *kol;
    TVektor h, d_q1, d_q2;
    int i;

#ifdef DEBUG_QvsQ
    printf("QvsP\n");
    printvektor("k2 = ", k2);
    printvektor("p = ", p);
    printvektor("k2_q2 = ", k2_q2);
#endif    

    /* Ist Punkt p innerhalb des Quaders oder nicht */
    if (fabs(p[0]) > k2[0] || fabs(p[1]) > k2[1] || fabs(p[2]) > k2[2])
      return;  /* nein */


    for (i=0; i<anz_normalen; i++) {
	/* Bestimme Durchstosspunkt an dem die Normal die Quaderoberflaeche
         * durchstoesst
         */
	QuaderDurchstosspunkt(d_q1, k2, p, normale_q1[i]);
#ifdef DEBUG_QvsQ
	printvektor("Durchstosspunkt_q1 = ", d_q1);
#endif	
	
	/* Raumfester Durchstosspunkt */
	MV_MUL2(h, kq->RotTrans1, d_q1);
	V_INC(h, kq->ty->p);

	/* Ortsfest bezueglich Q2 */
	V_DEC(h, kq2->ty->p);
	MV_MUL2(d_q2, kq2->RotTrans, h);

#ifdef DEBUG_QvsQ
	printvektor("Durchstosspunkt_q2 = ", d_q2);
#endif	
	
	/* Abfrage ob dieser Punkt auch in Q2 enthalten ist,
	 * wenn nicht, lasse diese Normalenrichtung fallen!
	 */
	if (fabs(d_q2[0]) > k2_q2[0] || fabs(d_q2[1]) > k2_q2[1] 
	    || fabs(d_q2[2]) > k2_q2[2])
	  continue;

	kol = KollStrukturAnfordern();
	kol->Koerper1 = kq->OberKoerper;         /* Kollisionstruktur initialisieren */
	kol->Koerper2 = kq2->OberKoerper;
	kol->TeilKoerper1 = kq;
	kol->TeilKoerper2 = kq2;
	kol->Naechste = *K;
	*K = kol;

	V_LET(kol->Normale, normale[i]);
	EbenenVektoren(kol->EbenenVek1, kol->EbenenVek2, kol->Normale);

	
	MV_MUL2(kol->Ort1, kq->RotTrans1, p);      /* Kollisionsort */
	V_ADD(kol->Ort, kol->Ort1, kq->ty->p);
	V_SUB(kol->Ort2, kol->Ort, kq2->OberKoerper->ty->p);
	V_SUB(kol->Ort1, kol->Ort, kq->OberKoerper->ty->p);
	
	V_DEC(d_q1, p);
	kol->Tiefe = V_BETRAG(d_q1);
	if (kol->Tiefe>=Konfiguration.K_MaxQuaderQuerTiefe) kol->Tiefe=0.0;
	
#ifdef DEBUG_QvsQ
	printf("Tiefe = %f\n", kol->Tiefe);
	printvektor("Ort = ", kol->Ort);
	printvektor("Ort1 = ", kol->Ort1);
	printvektor("Ort2 = ", kol->Ort2);
#endif    
	
    }
}







static void QEvsKante(TReal *f1, int *a1, TReal *f2, int *a2,
		      int a, TVektor k2, TVektor rk, TVektor k)
/* f?, a? -> |rk+f?*k| = k2, Wenn a?=0->nicht benutztes f?
 * a - Ebenenindex 0..2 k2 - halbe Kantenlaenge, rk - Kantenstart, k - Kantenvektor 
 */
{
    int b, c;
    TReal f;


    if (a==2) b = 0; else b = a+1; 
    if (b==2) c = 0; else c = b+1; 
    if (k[a] != 0.0) {
	f = (k2[a] -  rk[a])/k[a];

	if (f>=0.00001 && f<=0.99999 &&
	    fabs(rk[b]+f*k[b])<=k2[b] &&
	    fabs(rk[c]+f*k[c])<=k2[c]) {
	    
	    if (*a1==0 || fabs(*f1 - f)<=0.000001 ) {
		*f1 = f;
		*a1 = a+1;
	    }
	    else {
		if (*a2==0 || fabs(*f2 - f)<=0.000001 ) {
		    *f2 = f;
		    *a2 = a+1;
		}
	    }
	}
	
	f = (-k2[a] -  rk[a])/k[a];
	
	if (f>=0.00001 && f<=0.99999 &&
	    fabs(rk[b]+f*k[b])<=k2[b] &&
	    fabs(rk[c]+f*k[c])<=k2[c]) {
	    
	    if (*a1==0 || fabs(*f1 - f)<=0.000001 ) {
		*f1 = f;
		*a1 = -(a+1);
	    }
	    else {
		if (*a2==0 || fabs(*f2 - f)<=0.000001 ) {
		    *f2 = f;
		    *a2 = -(a+1);
		}
	    }
	}
    }
    
}





static void QvsKante(TKollision **K, TKoerper *kq, TKoerper *kk,
		     TVektor k2, TVektor rk, TVektor k,
		     TVektor k2_q2,
		     int anz_normalen, TVektor normale[3], TVektor normale_q1[3])

/* k2, rk und k in Koerperkoordinaten des Quaders */
/* kq = Q1, kk = Q2 ! */
{
    TReal f[2];
    int a[2], i, j;
    TKollision *kol;
    TVektor h;
    TVektor d_q1, d_q2;
    TVektor kp_q1, kp_q2, kp_abs, kp_q1_abs, kp_q2_abs;
    TReal tiefe;

#ifdef DEBUG_QvsQ
    printf("QvsKante() /* testet Kante des Quaders Q2 gegen Schnitt mit Q1 */\n");
    printvektor("Schwerpunkt Q1(abs)      : rq= ", kq->ty->p);
    printvektor("halbe Kantenlaenge von Q1: k2= ", k2);
    printvektor("halbe Kantenlaenge von Q2: k2_q2 = ", k2_q2);
    printvektor("Kantenstartpunkt(von Q2-Kante) in Q1-Koord: rk = ", rk);
    printvektor("Kantenvektor(von Q2-Kante) in Q1-Koord    :  k = ", k);
#endif


    /* Durchdringt Kante die X-Ebenen des Quaders?
     * -> bestimme die f1, f2 sodass |rk+f*k|=k2 ist!
     */

    f[0] = 2;
    f[1] = 2;
    a[0] = 0;
    a[1] = 0;

    QEvsKante(&f[0], &a[0], &f[1], &a[1], 0, k2, rk, k);
    QEvsKante(&f[0], &a[0], &f[1], &a[1], 1, k2, rk, k);
    QEvsKante(&f[0], &a[0], &f[1], &a[1], 2, k2, rk, k);

#ifdef DEBUG_QvsQ
    printf("Faktoren f sodass |rk+f*k|=k2 (Kante durchdringt Quader Q1)\n"
	  "gueltig sind f[i] wenn a[i] != 0, : ");
    printf("f[0] = %f, a[0]=%d, f[1]=%f, a[1]=%d\n", f[0], a[0], f[1], a[1]);
#endif
    


    for (j=0; j<2; j++) {
	
	if (a[j] != 0 ) {
	    /* Kollisionsort best. (im Quader-Koordsystem) */
	    V_ADDSKAL(kp_q1, rk, f[j], k);

	    /* Kollisionspunkt Absolut (von 0, von Q1 und Q2 aus gesehen)
             * sowie in Q1-Koord. und Q2-Koord.
	     */
	    MV_MUL2(kp_q1_abs, kq->RotTrans1, kp_q1);
	    V_ADD(kp_abs, kq->ty->p, kp_q1_abs);
	    V_SUB(kp_q2_abs, kp_abs, kk->ty->p);

#ifdef DEBUG_QvsQ
	    MV_MUL2(kp_q2, kk->RotTrans, kp_q2_abs);

	    printvektor("Kante durchdringt Q1 an Stelle(in Q1 Koord): kp_q1  = ", kp_q1);
	    printvektor("..in Q2 Koord): kp_q2  = ", kp_q2);
	    printvektor("Absolutkoordinaten : kp_abs = ", kp_abs);
#endif	

	    /* Test von Kollisionspunkt aus ob in einer Normalenrichtung
             * eine Durchdringungstiefe feststelbar ist? -> Kollision
	     * wenn nicht Kollision mit tiefe 0!
	     */
	    for (i=0; i<anz_normalen; i++) {
		/* Bestimme Durchstosspunkt an dem die Normal von 
		 * Kollisionspunkt aus den Quader Q1 durchstoesst!
		 */
#ifdef DEBUG_QvsQ
		printvektor("Teste Normale(in Q1-Koord): normale_q1 = ", normale_q1[i]);
#endif	
		if (QuaderDurchstosspunkt(d_q1, k2, kp_q1, normale_q1[i])) {

#ifdef DEBUG_QvsQ
		    printvektor("Durchstosspunkt der Normalen durch Q1(in Q1 Koord): d_q1 = ", d_q1);
#endif	
	
		    /* Raumfester Durchstosspunkt */
		    MV_MUL2(h, kq->RotTrans1, d_q1);
		    V_INC(h, kq->ty->p);

		    /* Ortsfest Durchstosspunkt bezueglich Q2 */
		    V_DEC(h, kk->ty->p);
		    MV_MUL2(d_q2, kk->RotTrans, h);

#ifdef DEBUG_QvsQ
		    printvektor("Durchstosspunkt in Q2 Koord. :d_q2 = ", d_q2);
#endif	
	
		    /* Abfrage ob dieser Punkt auch in Q1 enthalten ist,
		     * wenn nicht, lasse diese Normalenrichtung fallen!
		     */
		
		    if (fabs(d_q2[0]) > k2_q2[0] || fabs(d_q2[1]) > k2_q2[1] 
			|| fabs(d_q2[2]) > k2_q2[2]) {
#ifdef DEBUG_QvsQ
			printf("Durchstosspunkt liegt nicht in Q2!\n");
#endif	
			tiefe = 0.0;
		    }
		    else {
			V_DEC(d_q1, kp_q1);
			tiefe = V_BETRAG(d_q1);
			if (tiefe>=Konfiguration.K_MaxQuaderQuerTiefe) tiefe=0.0;
		    }
		}
		else {
		    tiefe = 0.0;
		}

		kol = KollStrukturAnfordern();
		kol->Koerper1 = kq->OberKoerper;   /* Kollisionstruktur initialisieren */
		kol->Koerper2 = kk->OberKoerper;     
		kol->TeilKoerper1 = kq;
		kol->TeilKoerper2 = kk;     
		kol->Naechste = *K;
		*K = kol;

		V_LET(kol->Normale, normale[i]);
		EbenenVektoren(kol->EbenenVek1, kol->EbenenVek2, kol->Normale);

		V_LET(kol->Ort, kp_abs);              /* Kollisionsort */
		V_SUB(kol->Ort1, kp_abs, kol->Koerper1->ty->p);
		V_SUB(kol->Ort2, kp_abs, kol->Koerper2->ty->p);
/*
		V_LET(kol->Ort1, kp_q1_abs);
		V_LET(kol->Ort2, kp_q2_abs);
*/
		V_DEC(d_q1, kp_q1);
		kol->Tiefe = tiefe;
	
#ifdef DEBUG_QvsQ
		printf("Tiefe = %f\n", kol->Tiefe);
		printvektor("Ort = ", kol->Ort);
		printvektor("Ort1 = ", kol->Ort1);
		printvektor("Ort2 = ", kol->Ort2);
		printvektor("Koll-ort = ", kol->Ort);
		printvektor("Norm-Vek = ", kol->Normale);
#endif
	    }
	}
    }
}





static void MoeglicheNormalen(int *anz_normalen, TVektor normalen[3], 
			      TVektor HalbeKantenlaenge_Q1, TVektor Schwerpunkt_Q2)
/* Alle Vektoren in Koerperkoordinaten von Q1 !
 */
{
    int i;
    TReal h;


    *anz_normalen = 0;

    for (i=0; i<3; i++) 
      if (fabs(Schwerpunkt_Q2[i]) >= HalbeKantenlaenge_Q1[i]) {
	  V_SET(normalen[*anz_normalen], 0.0, 0.0, 0.0);
	  normalen[*anz_normalen][i] = (Schwerpunkt_Q2[i]>=0.0) ? 1.0 : -1.0;
	  *anz_normalen = *anz_normalen + 1;
      }

    if (*anz_normalen == 0) {
	h = 1.0 / V_BETRAG(Schwerpunkt_Q2);
	V_SKALAR(normalen[*anz_normalen], Schwerpunkt_Q2, h);
	*anz_normalen = 1;
    }

#ifdef DEBUG_QvsQ
    printf("MoeglicheNormalen(k2=%f %f %f, s=%f %f %f)\n",
	HalbeKantenlaenge_Q1[0], HalbeKantenlaenge_Q1[1], HalbeKantenlaenge_Q1[2], 
	Schwerpunkt_Q2[0], Schwerpunkt_Q2[1], Schwerpunkt_Q2[2]);
    for (i=0; i < *anz_normalen; i++)
      printvektor("Normale = ", normalen[i]);
#endif
}



static void Q1vsQ2(TKollision **QKol, TKoerper *kq1, TKoerper *kq2, TVektor sq2)
{
    TVektor h, kx, ky, kz, p, k2, k2_q2;
    /* Normalenrichtungen Q1 -> Q2 in Bezugssystem Q1, Q2, raumfest */
    TVektor normalen_q1[3], normalen_q2[3], normalen[3];
    int anzahl_normalen, i;



#ifdef DEBUG_QvsQ
    printf("Q1vsQ2(s_q2=%f %f %f)\n", sq2[0], sq2[1], sq2[2]);
#endif

    /* Koordinaten vom Q2-Schwerpunkt in Koerperkoord. von Q1 */
    MV_MUL2(p, kq1->RotTrans, sq2);

    /* halbe Kantenlaenge des Quaders Q1 */
    V_LET(k2, kq1->HalbeKantenlaenge);

    /* Moegliche Normalenrichtungen! */
    MoeglicheNormalen(&anzahl_normalen, normalen_q1, k2, p);
    for (i=0; i<anzahl_normalen; i++) {
	MV_MUL2(normalen[i], kq1->RotTrans1, normalen_q1[i]);
	MV_MUL2(normalen_q2[i], kq2->RotTrans, normalen[i]);
	V_NEG(normalen_q2[i], normalen_q2[i]);
    }

    /* halbe Kantenlaenge des Quaders Q2  */
    V_LET(k2_q2, kq2->HalbeKantenlaenge);

    /* Kantenlaengen des Quaders 2 in Koerperkoordinaten von Q1 */

    if (kq2->Art == ZYLINDER) { /* Simulation des Zylinders durch eine Quader */
	h[0] = kq2->RotTrans1[0][0] * kq2->HalbeKantenlaenge[0] * 2;
	h[1] = kq2->RotTrans1[1][0] * kq2->HalbeKantenlaenge[0] * 2;
	h[2] = kq2->RotTrans1[2][0] * kq2->HalbeKantenlaenge[0] * 2;
	MV_MUL2(kx, kq1->RotTrans, h);
	
	h[0] = kq2->RotTrans1[0][1] * kq2->HalbeKantenlaenge[1] * 2;
	h[1] = kq2->RotTrans1[1][1] * kq2->HalbeKantenlaenge[1] * 2;
	h[2] = kq2->RotTrans1[2][1] * kq2->HalbeKantenlaenge[1] * 2;
	MV_MUL2(ky, kq1->RotTrans, h);
        
	h[0] = kq2->RotTrans1[0][2] * kq2->HalbeKantenlaenge[2] * 2;
	h[1] = kq2->RotTrans1[1][2] * kq2->HalbeKantenlaenge[2] * 2;
	h[2] = kq2->RotTrans1[2][2] * kq2->HalbeKantenlaenge[2] * 2;
	MV_MUL2(kz, kq1->RotTrans, h);
    }
    else {
	h[0] = kq2->RotTrans1[0][0] * kq2->Form.Quader.KantenLaenge[0];
	h[1] = kq2->RotTrans1[1][0] * kq2->Form.Quader.KantenLaenge[0];
	h[2] = kq2->RotTrans1[2][0] * kq2->Form.Quader.KantenLaenge[0];
	MV_MUL2(kx, kq1->RotTrans, h);
	
	h[0] = kq2->RotTrans1[0][1] * kq2->Form.Quader.KantenLaenge[1];
	h[1] = kq2->RotTrans1[1][1] * kq2->Form.Quader.KantenLaenge[1];
	h[2] = kq2->RotTrans1[2][1] * kq2->Form.Quader.KantenLaenge[1];
	MV_MUL2(ky, kq1->RotTrans, h);
        
	h[0] = kq2->RotTrans1[0][2] * kq2->Form.Quader.KantenLaenge[2];
	h[1] = kq2->RotTrans1[1][2] * kq2->Form.Quader.KantenLaenge[2];
	h[2] = kq2->RotTrans1[2][2] * kq2->Form.Quader.KantenLaenge[2];
	MV_MUL2(kz, kq1->RotTrans, h);
    }

#ifdef DEBUG_QvsQ
    printvektor("kx = ", kx);
    printvektor("ky = ", ky);
    printvektor("kz = ", kz);
#endif

    /* Halbe Kantenlaenge von Q2 im Koerperkoordinaten von Q1 von p abziehen */
    p[0] -= 0.5 * (kx[0]+ky[0]+kz[0]);
    p[1] -= 0.5 * (kx[1]+ky[1]+kz[1]);
    p[2] -= 0.5 * (kx[2]+ky[2]+kz[2]);

    /* 8 Eckpunkte und 6 Kanten des Quaders Q2 auf Kollision mit Quader Q1 testen
     */

/* P1 */
#ifdef DEBUG_QvsQ
    printf("P1 (Test kx,ky,kz)\n");
#endif
    QvsP(QKol, kq1, k2, kq2, p, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, kx, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, ky, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, kz, k2_q2, anzahl_normalen, normalen, normalen_q1);
    
    V_INC(p, ky);
/* P2 */    
#ifdef DEBUG_QvsQ
    printf("P2 (Test kx,kz)\n");
#endif
    QvsP(QKol, kq1, k2, kq2, p, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, kx, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, kz, k2_q2, anzahl_normalen, normalen, normalen_q1);

    V_INC(p, kx);
/* P3 */    
#ifdef DEBUG_QvsQ
    printf("P3 (Test kz)\n");
#endif
    QvsP(QKol, kq1, k2, kq2, p, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, kz, k2_q2, anzahl_normalen, normalen, normalen_q1);

    V_INC(p, kz);
/* P4 */    
#ifdef DEBUG_QvsQ
    printf("P4 (Test -)\n");
#endif
    QvsP(QKol, kq1, k2, kq2, p, k2_q2, anzahl_normalen, normalen, normalen_q1);

    V_DEC(p, kx);
/* P5 */    
#ifdef DEBUG_QvsQ
    printf("P5 (Test kx)\n");
#endif
    QvsP(QKol, kq1, k2, kq2, p, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, kx, k2_q2, anzahl_normalen, normalen, normalen_q1);

    V_DEC(p, ky);
/* P6 */    
#ifdef DEBUG_QvsQ
    printf("P6 (Test kx,ky)\n");
#endif
    QvsP(QKol, kq1, k2, kq2, p, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, kx, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, ky, k2_q2, anzahl_normalen, normalen, normalen_q1);

    V_INC(p, kx);
/* P7 */    
#ifdef DEBUG_QvsQ
    printf("P7 (Test ky)\n");
#endif
    QvsP(QKol, kq1, k2, kq2, p, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, ky, k2_q2, anzahl_normalen, normalen, normalen_q1);

    V_DEC(p, kz);
/* P8 */    
#ifdef DEBUG_QvsQ
    printf("P8 (Test ky,kz)\n");
#endif
    QvsP(QKol, kq1, k2, kq2, p, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, ky, k2_q2, anzahl_normalen, normalen, normalen_q1);
    QvsKante(QKol, kq1, kq2, k2, p, kz, k2_q2, anzahl_normalen, normalen, normalen_q1);
}





static void QvsQ(TKollision **K, TKoerper *kq1, TKoerper *kq2)
{
    TKollision *QKol = NULL;
    TKollision **Khelp;
    TVektor  h;
    TReal f;


#ifdef DEBUG_QvsQ
    printf("QvsQ()\n");
#endif


    /* Test ob umgebende Kugeln sich schneiden */
    V_SUB(h, kq2->ty->p, kq1->ty->p);
    if (((f=V_BETRAG(h)) - kq1->Kugelhuellenradius - kq2->Kugelhuellenradius) > 0.0)
	return;

    if (fabs(f)<=1e-20) return; /* Kugelschwerpunkte liegen zusammen! */

    Q1vsQ2(&QKol, kq1, kq2, h);

    V_NEG(h, h);
    Q1vsQ2(&QKol, kq2, kq1, h);

/* koennte man auch rausmachen
 */
    for (Khelp=&QKol; *Khelp; Khelp=&((*Khelp)->Naechste))
      ;
    *Khelp = *K;
    *K = QKol;
}








static void QKantevsEbene(TKollision **K,
	TVektor p, TVektor k, TVektor n, TKoerper *kq, TKoerper *ke, TReal bk)
/* Alle Koordinaten in raumfesten Koordinaten
 * p - Anfangspunkt der Kante, k - Kantenvektor,
 * n - Normalenvektor der Ebene
 * bk - Betrag von k
 */
{
    TKollision *kol;
    TReal nk, alpha, alpha_d;

#ifdef DEBUG_QvsE
    printvektor("p = ", p);
    printvektor("k = ", k);
    printvektor("n = ", n);
    printf("|k| = %f !\n", bk);
#endif

    nk = V_PRODUKT(k, n);
    if (fabs(nk) <= REAL_EPSILON) return;

    alpha = - ( p[0]*n[0] + p[1]*n[1] + p[2]*n[2] ) / nk;

#ifdef DEBUG_QvsE
    printf("alpha = %f\n", alpha);
#endif

    if (alpha < 0.0 || alpha >1.0) return;

    kol = KollStrukturAnfordern();
    kol->Koerper1 = kq->OberKoerper;            /* Kollisionstruktur initialisieren */
    kol->Koerper2 = ke;
    kol->TeilKoerper1 = kq;
    kol->TeilKoerper2 = ke;
    kol->Naechste = *K;
    *K = kol;
    V_NEG(kol->Normale, n);
    
    if (nk<0.0) alpha_d = 1.0;
    else alpha_d = 0;

    kol->Tiefe = fabs((alpha_d-alpha) * nk);

#ifdef DEBUG_QvsE
    printf("alpha_d = %f\n", alpha_d);
    printf("kol->Tiefe = %f\n", kol->Tiefe);
#endif

    alpha = 0.5 *(alpha + alpha_d);
    /* Kollisionspunkt von der Ebene aus */
    V_ADDSKAL(kol->Ort2, p, alpha, k);

    V_ADD(kol->Ort, kol->Ort2, ke->ty->p);

#ifdef DEBUG_QvsE
    printvektor("Kol->Ort =", kol->Ort);
#endif

    /* Kollisionspunkt vom Quader aus */
    V_SUB(kol->Ort1, kol->Ort, kq->OberKoerper->ty->p);


    /* Ebenenvektoren */
    EbenenVektoren(kol->EbenenVek1, kol->EbenenVek2, kol->Normale);
}



static void QvsE(TKollision **K, TKoerper *kq, TKoerper *ke)
{
    TVektor n, k2, kx, ky, kz, pk, p;
    TReal R, h;
    TVektor kq_KantenLaenge;

    n[0] = ke->RotTrans1[0][1];   /* y' -Normale der Ebene in raumfesten Koord. */
    n[1] = ke->RotTrans1[1][1];
    n[2] = ke->RotTrans1[2][1];
    
    /* Teste Ebene gegen Umschliessende Kugel(Q) */
    R = kq->Kugelhuellenradius;

#ifdef DEBUG_KvsQ
    printf("Radius der den Quader umgebende Kugel is R=%f\n", R);
#endif

    V_SUB(pk, kq->ty->p, ke->ty->p);
    h = V_PRODUKT(pk, n);
    if (fabs(h)>R) return;	/* Kein Schnitt Ebene vs Kugel */

#ifdef DEBUG_KvsQ
    printf("Schnitt Quader<>EbeneRadius moeglich\n");
#endif
    
    /* Kanten des Quaders als einzelne Vektoren kx, ky, kz */ 
    if (kq->Art == QUADER) {
	V_LET(kq_KantenLaenge, kq->Form.Quader.KantenLaenge);
    }
    else { /* Simulation eines Zylinders durch einen Quader */
	V_SKALAR(kq_KantenLaenge, kq->HalbeKantenlaenge, 2.0);
    }

    kx[0] = kq->RotTrans1[0][0] * kq_KantenLaenge[0];
    kx[1] = kq->RotTrans1[1][0] * kq_KantenLaenge[0];
    kx[2] = kq->RotTrans1[2][0] * kq_KantenLaenge[0];
    
    ky[0] = kq->RotTrans1[0][1] * kq_KantenLaenge[1];
    ky[1] = kq->RotTrans1[1][1] * kq_KantenLaenge[1];
    ky[2] = kq->RotTrans1[2][1] * kq_KantenLaenge[1];
    
    kz[0] = kq->RotTrans1[0][2] * kq_KantenLaenge[2];
    kz[1] = kq->RotTrans1[1][2] * kq_KantenLaenge[2];
    kz[2] = kq->RotTrans1[2][2] * kq_KantenLaenge[2];
        
    k2[0] = 0.5 * (kx[0]+ky[0]+kz[0]);
    k2[1] = 0.5 * (kx[1]+ky[1]+kz[1]);
    k2[2] = 0.5 * (kx[2]+ky[2]+kz[2]);

    V_SUB(p, pk, k2);

    /* alle 14 Kanten mit Ebene testen */


    /* P4 */
    QKantevsEbene(K, p, kx, n, kq, ke, kq_KantenLaenge[0]);
    QKantevsEbene(K, p, ky, n, kq, ke, kq_KantenLaenge[1]);
    QKantevsEbene(K, p, kz, n, kq, ke, kq_KantenLaenge[2]);
    
    V_INC(p, kz);			/* P5 */
    QKantevsEbene(K, p, kx, n, kq, ke, kq_KantenLaenge[0]);
    QKantevsEbene(K, p, ky, n, kq, ke, kq_KantenLaenge[1]);

    V_INC(p, ky);    			/* P6 */
    QKantevsEbene(K, p, kx, n, kq, ke, kq_KantenLaenge[0]);

    V_INC(p, kx);			/* P8 */
    V_DEC(p, ky);
    QKantevsEbene(K, p, ky, n, kq, ke, kq_KantenLaenge[1]);

    V_DEC(p, kz);    			/* P1 */
    QKantevsEbene(K, p, ky, n, kq, ke, kq_KantenLaenge[1]);
    QKantevsEbene(K, p, kz, n, kq, ke, kq_KantenLaenge[2]);
    
    V_INC(p, ky);			/* P2 */
    QKantevsEbene(K, p, kz, n, kq, ke, kq_KantenLaenge[2]);
    
    V_DEC(p, kx);			/* P3 */
    QKantevsEbene(K, p, kx, n, kq, ke, kq_KantenLaenge[0]);
    QKantevsEbene(K, p, kz, n, kq, ke, kq_KantenLaenge[2]);
}



static void KvsZ(TKollision **K, TKoerper *kk, TKoerper *kz)
{
    TVektor z, a, b, c, y;
    TReal ba, aa, bb, Rz, Rk, h, f;
    TKollision *kol;


    /* Symmetrieachse(Z') in raumfeste Koordinaten umwandeln */
    z[0] = kz->RotTrans1[0][2];
    z[1] = kz->RotTrans1[1][2];
    z[2] = kz->RotTrans1[2][2];		/* -> Betrag von z ist 1 */

    /* Vektor von Zylinderschwerpunkt zum Kugelschwerpunkt */
    V_SUB(a, kk->ty->p, kz->ty->p);
    ba = V_BETRAG(a);
    if (ba>(kk->Kugelhuellenradius + kz->Kugelhuellenradius)) return;
    if (ba==0.0) return;	/* Schwerpunkte liegen aufeinander */
    
    
    /* Faktoren entlang der z-Achse(bb) sowie der Abstand zw. Kugel und Z'-Achse(aa) */
    bb = V_PRODUKT(a,z);
    aa = sqrt(fabs(a[0]*a[0]+a[1]*a[1]+a[2]*a[2] - bb*bb));

    Rz = kz->Form.Zylinder.Radius;
    h =  kz->Form.Zylinder.Hoehe * 0.5;
    Rk = kk->Form.Kugel.Radius;

#ifdef DEBUG_KvsZ
    printf("Rz=%f Rk=%f, h=%f, aa=%f, bb=%f\n", Rz, Rk, h, aa, bb); 
#endif

    if ((fabs(aa)>(Rz+Rk)) || (fabs(bb)>(h+Rk)))
      return ;						/* kein Schnitt */

    kol = KollStrukturAnfordern();
    kol->Koerper1 = kk->OberKoerper;          /* Kollisionstruktur initialisieren */
    kol->Koerper2 = kz->OberKoerper;
    kol->TeilKoerper1 = kk;
    kol->TeilKoerper2 = kz;
    kol->Naechste = *K;
    *K = kol;

    /* b-Vektor(ausserer Zylinderpunkt) errechnen */
    if (fabs(bb)<h) f=bb; else f = (bb>=0.0) ? h : -h;
    V_SKALAR(b, z, f);

    /* y-Vektor (senkrecht zu z, in Ebene a,z) errechnen, Betrag y=1 */
    y[0] = (a[0] - bb*z[0])/aa;
    y[1] = (a[1] - bb*z[1])/aa;
    y[2] = (a[2] - bb*z[2])/aa;

    if (fabs(aa)<Rz) f=aa; else f = (aa>=0.0) ? Rz : -Rz;
    b[0] += f*y[0];    
    b[1] += f*y[1];    
    b[2] += f*y[2];

    if (fabs(aa)>=Rz) {
	if (fabs(bb)<=h) {
#ifdef DEBUG_KvsZ
	    printf("FALL1\n");
#endif
	    V_SUBSKAL(c, a, Rk, y);
	    V_NEG(kol->Normale, y);	
	}
	else { /* fabs(bb)>h */
#ifdef DEBUG_KvsZ
	    printf("FALL2\n");
#endif
	    V_SUB(kol->Normale, b, a);
	    f = 1.0 / V_BETRAG(kol->Normale);
	    V_SKALAR(kol->Normale, kol->Normale, f);
	    V_ADDSKAL(c, a, Rk, kol->Normale);
	}
    }
    else {	/* fabs(aa)<Rz */
	if (fabs(bb)>=h) {
#ifdef DEBUG_KvsZ
	    printf("FALL3\n");
#endif
	    if (bb>0.0) {V_NEG(kol->Normale, z);} else {V_LET(kol->Normale, z);}
#ifdef DEBUG_KvsZ
            printvektor("kol->Normale=", kol->Normale);
            printvektor("a=", a);
            printvektor("z=", z);
#endif
	    V_ADDSKAL(c, a, Rk, kol->Normale);
#ifdef DEBUG_KvsZ
            printvektor("c=", c);
#endif
	}
	else { /* fabs(bb)<h */
#ifdef DEBUG_KvsZ
	    printf("FALL4\n");
#endif
	    f = -1.0/ba;
	    V_SKALAR(kol->Normale, a, f);
	    V_ADDSKAL(c, a, Rk, kol->Normale);
	}
    }

    
#ifdef DEBUG_KvsZ
    printf("aa=%f, bb=%f\n", aa, bb); 
    printf("z=%f %f %f\n", z[0], z[1], z[2]);
    printf("y=%f %f %f\n", y[0], y[1], y[2]);
    printf("a=%f %f %f\n", a[0], a[1], a[2]);
    printf("b=%f %f %f\n", b[0], b[1], b[2]);
    printf("c=%f %f %f\n", c[0], c[1], c[2]);
#endif

    /* Kollisionspunkt vom Zylinder aus */
    V_ADD(kol->Ort2, c, b);
    V_SKALAR(kol->Ort2, kol->Ort2, 0.5);
	
    /* raumfester Kollisionspunkt */
    V_ADD(kol->Ort, kz->ty->p, kol->Ort2);
    V_SUB(kol->Ort2, kol->Ort, kz->OberKoerper->ty->p); /* von OberKoerper aus */

    /* Kollisionspunkt von Kugel aus (OberKoerper der Kugel!) */
    V_SUB(kol->Ort1, kol->Ort, kk->OberKoerper->ty->p);


#ifdef DEBUG_KvsZ
    printf("ort = %f %f %f\n", kol->Ort[0], kol->Ort[1], kol->Ort[2]);
    printf("normale = %f %f %f\n", kol->Normale[0], kol->Normale[1], kol->Normale[2]);
#endif

    /* Ebenenvektoren */
    EbenenVektoren(kol->EbenenVek1, kol->EbenenVek2, kol->Normale);
	
    /* Kollisionstiefe */
    V_DEC(c, b);
    kol->Tiefe = V_BETRAG(c);
}



static void KvsQ(TKollision **K, TKoerper *kk, TKoerper *kq)
{
    TVektor a, b, c, n, k2, h;
    TReal ba, bn, R, f;
    TKollision *kol;


#ifdef DEBUG_KvsQ
    printf("KvsQ()\n");
#endif
    /* Abstand von Quaderschwerpunkt zum Kugelschwerpunkt */
    V_SUB(h, kk->ty->p, kq->ty->p);
    MV_MUL2(a, kq->RotTrans, h);	/* in koerperkoord. des Quaders! */
    ba = V_BETRAG(a);
    /* liegen umgebenede Kugeln ineinander, oder Schwerpunkte aufeinander ? */

    if ((ba>(kk->Kugelhuellenradius + kq->Kugelhuellenradius)) ||
	ba==0.0)
	return;

    /* halbe KantenLaenge in koerperfesten Koordinaten */
    V_LET(k2, kq->HalbeKantenlaenge);

    /* liegt Kollision vor? */
    R = kk->Form.Kugel.Radius;


#ifdef DEBUG_KvsQ
    printf("R=%f\n", R);
    printvektor("a'= ", a);
    printvektor("k2= ", k2);
#endif

    /* Berechne aeusseren Kugelpunkt!(Punkt auf Kugeloberflaeche)
     */
    f = (ba - R)/ba;
    V_SKALAR(h, a, f);

    /* liegt aeusserer Kugelpunkt innerhalb des Quaders? 
     */
/* auch Falsch!!!!

    if (fabs(h[0]) > k2[0] || 
        fabs(h[1]) > k2[1] || 
        fabs(h[2]) > k2[2])
      return;
*/ /* nein */

/* Falsch
    if (fabs(a[0]) > R+k2[0] || 
        fabs(a[1]) > R+k2[1] || 
        fabs(a[2]) > R+k2[2])
      return;	/* nein *
*/
    
    /* bestimme Vektor b der im Quader liegt */
    if (fabs(a[0])<=k2[0]) b[0] =  a[0]; else b[0] = (a[0]>=0.0) ? k2[0] : -k2[0];
    if (fabs(a[1])<=k2[1]) b[1] =  a[1]; else b[1] = (a[1]>=0.0) ? k2[1] : -k2[1];
    if (fabs(a[2])<=k2[2]) b[2] =  a[2]; else b[2] = (a[2]>=0.0) ? k2[2] : -k2[2];

    V_SUB(h, b, a);
    if (V_BETRAG(h) > R) return;

    kol = KollStrukturAnfordern();
    kol->Koerper1 = kk->OberKoerper;	/* Kollisionstruktur initialisieren */
    kol->Koerper2 = kq->OberKoerper;
    kol->TeilKoerper1 = kk;
    kol->TeilKoerper2 = kq;
    kol->Naechste = *K;
    *K = kol;

#ifdef DEBUG_KvsQ
    printvektor("b= ", b);
#endif

    /* bestimme Normalenvektor von Kugelschwerpunkt zu Punkt b */
    V_SUB(n, b, a);
    bn = V_BETRAG(n);
    if (bn == 0.0) {
	n[0] = -a[0]/ba;
	n[1] = -a[1]/ba;
	n[2] = -a[2]/ba;
    }
    else {
	bn = 1.0/bn;
	V_SKALAR(n, n, bn);
    }

#ifdef DEBUG_KvsQ
    printvektor("n= ", n);
#endif

    /* Oberflaechenpunkt c der Kugel */
    V_SKALAR(c, n, R);
    V_INC(c, a);

#ifdef DEBUG_KvsQ
    printvektor("c=", c);
#endif

    /* Kollisionspunkt von Quader aus */
    h[0] = (b[0]+c[0])*0.5;
    h[1] = (b[1]+c[1])*0.5;
    h[2] = (b[2]+c[2])*0.5;
    MV_MUL2(kol->Ort2, kq->RotTrans1, h);

    /* raumfester Kollisionspunkt */
    V_ADD(kol->Ort, kq->ty->p, kol->Ort2);

    /* Kollisionspunkt von OberKoerper des Quader aus */
    V_SUB(kol->Ort2, kol->Ort, kq->OberKoerper->ty->p);

    /* Kollisionspunkt von (OberKoerper der)Kugel aus */
    V_SUB(kol->Ort1, kol->Ort, kk->OberKoerper->ty->p);

    /* Normalenvektor setzen und Ebenenvektoren ausrechnen */
    MV_MUL2(kol->Normale, kq->RotTrans1, n);

    EbenenVektoren(kol->EbenenVek1, kol->EbenenVek2, kol->Normale);
    
    /* Kollisionstiefe bestimmen */
    V_DEC(b, c);
    kol->Tiefe = V_BETRAG(b);
}





static void KvsE(TKollision **K, TKoerper *kk, TKoerper *ke)
{
    TVektor s_abstand;
    TVektor n;
    TReal a, tiefe;
    TKollision *ko;


    V_SUB(s_abstand, ke->ty->p, kk->ty->p);

    n[0] = - ke->RotTrans1[0][1];   /* y' -Normale */
    n[1] = - ke->RotTrans1[1][1];
    n[2] = - ke->RotTrans1[2][1];
    

    a = V_PRODUKT(s_abstand, n);
    if (a == 0.0 || fabs(a) > kk->Form.Kugel.Radius) {
	/* Kugel-Schwerwpunkt liegt in der Ebene */ 
	return; 
    }
    else {
	ko = KollStrukturAnfordern();
	tiefe = kk->Form.Kugel.Radius -fabs(a);
	ko->Tiefe = tiefe;
	ko->Koerper1 = kk->OberKoerper;
	ko->Koerper2 = ke;
	ko->TeilKoerper1 = kk;
	ko->TeilKoerper2 = ke;
	ko->Naechste = *K;
	*K = ko;
    }
    
    V_LET(ko->Normale, n);
    V_SKALAR(ko->Ort1, n, a);
    V_ADD(ko->Ort, ko->Ort1, kk->ty->p);
    if (kk->OberKoerper != kk) {
	V_SUB(ko->Ort1, ko->Ort, kk->OberKoerper->ty->p);
    }
    V_SUB(ko->Ort2, ko->Ort, ke->ty->p);
    
    ko->EbenenVek1[0] = ke->RotTrans1[0][0];
    ko->EbenenVek1[1] = ke->RotTrans1[1][0];
    ko->EbenenVek1[2] = ke->RotTrans1[2][0];

    ko->EbenenVek2[0] = ke->RotTrans1[0][2];
    ko->EbenenVek2[1] = ke->RotTrans1[1][2];
    ko->EbenenVek2[2] = ke->RotTrans1[2][2];
}




static void KvsK(TKollision **K, TKoerper *k1, TKoerper *k2)
/***************************************************************************
 * Kugel k1 gegen Kugel k2 auf Kollision Pruefen
 *
 */
{
    TVektor Abstand;	/* Vektor-Abstand von Kugel1 nach Kugel2 */
    TReal Entfernung;   /* Betrag vom Vektor Abstand */
    TReal EindringTiefe;
    TKollision *k;
    TReal h;		/* Hilfsvariablen */

    V_SUB(Abstand, k2->ty->p, k1->ty->p);
    Entfernung = V_BETRAG(Abstand);

    if (Entfernung==0.0) return;	/* Schwerpunkte liegen aufeinander */
    
    EindringTiefe = ((k1->Form.Kugel.Radius + k2->Form.Kugel.Radius) - Entfernung);

    if (EindringTiefe  < 0.0) {
	return;				/* Koerper Uerberschneiden sich nicht */
    } else {
	k = KollStrukturAnfordern();
    }

    k->Koerper1 = k1->OberKoerper;
    k->Koerper2 = k2->OberKoerper;
    k->TeilKoerper1 = k1;
    k->TeilKoerper2 = k2;
    k->Tiefe = EindringTiefe;
    k->Naechste = *K;
    *K = k;

    h = 1.0/Entfernung;			/* Normalenvektor von k1 nach k2*/
    V_SKALAR(k->Normale, Abstand, h);

    h = k1->Form.Kugel.Radius - 0.5*EindringTiefe;
    V_SKALAR(k->Ort1, k->Normale, h);	  /* KolOrt bzgl Kugel1(raumfest) */

    V_ADD(k->Ort, k1->ty->p, k->Ort1);	  /* Beruehrungsort bezueglich K(absolut)*/
    /* Beruehrungsort bezueglich OberKoerper der Kugel1 */
    if (k1!=k1->OberKoerper) {
	V_SUB(k->Ort1, k->Ort, k1->OberKoerper->ty->p);
    }
    /* Beruehrungsort bezueglich OberKoerper der Kugel2 */
    V_SUB(k->Ort2, k->Ort, k2->OberKoerper->ty->p);

    /* Beruehrungebene berechnen */
    EbenenVektoren(k->EbenenVek1, k->EbenenVek2, k->Normale);
}


static void CvsX(TKollision **K, TKoerper *kz, TKoerper *kx)
/***************************************************************************
 * Zusammengesetztes(composed) Objekt kz gegen beliebigen Koerper kx
 *
 */
{
    TVektor h;
    TKoerper *ek;
    signed char arg;

/*    printf("CvsX()\n");
*/
    if (kz->Art != ZUSGESOBJ) exit(99);

    switch(kx->Art) {   /* mit umgebender Kugelhuelle Testen falls moeglich */
    case KUGEL:
    case QUADER:
    case ZYLINDER:
    case ZUSGESOBJ:
	V_SUB(h, kz->ty->p, kx->ty->p);
	if (((V_BETRAG(h)) - kz->Kugelhuellenradius - kx->Kugelhuellenradius) > 0.0)
	    return;
    default:
	break;
    }

    /* jeden Koeper aus Koerperliste des ZusGesObj mit Koerper x testen
     */
    for (ek=kz->Form.ZusGesObj.KoerperListe; ek; ek=ek->Naechster) {

	/* keine Kollisionserkennung zwischen zwei Masselosen(unbeweglichen)
	 * Koerpern.
	 */
	if ((ek->BewTyp & MASSELOS) && (kx->BewTyp & MASSELOS)) continue;

	if ((kx->Art < MAXFORM) && (ek->Art < MAXFORM)) {
	    arg = KolArg[kx->Art][ek->Art];
	    if (arg>0) KolRoutine[kx->Art][ek->Art](K, ek, kx);
	    else if (arg<0) KolRoutine[kx->Art][ek->Art](K, kx, ek);
	}
	else Fehler("Koerperart unbekannt!");
    }
}


void KoerperKollision(TKollision **K, TKoerper *k1, TKoerper *k2)
{
    signed char arg;

    FehlerOrt("KoerperKollision()");

    KollBloeckeLoeschen();
    *K = NULL;

    for (; k2; k2 = k2->Naechster) {
    	if (k2->Art < MAXFORM && k1->Art < MAXFORM) {
	    arg = KolArg[k2->Art][k1->Art];
	    if (arg>0) KolRoutine[k2->Art][k1->Art](K, k1, k2);
	    else if (arg<0) KolRoutine[k2->Art][k1->Art](K, k2, k1);
	}
	else Fehler("Koerperart unbekannt!");
    }
}


void KolListeLoeschen(TKollision **k)
{
    KollBloeckeLoeschen();
    *k = NULL;
}


void KollisionsErkennung(TZustand *Z, TKollision **K)
{
    TKoerper *k1, *k2;
    signed char arg;


    FehlerOrt("KollisionsErkennung()");

    KollBloeckeLoeschen();
    *K = NULL;

    for (k1 = Z->Koerper; k1; k1 = k1->Naechster) {
	for (k2 = k1->Naechster; k2; k2 = k2->Naechster) {
	    /* keine Kollisionserkennung zwischen zwei Masselosen(unbeweglichen)
	     * Koerpern.
	     */
	    if ((k1->BewTyp & MASSELOS) && (k2->BewTyp & MASSELOS)) continue;
	    /* Nur Koerper testen bei denen Kollision erlaubt ist
	     *
	     */
	    if ((k1->BewTyp & KOLL)==0 || (k2->BewTyp & KOLL)==0) continue;
/*
	    if (((k1->BewTyp & k2->BewTyp) & KOLL) == 0) continue;
*/

	    if ((k2->Art < MAXFORM) && (k1->Art < MAXFORM)) {
		arg = KolArg[k2->Art][k1->Art];
		if (arg>0) KolRoutine[k2->Art][k1->Art](K, k1, k2);
		else if (arg<0) KolRoutine[k2->Art][k1->Art](K, k2, k1);
	    }
	    else Fehler("Koerperart unbekannt!");
	}
    }


#ifndef NODEBUG
    if (ke_debug_level>0) {
	TKollision *kh;

	for (kh = *K; kh; kh = kh->Naechste) {
	    printkollision(kh);
	    printf("\n");
	}  
    }
#endif
}


void KolListeSpeicherfreigabe(TKollision **K)
{
    KollBlockSpeicherFreigeben();    
    *K = NULL;
}
