/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: gleichungsloeser.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: gleichungsloeser.o
 *  Version           	: 0.0.1
 *  letzte Aenderung	: 02.12.92
 *  Autor		: Horst Stolz (HUS)
 *  Status:		: getestet
 *  
 *  Beschreibung:
 *    Modul liefert allgemeines Loesungsverfahren fuer Lin. Gleichungssysteme
 *  
 *  Exportierte Funktionen/Makros:
 *     TBoolean LinGleichLoeser(int n, TReal *a, TReal *x) 
 *
 *  Noch zu machen:
 *
 *  Versionsgeschichte:
 *  
 ********************************************************************************/
#ifndef GLEICHUNGSLOESER_H
#define GLEICHUNGSLOESER_H


#ifndef GRUNDTYPEN_H
#include "grundtypen.h"
#endif


TBoolean LinGleichLoeser(int n, TReal *a, TReal *x);
/****************************************************************************
 *   
 * Zweck:         Loesen eines Linearen Gleichungssystems mit n Unbekannten
 *                und n Gleichungen.
 *   
 * Parameter:     n - Anzahl der Unbekannten
 *                x - Ergebnisvektor (Groesse n) (Ergebnis-Vektor)
 *                a - Feld von Gleichungskoeffizienten (n+1)*n gross
 *                Folgendes Gleichungssystem wird geloest:
 *
 *     x[0]*a[0]               ..  x[n-1]*a[n-1]             = a[n]
 *
 *     x[0]*a[0+(n+1)*(n-1)]   ..  x[n-1]*a[n-1+(n+1)*(n-1)] = a[n+(n+1)*(n-1)]
 *   
 *     Formel fuer bel. Zugriff auf a: 
 *        a[x+y*(n+1)] mit x=Spalte, y=Zeile
 *   
 * Rueckgabewert:
 *     TRUE wenn System nicht geloest werden konnte, somit is x ungueltig
 *     FALSE wenn Gleichungen geloest werden konnte => x steht Ergebnis
 *   
 * Seiteneffekte:
 *     keine
 *   
 * Beispiel:
 *   
 * Siehe weiter:
 *   
 * Fehler:
 *   
 */


extern TReal *lcp_x;		/* Zuweisung ueber LCP_SET.. */
extern TReal *lcp_w;		/* Ergebnisbvektoren w un z */
extern TReal *lcp_z;
extern int lcp_n;		/* LCP-Groesse */

#define LCP_SET_Q(i,x)		lcp_x[(2*lcp_n+1)*lcp_n+(i)] = x
#define LCP_SET_M(i,j,x)	lcp_x[(lcp_n+(j))*lcp_n+(i)] = - x


void LCP_Init(int n);
TBoolean LCP_Loeser();		/* mit LCP_Init(n); init., mit LCP_SET_.. belgen */
				/* nach aufruf von LCP_Loeser ->Erg in lcp_w, lcp_z */
				/* Rueckgabe TRUE ->Nicht loesbar */
void LCP_Free();

extern int gl_debug_level;

#endif
