/********************************************************************************
 *  Projektname		: AERO - Teilprojekt FSB
 *  Filename		: beruehrung.c
 *  Filetyp		: C-Source
 ********************************************************************************
 *  Modulname		: beruehrung.o
 *  letzte Aenderung	: 02.04.93
 *  Autor		: Horst Stolz (HUS)
 *  
 *  Beschreibung:
 *    Berechnet die an den Beruehrpunkten auftretenden Kraefte
 *  
 *  Noch zu machen:
 *
 *  Versionsgeschichte:
 *  29.02.93	Erstellungsdatum
 *  31.03.93    Haftreibung und Federstoss eingebaut,
 *              Die exakte Berechnung wird nicht mehr unterstuetzt!
 *              (Man kann also zwischen "meiner" Penality-Methode und der
 *              Federstoss-Methode waehlen per K_FederStoss!
 *  02.04.93    Wegen ZusGesObj nun die Materialien aus TeilKoerper?-> nehmen
 *  
 ********************************************************************************/

#include <math.h>

#include "koerper.h"
#include "fehler.h"
#include "vektor.h"
#include "beruehrung.h"
#include "gleichungsloeser.h"
#include "konfig.h"
#include "materialien.h"

int b_debug_level = 0;





void Beruehrung(TKollision *Kollisionen, TMaterialTabelle *mt)
/****************************************************************************
 * Zweck:
 *   Bei allen Kollisionspunkten, in der angegeben Kollisions-Liste, die
 *   vom Typ BERUEHRUNG sind werden die Normalenkraefte(Beruehrungskraefte) 
 *   sowie die Reibungskraefte(Haft&Gleitreibung) berechnet, und in die
 *   Bewegungsgleichungen eingebracht. Dies geschieht indem die Kraefte
 *   zu Koerper->a und Koerper->u dazuaddiert werden unter Beruecksichtigung
 *   des Angriffsortes.
 *   Wenn der Konfigurationsparameter K_FederStoss auf TRUE steht wird 
 *   die Normalenkraft nur proportional zur Durchdringungstiefe errechnet
 *   (beim Entfernen, also Normgeschw<0 wird die Elastizitaetszahl verrechnet) 
 *   Einbringen der Beruehrungskraeft die aufgrund der in der 
 *   Kollisions-Liste enthaltenen Beruehrungspunkte (Typ BERUEHRUNG)
 *   
 * Parameter:
 *   Liste von Kollisionen und Materialtabelle Zwecks Ermittlung der
 *   Geleit-, Haft-, Elastizitaets-, Dehn- und Daempfungsfaktoren.
 *   
 * Rueckgabewert: 
 *   keine
 *   
 * Seiteneffekte:
 *   Fuer alle Koerper die nicht MASSELOS sind und in der Kollisionsliste 
 *   bei einer BERUEHRUNG auftauchen wird die Normalen&Reibungskraft zu
 *   Koerper->a und Koerper->u dazuverrechnet!
 *
 * Bemerkung:
 *   Damit auch Stoesse bei gesetztem FederStoss-Parameter behandelt werden
 *   muss der KollisionsTest (KTest(..) in kollisionsbehandlung.c) jede
 *   Kollision als Beruehrung markieren, unabhaengig von ihrer
 *   Normalgeschwindigkeit.
 *   
 */
{
    TVektor F, M, tv, R;
    TReal h, f, btv, r;
    TKollision *kol;
    TReal normgeschw;

    FehlerOrt("Beruehrungsbehandlung");


#ifndef NODEBUG
    if (b_debug_level >= 1)
      printf("Beruehrung(ko, mat) 1-\n");
#endif


    for (kol = Kollisionen; kol; kol = kol->Naechste)
      if (kol->Art == BERUEHRUNG) {
	  

	  /* Normalgeschindigkeit des Beruehrungspunktes zwischen 
	   * den zwei Koerpern bestimmen
	   */
	  normgeschw =
	    NormGeschw(kol->Koerper1->ty->v, kol->Koerper1->ty->w, kol->Ort1,
		       kol->Koerper2->ty->v, kol->Koerper2->ty->w, kol->Ort2,
		       kol->Normale);

	  if (Konfiguration.K_FederStoss) {
	      /* Beruehrungs und Stosskraft beim Eindringen proportional
               * zur Durchdringungstiefe, beim Entfernen(normge<0) wird
               * der Elastizitaetsfaktor dazugenommen
	       */
	      f = kol->Tiefe * 
		Dehnungsfaktor(mt, kol->TeilKoerper1->Material, 
			       kol->TeilKoerper2->Material);
	      if (normgeschw<0.0) 
		f *= Elastizitaet(mt, 
				  kol->TeilKoerper1->Material,
				  kol->TeilKoerper2->Material);

	      V_SKALAR(F, kol->Normale, f);

	  }
	  else {
	      /* Beruehrungskraft durch Feder+Daempfer
	       */

	      if (normgeschw<0.0) normgeschw = 0.0;

	      
	      /* Normalkraft F nach Penality-Methode ausrechnen
	       */

	      f = kol->Tiefe * 
		Dehnungsfaktor(mt, kol->TeilKoerper1->Material, 
                               kol->TeilKoerper2->Material) +
		  Daempfungsfaktor(mt, kol->TeilKoerper1->Material, 
                                   kol->TeilKoerper2->Material)
		    *normgeschw;
	      V_SKALAR(F, kol->Normale, f);
	      
	  }

	  /* Gleitreibungskraft oder Haftreibungskraft zu Kraft F dazuaddieren.
	   * dabei gilt: Haftreibung wenn Tangentialgeschw<=R_MinRollGeschw
	   *             Geitreibung bei Tangentialgeschw<=R_MinGleitGeschw
	   */
	  btv = TanGeschw(tv,
			  kol->Koerper1->ty->v, kol->Koerper1->ty->w, kol->Ort1,
			  kol->Koerper2->ty->v, kol->Koerper2->ty->w, kol->Ort2,
			  kol->Normale);
	  
	  if (btv>Konfiguration.R_MinRollGeschw) {
	      if (btv>Konfiguration.R_MinGleitGeschw) {
		  /* Gleitreibung
		   */
		  r = f * Gleitreibung(mt, kol->TeilKoerper1->Material, 
				       kol->TeilKoerper2->Material);
		  h = r / btv;
		  V_SKALAR(R, tv, h); 
		  V_INC(F, R);
	      } else {
		  /* Haftreibung
		   */
/*
		  printf("f = %f, btv = %f, minv = %f\n",
			 f, btv, Konfiguration.R_MinRollGeschw);
*/
		  h = (f / Konfiguration.R_MinGleitGeschw) * 
		    Haftreibung(mt, kol->TeilKoerper1->Material, 
				kol->TeilKoerper2->Material);
		  V_SKALAR(R, tv, h); 
/*		  printvektor("Haftreibung = ", R); */
		  V_INC(F, R);
		  r = h * btv;
	      }
	  }
	  else r = 0.0;



	  /* Kraft in Bewegungsgleichung der Koerper einbringen
	   */

	  if ((kol->Koerper1->BewTyp & MASSELOS) == 0) {
	      V_DEC(kol->Koerper1->a, F);
	      V_MUL(M, kol->Ort1, F);
	      V_DEC(kol->Koerper1->u, M);
	  }
	  
	  if ((kol->Koerper2->BewTyp & MASSELOS) == 0) {
	      V_INC(kol->Koerper2->a, F);
	      V_MUL(M, kol->Ort2, F);
	      V_INC(kol->Koerper2->u, M);
	  }
	  

#ifndef NODEBUG
	  if (b_debug_level >= 2)
	    printf("Beruehrung(ko, mat) 1- Kraft F=%f, R=%f\n", f, r);
#endif
	  
      }
	
    return;
}


#if 0
/* Alte Routine mit exakter(falscher) Berechnung der Beruehrungskraefte
 */

static TReal RollKoeff = 1.0;       
static TReal Kraftfaktor = 1;
static TReal Tiefenfaktor = 1.0;


void Beruehrung_alt(TKollision *Kollisionen, TMaterialTabelle *mt)
{
    TVektor z1, z2, h1, h2, h3, F, M, tv, R, t1, t2;
    TReal h, f, btv, r, bt1, bt2;
    TKollision *ber_i, *ber_l, **ber, *Beruehrungen, *kol;
    int anzber;
    TReal normgeschw;

    FehlerOrt("Beruehrungsbehandlung");


#ifndef NODEBUG
    if (b_debug_level >= 1)
      printf("Beruehrung(ko, mat) 1-\n");
#endif


    if (Konfiguration.B_PenalityMethode) {
	for (kol = Kollisionen; kol; kol = kol->Naechste)
	    if (kol->Art == BERUEHRUNG) {

		normgeschw = NormGeschw(kol->Koerper1->ty->v, kol->Koerper1->ty->w, kol->Ort1,
					kol->Koerper2->ty->v, kol->Koerper2->ty->w, kol->Ort2,
					kol->Normale);
		if (normgeschw<0.0) normgeschw = 0.0;


		f = kol->Tiefe * 
		    Dehnungsfaktor(mt, kol->TeilKoerper1->Material, kol->TeilKoerper2->Material)
		    + Daempfungsfaktor(mt, kol->TeilKoerper1->Material, kol->TeilKoerper2->Material)*normgeschw;

		V_SKALAR(F, kol->Normale, f);

		btv = TanGeschw(tv,
		      kol->Koerper1->ty->v, kol->Koerper1->ty->w, kol->Ort1,
		      kol->Koerper2->ty->v, kol->Koerper2->ty->w, kol->Ort2,
		      kol->Normale);


		if (btv>Konfiguration.R_MinGleitGeschw) {
		    r = f * Gleitreibung(mt, kol->TeilKoerper1->Material, 
			                 kol->TeilKoerper2->Material);
		    h = r / btv;
		    V_SKALAR(R, tv, h); 
		    V_INC(F, R);
		} else r = 0;

	    if ((kol->Koerper1->BewTyp & MASSELOS) == 0) {
		V_DEC(kol->Koerper1->a, F);
		V_MUL(M, kol->Ort1, F);
		V_DEC(kol->Koerper1->u, M);
	    }

	    if ((kol->Koerper2->BewTyp & MASSELOS) == 0) {
		V_INC(kol->Koerper2->a, F);
		V_MUL(M, kol->Ort2, F);
		V_INC(kol->Koerper2->u, M);
	    }


#ifndef NODEBUG
    if (b_debug_level >= 2)
      printf("Beruehrung(ko, mat) 1- Kraft F=%f, R=%f\n", f, r);
#endif

	    }
	
	return;
    }

    for (kol = Kollisionen; kol; kol = kol->Naechste) {
	kol->Koerper1->Beruehrungen = NULL;
	kol->Koerper2->Beruehrungen = NULL;
    }


    Beruehrungen = NULL;
    ber = &Beruehrungen;
    anzber = 0;
    for (kol = Kollisionen; kol; kol = kol->Naechste) {
	if (kol->Art == BERUEHRUNG) {
	    
	    kol->nr = anzber;
	    anzber++;

#ifndef NODEBUG
	    if (b_debug_level>1) printf("Beruehrung() 2- Beruehrung nr%d\n", kol->nr);
#endif

	    /* d, e1 und e2 vorrechnen */

	    if ((kol->Koerper1->BewTyp & MASSELOS) != MASSELOS) {

		h = 1.0/kol->Koerper1->Masse;

		V_MUL(h1, kol->Ort1, kol->Normale);
	        MV_MUL2(kol->e1, kol->Koerper1->Traegheitstensor1, h1);
	    }
	    else {
		h = 0.0;
		V_SET(kol->e1, 0.0, 0.0, 0.0);
	    }

	    if ((kol->Koerper2->BewTyp & MASSELOS) != MASSELOS) {

		h -= 1.0/kol->Koerper2->Masse;

		V_MUL(h1, kol->Ort2, kol->Normale);
	        MV_MUL2(kol->e2, kol->Koerper2->Traegheitstensor1, h1);
	    }
            else {
		V_SET(kol->e2, 0.0, 0.0, 0.0);
	    }

	    V_SKALAR(kol->d, kol->Normale, h);

#ifndef NODEBUG
	    if (b_debug_level>1) {	
	    printvektor("Beruehrung() 2- kol->d  = ", kol->d);
	    printvektor("Beruehrung() 2- kol->e1 = ", kol->e1);
	    printvektor("Beruehrung() 2- kol->e2 = ", kol->e2);
	    }
#endif
	    *ber = kol;
	    kol->NaechsteBer = NULL;
	    ber = &(kol->NaechsteBer);
	
	    kol->KoerperBer = kol->Koerper1->Beruehrungen;
	
	    kol->Koerper1->Beruehrungen = kol;
	}
    }

    if (anzber<=0) {
#ifndef NODEBUG
	if (b_debug_level>=1) {
	    printf("Beruehrung() 1- keine Beruehrungen vorhanden?!?\n");
	}
#endif
	return ;
    }

    LCP_Init(anzber);

    for (ber_i=Beruehrungen; ber_i; ber_i = ber_i->NaechsteBer) {
	
	/*
	 * -b[i] ausrechen
	 */
	
	V_MUL(h1, ber_i->Koerper1->ty->w, ber_i->Ort1);	/* z1 = w1 x (w1 x ri1) */
	V_MUL(z1, ber_i->Koerper1->ty->w, h1);

	V_MUL(h1, ber_i->Koerper2->ty->w, ber_i->Ort2);	/* z2 = w2 x (w2 x ri2) */
	V_MUL(z2, ber_i->Koerper2->ty->w, h1);

#ifndef NODEBUG
	if (b_debug_level>1) {
	printvektor("Beruehrung() 2- z1 = ", z1);
	printvektor("Beruehrung() 2- z2 = ", z2);
	}
#endif 

/*	V_SUB(h1, z1, z2); */
	V_SET(h1, 0.0, 0.0, 0.0);

	if ((ber_i->Koerper1->BewTyp & MASSELOS) == 0) {

	    h= 1.0 / ber_i->Koerper1->Masse;
	    V_SKALAR(h2, ber_i->Koerper1->a, h);
	    V_INC(h1, h2);

	    MV_MUL2(h2, ber_i->Koerper1->Traegheitstensor1, ber_i->Koerper1->u);
	    V_MUL(h3, h2, ber_i->Ort1);
	    V_INC(h1, h3);
	}


	if ((ber_i->Koerper2->BewTyp & MASSELOS) == 0) {

	    h = 1.0 / ber_i->Koerper2->Masse;
	    V_SKALAR(h2, ber_i->Koerper2->a, h);
	    V_DEC(h1, h2);

	    MV_MUL2(h2, ber_i->Koerper2->Traegheitstensor1, ber_i->Koerper2->u);
	    V_MUL(h3, h2, ber_i->Ort2);
	    V_DEC(h1, h3);
	}

	h = -(V_PRODUKT(ber_i->Normale, h1));

#ifndef NODEBUG
	if (b_debug_level>2) printf("Beruehrung() 3- Q[%d] = %f\n", ber_i->nr, h);
#endif
	LCP_SET_Q(ber_i->nr, h);


	/* Zeile i der Matrix A belegen
	 */
        for (ber_l=ber_i->Koerper1->Beruehrungen; ber_l; ber_l=ber_l->KoerperBer) {

	    h = V_PRODUKT(ber_l->Normale, ber_i->d);

	    V_MUL(h2, ber_l->e1, ber_i->Ort1);
	    V_MUL(h3, ber_l->e2, ber_i->Ort2);
	    V_DEC(h2, h3);

	    h += V_PRODUKT(ber_i->Normale, h2);
	    
	    LCP_SET_M(ber_i->nr, ber_l->nr, h);
#ifndef NODEBUG
	if (b_debug_level>2)  printf("Beruehrung() 3- M[%d][%d] = %f\n", ber_i->nr, ber_l->nr, h);
#endif
	}
    }

    if (LCP_Loeser()) {
	printf("Beruehrung() - Konnte keine Beruehrungskraefte bestimmen! (LCP versagte)\n");
    }
    else {
	/* Beruehrungskraefte einbringen
	 */
	for (ber_i=Beruehrungen; ber_i; ber_i = ber_i->NaechsteBer) {
	    f = lcp_z[ber_i->nr];  /* ??? stimmt was mit LCP nicht??? */
	    if (f<0) {
		printf("Beruehrung() - Fehler: Beruehrungskraft f%d=%f : NEGATIV!\n"
		       , ber_i->nr, f);
		f = -f;
	    }
	    V_SKALAR(F, ber_i->Normale, f);


/*
	    MultiGeschw(&btv, tv, &bt1, t1, &bt2, t2,
		      ber_i->Koerper1->ty->v, ber_i->Koerper1->ty->w, ber_i->Ort1,
		      ber_i->Koerper2->ty->v, ber_i->Koerper2->ty->w, ber_i->Ort2,
		      ber_i->Normale);
*/

	    btv = TanGeschw(tv,
		      ber_i->Koerper1->ty->v, ber_i->Koerper1->ty->w, ber_i->Ort1,
		      ber_i->Koerper2->ty->v, ber_i->Koerper2->ty->w, ber_i->Ort2,
		      ber_i->Normale);


	    if (btv>Konfiguration.R_MinGleitGeschw) {
		r = f * Gleitreibung(mt, ber_i->TeilKoerper1->Material, 
			                 ber_i->TeilKoerper2->Material);
		h = r / btv;
		V_SKALAR(R, tv, h); 
		V_INC(F, R);
	    }
	    else {
		V_SET(R, 0.0, 0.0, 0.0);
	    }
/*
	    printf("RollgeschwA = %f\n", bt1);

	    if (bt1>Konfiguration.R_MinRollGeschw) {
	    h = Haftreibung(mt, ber_i->TeilKoerper1->Material, ber_i->TeilKoerper2->Material) 
	    * f * (1.0 - exp(-RollKoeff * bt1));
	    printf("RollreibungA = %f\n", h); 
	    h = h/bt1;
	    V_SKALAR(t1, t1, h);
	    V_DEC(F, t1); 
	    printvektor("RollkraftA = ", t1); 
	    }
	    else {
		V_SET(t1, 0.0, 0.0, 0.0);
	    }

	    printf("RollgeschwB = %f\n", bt2); 
	    if (bt2>Konfiguration.R_MinRollGeschw) {
	    h = Haftreibung(mt, ber_i->TeilKoerper1->Material, ber_i->TeilKoerper2->Material) 
	    * f * (1.0 - exp(-RollKoeff * bt2));
	    printf("RollreibungA = %f\n", h); 
	    h = h/bt2;
	    V_SKALAR(t2, t2, h);
	    V_INC(F, t2); 
	    printvektor("RollkraftB = ", t2); 
	    }
	    else {
		V_SET(t2, 0.0, 0.0, 0.0);
	    }
*/


#ifndef NODEBUG	    
	    if (b_debug_level>0) {
	    printf("Beruehrung() 1- Beruehrkraft f%d = %f, Vektor F%d",
		   ber_i->nr, f, ber_i->nr);
	    printvektor(" = ", F);
	    printf("Beruehrung() 1- Davon Gleit-Reibung "); printvektor("R = ", R);
/*            printf("RollreibungsteilA "); printvektor("T1 = ", t1); */
/*            printf("RollreibungsteilB "); printvektor("T2 = ", t2); */
	    printf("Beruehrung() 1- Tangentialgeschw%d = %f, tv%d", ber_i->nr, btv, ber_i->nr);
	    printvektor(" = ", tv);
	    }
#endif
	    if (ber_i->Tiefe >Konfiguration.B_MinBerTiefe) {
		
		h = 1.0 + Kraftfaktor * (1.0 - exp(-ber_i->Tiefe * Tiefenfaktor));
		
		V_SKALAR(F, F, h);
#ifndef NODEBUG	    
		if (b_debug_level>0) {
		    printf("Beruehrung() 1- Tiefe %f > Konfiguration.B_MinBerTiefe %f, "
			   "Verstaerkung %f\n", ber_i->Tiefe, Konfiguration.B_MinBerTiefe, h);
		    printvektor("Beruehrung() 1- Verstaerkte Kraft F = ", F);
		}
#endif
	    }


	    if ((ber_i->Koerper1->BewTyp & MASSELOS) == 0) {
		V_DEC(ber_i->Koerper1->a, F);
		V_MUL(M, ber_i->Ort1, F);
		V_DEC(ber_i->Koerper1->u, M);
	    }

	    if ((ber_i->Koerper2->BewTyp & MASSELOS) == 0) {
		V_INC(ber_i->Koerper2->a, F);
		V_MUL(M, ber_i->Ort2, F);
		V_INC(ber_i->Koerper2->u, M);
	    }
	}
    }
}

#endif


