/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: ausgabe.c
 *  Filetyp		: C-Source
 ********************************************************************************
 *  Modulname		: ausgabe.o
 *  letzte Aenderung	: 27.01.93
 *  Autor		: Horst Stolz (HUS)
 *  Status:		: ungetestetes Dummy-File
 *  
 *  Beschreibung:
 *    Liefert primitive Routinen um einen Zustand, Koerper, Kollisions,
 *    Verbindung, usw. als Text auszugeben.
 *    Und zwar zu Test und Debugging-Zwecken.
 *    Die Ausgabe erfolgt deswegen in den Fehlerkanal.
 * 
 *  Versionsgeschichte:
 *    10.01.93		Typeeinfuehrung TQuaternion beruecksichtigt
 *    27.01.93          Aenderungen in Kollisionsstruktur geaendert
 *    ....
 *  
 ********************************************************************************/

#include <stdio.h>

#include "zustand.h"
#include "kollision.h"




void printvektor(char *s, TVektor v)
{
    fprintf(stderr, "%s(%lf, %lf, %lf)\n", s, (v)[0], (v)[1], (v)[2]);
}


void printmatrix(char *s, TMatrix m)
{
    int i, j;
    
    fprintf(stderr, "%s(", s);
    for (i=0; i<3; i++) for (j=0; j<3; j++) printf("%e ", m[i][j]);
    fprintf(stderr, ")\n");
}


void printeulerpar(char *s, TQuaternion q)
{
    fprintf(stderr, "%s%e,(%e,%e,%e)\n", s, q[0], q[1], q[2], q[3]);
}


void printkollision(TKollision *kh)
{
	fprintf(stderr, "Collision between 0x%lx and 0x%lx\nType: ", kh->Koerper1, kh->Koerper2);
	switch (kh->Art) {
	case BERUEHRUNG:	fprintf(stderr, "resting\n"); break;
	case KOLLISION:		fprintf(stderr, "collision\n"); break;
	case LOSLOESUNG:        fprintf(stderr, "get AWAY\n"); break;
        default:		fprintf(stderr, "unknown collision!\n"); break;
	}
	fprintf(stderr, "Depth: %e\n", kh->Tiefe);
        printvektor("Position: ", kh->Ort);
        printvektor("Normal: ", kh->Normale);
        printvektor("Plane vector 1: ", kh->EbenenVek1);
        printvektor("Plane vector 2: ", kh->EbenenVek2);
	printvektor("Pos rel to obj 1: ", kh->Ort1);
	printvektor("Pos rel to obj 2: ", kh->Ort2);
}


void printkolliste(TKollision *k)
{
    TKollision *kh;

    if (k) for (kh = k; kh; kh = kh->Naechste) {
	printkollision(kh);
	fprintf(stderr, "\n");
    }
    else
	fprintf(stderr, "No collisions\n\n");
}


void printkoerper(TKoerper *k)
{
    if (k==NULL) {
	fprintf(stderr, "No bodys to print!\n\n");
	return;
    }
    
    fprintf(stderr, "Body(Obj) = {\n");
    switch(k->Art) {
    case KUGEL:
	fprintf(stderr, "Type = SPHERE, radius = %e\n", k->Form.Kugel.Radius);
	break;
    case QUADER:
	fprintf(stderr, "Type = CUBOID, X-edge = %e, Y-edge = %e, Z-edge = %e\n",
        	k->Form.Quader.KantenLaenge[0], k->Form.Quader.KantenLaenge[1], 
		k->Form.Quader.KantenLaenge[3]);
	break;
    case ZYLINDER:
	fprintf(stderr, "Type = ZYLINDER, height = %e, radius = %e\n", 
               k->Form.Zylinder.Hoehe, k->Form.Zylinder.Radius);
	break;
    case EBENE:
	fprintf(stderr, "Type = PLANE\n");
	break;
    case PUNKT:
	fprintf(stderr, "Type = POINT\n");
	break;
    case MPUNKT:
	fprintf(stderr, "Type = MASSPOINT\n");
	break;
    case NAGEL:
	fprintf(stderr, "Type = NAIL\n");
	break;
    case ZUSGESOBJ:
	fprintf(stderr, "Type = COMPOSED OBJECT\n");
	break;
    default:
	fprintf(stderr, "UNKNOWN BODYTYPE!\n");
	break;
    }

    printvektor("Position = ", k->Position);
    if (k->Art != NAGEL) {
	printvektor("velocity = ", k->Geschwindigkeit);
	printvektor("accelaration = ", k->Beschleunigung);
    }
    if (k->Art != NAGEL) {
	printeulerpar("Eulerparameter(q) = ", k->q);
	printvektor("Angle velocity = ", k->Drehgeschwindigkeit);
	printvektor("Angle accelaration = ", k->Drehbeschleunigung);
	printmatrix("RotTrans = ", k->RotTrans);
	printmatrix("Inverse RotTrans = ", k->RotTrans1);
	if (k->Art != PUNKT) {
	printmatrix("Mass tensor = ", k->Traegheitstensor);
	printmatrix("Inverse mass tensor = ", k->Traegheitstensor1);
	fprintf(stderr, "Mass = %lf\n", k->Masse);
	}
    }

    fprintf(stderr, "Movement type =%s%s%s%s(%d)\n",
	   (k->BewTyp & FREI) ? " free": "",
	   (k->BewTyp & MASSELOS) ? " no mass": "",
	   (k->BewTyp & GRAV0) ? " no gravity": "",
	   (k->BewTyp & GEFUEHRT) ? " directed": "",
	   k->BewTyp
	   );

    if (k->Art == KUGEL || k->Art == QUADER || k->Art == ZYLINDER)
      fprintf(stderr, "Cover sphere radius = %f\n", k->Kugelhuellenradius);

    fprintf(stderr, "}\n\n");
	
}


void printkoeliste(TKoerper *k)
{
    if (k) while(k) {
	printkoerper(k);
	k=k->Naechster;
    }
    else fprintf(stderr, "no body in object-list\n\n");
}


void printverbindung(TVerbindung *v)
{
    if (v==NULL) {
	fprintf(stderr, "no link to print!\n\n");
	return;
    }
    fprintf(stderr, "Link = {\n");

    switch(v->Art) {
    case GELENK:
	fprintf(stderr, "Type = joint\n");
	break;
    case FEDER:
	fprintf(stderr, "Type = spring, resting length = %e, spring constant = %e\n",
		v->VerParameter.Feder.Ruhelaenge, v->VerParameter.Feder.Federkonstante);
	break;
    case DAEMPFER:
	fprintf(stderr, "Type = damper, damper constant = %e\n",
		v->VerParameter.Daempfer.Daempfungskonstante);
	break;
    case STANGE:
	fprintf(stderr, "Type = rod, length = %e\n", v->VerParameter.Stange.Stangenlaenge);
	break;
    default :
	fprintf(stderr, "Type = unknown!\n");
	break;
    }
    printvektor("link point to body1 = ", v->VPunkt1);
    printvektor("link point to body1 = ", v->VPunkt2);

    fprintf(stderr, "}\n\n");
}


void printverbliste(TVerbindung *v)
{
    if (v) while(v) {
	printverbindung(v);
	v=v->Naechste;
    }
    else fprintf(stderr, "No links in list\n\n");
}


void printzustand(TZustand *z)
{
    if (z) {
	fprintf(stderr, "State = {\nTime = %e\n", z->Zeit);
	printkoeliste(z->Koerper);
	printverbliste(z->Verbindungen);
	fprintf(stderr, "}\n\n");
    }
    else fprintf(stderr, "No state to print!\n\n");
}

