#ifndef lint
static       char    rcsid[] = "$Header: face.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	face.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * a 3DFACE must have 4 points, but the third and the forth points
 * are the same for a trinagle
 *
 * a 3DFACE cannot be extruded, and does not have thickness
 */

/*
 * invisible edge flags, they are bit-coded
 */

#define	FACEEDGE_FIRST	1		/* first edge is invisible */
#define	FACEEDGE_SECOND	2		/* second edge is invisible */
#define	FACEEDGE_THIRD	4		/* third edge is invisible */
#define	FACEEDGE_FORTH	8		/* forth edge is invisible */

typedef	struct	face	{
	INT	npoints;		/* number of points, must be 3 or 4 */
	FLOAT	points[4][3];		/* vertex of the 3d face */
	INT	edgeflag;		/* invisible edge flags, default 0 */
					/* not used */
} FACE;

/*
 * parse a 3DFACE
 */

ENTITY	*FaceDxfParse(layerlist)
LAYER	**layerlist;
{
	ENTITY	*entity;
	FACE	*face;
	INT	pointsset = 0;
	INT	flagset = 0;
	INT	defaultflag = 0;

	entity = Malloc(ENTITY, 1);
	face = Malloc(FACE, 1);
	entity->type = ENTITY_3DFACE;
	entity->data = (VOID *) face;

	entity->layer = LayerDxfParse(layerlist);

	do {
		GetNextGroup();
		switch(Group->code) {
		case 10:
			/*
			 * four points
			 * 10, 20, 30, 11, 21, 31, 12, 22, 32, 13, 23, 33
			 */

			if (pointsset != 0)
				DXFERR("duplicated points for a 3DFACE %s", "\n");
			pointsset = 1;
			CoordDxfParse(0, face->points[0]);
			GetNextGroup();
			CoordDxfParse(1, face->points[1]);
			GetNextGroup();
			CoordDxfParse(2, face->points[2]);
			GetNextGroup();
			CoordDxfParse(3, face->points[3]);

			/*
			 * check if the 3rd and 4th points are the same
			 */

			if (CoordSame(face->points[2], face->points[3]) == 0)
				face->npoints = 4;
			else
				face->npoints = 3;
			break;

		case 70:
			/*
			 * invisible edge flag
			 * 70
			 */

			if (flagset != 0)
				DXFERR("duplicated invisible edge flag of a 3DFACE %s", "\n");

			flagset = 1;
			face->edgeflag = Group->intnum;
			break;

		default:
			if (OptionsDxfParse(&entity->options) == 0)
				defaultflag = 1;
			break;
		}
	} while (defaultflag == 0);

	/*
	 * check if points are all defined
	 */

	if (pointsset == 0)
		DXFERR("undefined points of a 3DFACE %s", "\n");

	return(entity);
}

/*
 * check if the 3Dface is degenerated
 * if true, return 1, else 0
 */

INT	FaceDegeneratedCheck(n, p)
INT	n;
FLOAT	p[][3];
{
	if (n < 3)
		return(1);

	if (n == 3) {
		if (CoordSame(p[0], p[1]) != 0)
			return(1);

		if (CoordSame(p[1], p[2]) != 0)
			return(1);

		if (CoordSame(p[2], p[0]) != 0)
			return(1);
		return(0);
	}

	if (CoordSame(p[0], p[1]) != 0)
		return(1);

	if (CoordSame(p[0], p[2]) != 0)
		return(1);

	if (CoordSame(p[0], p[3]) != 0)
		return(1);

	if (CoordSame(p[1], p[2]) != 0)
		return(1);

	if (CoordSame(p[1], p[3]) != 0)
		return(1);

	/*
	 * this case does not happen, as it's checked in the parsing stage
	 *
	 * if (CoordSame(p[2], p[3]) != 0)
	 *	return(1);
	 */

	return(0);
}

/*
 * output a 3DFACE into DEF/NFF/DEF file
 */

VOID	FaceDefOutput(entity)
ENTITY	*entity;
{
	FACE	*face;
	FLOAT	polygon[4][3];

	face = (FACE *) entity->data;

	if (FaceDegeneratedCheck(face->npoints, face->points) != 0)
		return;

	NameOutput(entity->layer);

	VecCopy(face->points[0], polygon[0]);
	VecCopy(face->points[1], polygon[1]);
	VecCopy(face->points[2], polygon[2]);
	if (face->npoints == 4)
		VecCopy(face->points[3], polygon[3]);

	OutputPolygon(face->npoints, polygon, entity);
}
