# $Header: Makefile.hc,v 1.1 90/06/17 03:34:51 zhang Exp $";
#
# Makefile for CONVERTER from AutoCAD 10.0 DXF format into DEF/NFF format
# under MS-DOS 3.x with MetaWare High C 1.6 and Microsoft Make 4.x
#
# $Log:	Makefile.hc,v $
# 
# Revision 1.1  90/06/17  03:34:51  zhang
# Initial revision
# 

PROG	=	dxfcvt

# define c compiler

CC	=	hc386 -g -DMSDOS -Hl=c -Hon=387 -Hon=Check_stack

# define c compiler options

CFLAGS	=	-c

# define lib command

LIB	=	lib

# define 386bind command

bind	=	bind

# define link command

LINK	=	386link

# define link options

LDFLAGS	=	-PACK -SYMBOLS -TWOCASE -STACK 1024000

# define link command file

LINKCMD	=	link_hc.LNK

#

HDRS	=	defs.h \
		config.h \
		extern.h \
		function.h

GENSRCS	=	alloc.c \
		block.c \
		check.c \
		coord.c \
		data.c \
		error.c \
		entity.c \
		group.c \
		layer.c \
		main.c \
		matrix.c \
		name.c \
		options.c \
		output.c \
		parse.c \
		stack.c \
		vector.c

ENTSRCS	=	line.c \
		point.c \
		circle.c \
		arc.c \
		trace.c \
		solid.c \
		text.c \
		shape.c \
		insert.c \
		attrib.c \
		polyline.c \
		vertex.c \
		face.c \
		dimensio.c


CSRCS	=	$(GENSRCS) $(ENTOBJS)

GENOBJS	=	alloc.obj \
	 	block.obj \
		check.obj \
		coord.obj \
	 	data.obj \
		error.obj \
		entity.obj \
		group.obj \
		layer.obj \
		main.obj \
		matrix.obj \
		name.obj \
		options.obj \
		output.obj \
		parse.obj \
		stack.obj \
		vector.obj

ENTOBJS	=	line.obj \
		point.obj \
		circle.obj \
		arc.obj \
		trace.obj \
		solid.obj \
		text.obj \
		shape.obj \
		insert.obj \
		attrib.obj \
		polyline.obj \
		vertex.obj \
		face.obj \
		dimensio.obj

COBJS	=	$(GENOBJS) $(ENTOBJS)

.c.obj:	
	$(CC) $(CFLAGS) $*.c

alloc.obj:	$(HDRS) alloc.c

block.obj:	$(HDRS) block.c

check.obj:	$(HDRS) check.c

coord.obj:	$(HDRS) coord.c

data.obj:	$(HDRS) data.c

error.obj:	$(HDRS) error.c

entity.obj:	$(HDRS) entity.c

group.obj:	$(HDRS) group.c

layer.obj:	$(HDRS) layer.c

main.obj:	$(HDRS) main.c

matrix.obj:	$(HDRS) matrix.c

name.obj:	$(HDRS) name.c

options.obj:	$(HDRS) options.c

output.obj:	$(HDRS) output.c

parse.obj:	$(HDRS) parse.c

stack.obj:	$(HDRS) stack.c

vector.obj:	$(HDRS) vector.c

line.obj:	$(HDRS) line.c

point.obj:	$(HDRS) point.c

circle.obj:	$(HDRS) circle.c

arc.obj:	$(HDRS) arc.c

trace.obj:	$(HDRS) trace.c

solid.obj:	$(HDRS) solid.c

text.obj:	$(HDRS) text.c

shape.obj:	$(HDRS) shape.c

insert.obj:	$(HDRS) insert.c

attrib.obj:	$(HDRS) attrib.c

polyline.obj:	$(HDRS) polyline.c

vertex.obj:	$(HDRS) vertex.c

face.obj:	$(HDRS) face.c

dimensio.obj:	$(HDRS) dimensio.c


$(PROG).EXP:	$(GENOBJS) $(ENTOBJS) $(LINKCMD)
		$(LINK) -exe $(PROG).EXP @$(LINKCMD) $(LDFLAGS)

$(PROG).EXE:	$(PROG).EXP
		$(BIND) $(PROG).EXE $(PROG).EXP
