/* hpcdtoppm (Hadmut's pcdtoppm) v0.6
*  Copyright (c) 1992, 1993, 1994 by Hadmut Danisch (danisch@ira.uka.de).
*  Permission to use and distribute this software and its
*  documentation for noncommercial use and without fee is hereby granted,
*  provided that the above copyright notice appear in all copies and that
*  both that copyright notice and this permission notice appear in
*  supporting documentation. It is not allowed to sell this software in 
*  any way. This software is not public domain.
*/

#include "hpcdtoppm.h"




#ifdef OWN_WRITE


static uBYTE BUF[own_BUsize];
#define BUinit {BUcount=0;BUptr=BUF;}

#define BUrgb_flush        {fwrite(BUF,BUcount*3,1,fout);BUinit; }
#define BUrgb_write(r,g,b) {if(BUcount>=own_BUsize/3) BUrgb_flush; *BUptr++ = r ; *BUptr++ = g ; *BUptr++ = b ; BUcount++;}

#define BUgreyflush        {fwrite(BUF,BUcount,1,fout);BUinit; }
#define BUgreywrite(g)     {if(BUcount>=own_BUsize) BUgreyflush;  *BUptr++ = g ;  BUcount++;}







void write_ppm(FILE *fout,dim w,dim h, 
               uBYTE *rptr,sdim rzeil,sdim rpix,  
               uBYTE *gptr,sdim gzeil,sdim gpix,  
               uBYTE *bptr,sdim bzeil,sdim bpix) 
 {register uBYTE *pr,*pg,*pb;
  dim x,y;
  static uBYTE *BUptr;
  sINT   BUcount;

  fprintf(fout,PPM_Header,w,h);
  BUinit;
  for(y=0;y<h;y++)
   {
     pr= rptr; rptr+=rzeil;
     pg= gptr; gptr+=gzeil;
     pb= bptr; bptr+=bzeil;
     for(x=0;x<w;x++) 
      {BUrgb_write(*pr,*pg,*pb);
       pr+=rpix;  pg+=gpix;  pb+=bpix;
      }
   }
  BUrgb_flush;

 }






void write_pgm(FILE *fout,dim w,dim h, uBYTE *ptr,sdim zeil,sdim pix) 
 {register uBYTE *p;
  dim x,y;
  static uBYTE *BUptr;
  sINT   BUcount;


  fprintf(fout,PGM_Header,w,h);
  BUinit;
  for(y=0;y<h;y++)
   {
    p= ptr; ptr+=zeil;

    for(x=0;x<w;x++) 
     {BUgreywrite(*p);
      p+=pix;
     }
   }
  BUgreyflush;
 }


#else
#include "gr/ppm.h"

void write_ppm(FILE *fout,dim w,dim h, 
               uBYTE *rptr,sdim rzeil,sdim rpix,  
               uBYTE *gptr,sdim gzeil,sdim gpix,  
               uBYTE *bptr,sdim bzeil,sdim bpix) 
 {register uBYTE *pr,*pg,*pb;
  dim x,y;
  pixel *pixrow;
  register pixel* pP;


  ppm_writeppminit(fout,w,h,(pixval) 255, 0);
  pixrow = ppm_allocrow( w );
  for(y=0;y<h;y++)
   {
    pr= rptr; rptr+=rzeil;
    pg= gptr; gptr+=gzeil;
    pb= bptr; bptr+=bzeil;

    for(pP= pixrow,x=0;x<w;x++)
     {
      PPM_ASSIGN(*pP,((sINT)*pr),((sINT)*pg),((sINT)*pb));
      pP++;  pr+=rpix;  pg+=gpix;  pb+=bpix;
     }
    ppm_writeppmrow( fout, pixrow, w, (pixval) 255, 0 );
	    
   }
  pm_close(fout);

 }

void write_pgm(FILE *fout,dim w,dim h, uBYTE *ptr,sdim zeil,sdim pix) 
 {register uBYTE *p;
  dim x,y;
  gray *grayrow;
  register gray* pP;


  pgm_writepgminit(fout,w,h,(pixval) 255, 0);
  grayrow = pgm_allocrow( w );
  for(y=0;y<h;y++)
   {
    p= ptr; ptr+=zeil;

    for(pP= grayrow,x=0;x<w;x++)
     {
      *pP= ((gray)*p);
      pP++;  p+=pix;
     }
    pgm_writepgmrow( fout, grayrow, w, (pixval) 255, 0 );
	    
   }
  pm_close(fout);

 }




#endif



