/*{{{}}}*/
/*{{{  #includes*/
#include <curses.h>

#include "wgetc.h"
/*}}}  */

/*{{{  wgetc*/
chtype wgetc(WINDOW *w)
{
  /*{{{  variables*/
  chtype c;
  /*}}}  */

  wrefresh(w);
  switch (c=wgetch(w))
  {
    /*{{{  LEFT*/
    case '\02':
    case KEY_LEFT: return KEY_LEFT;
    /*}}}  */
    /*{{{  RIGHT*/
    case '\06':
    case KEY_RIGHT: return KEY_RIGHT;
    /*}}}  */
    /*{{{  UP*/
    case '\020':
    case KEY_UP: return KEY_UP;
    /*}}}  */
    /*{{{  DOWN*/
    case '\016':
    case KEY_DOWN: return KEY_DOWN;
    /*}}}  */
    /*{{{  BACKSPACE*/
    case '\010':
    case KEY_BACKSPACE: return KEY_BACKSPACE;
    /*}}}  */
    /*{{{  DC*/
    case '\04':
    case '\177':
    case KEY_DC: return KEY_DC;
    /*}}}  */
    /*{{{  CANCEL*/
    case '\07':
    case '\033':
    case KEY_CANCEL: return KEY_CANCEL;
    /*}}}  */
    /*{{{  ENTER*/
    case '\r':
    case '\n':
    case KEY_ENTER: return KEY_ENTER;
    /*}}}  */
    /*{{{  BEG*/
    case '\01':
    case KEY_BEG: return KEY_BEG;
    /*}}}  */
    /*{{{  END*/
    case '\05':
    case KEY_END: return KEY_END;
    /*}}}  */
    /*{{{  IC*/
    case '\t':
    case KEY_IC: return KEY_IC;
    /*}}}  */
    /*{{{  DL*/
    case '\013':
    case KEY_DL: return KEY_DL;
    /*}}}  */
    /*{{{  default*/
    default: return c;
    /*}}}  */
  }
}
/*}}}  */
