#!/usr/local/bin/perl
#  log.pl - logging functions
#
#  Written by Christopher Browne.  Started November 1, 1994.
#  Modified by Curtis Olson.
#
#  Copyright (C) 1994  Christopher B. Browne cbrowne@io.org
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: log.pl,v 1.2 1995/01/23 03:17:06 curt Exp $
# (Log is kept at end of this file)


# Create a log entry
sub log_txn {
    local($file, $key, $value, $desc) = @_;
    local($home) = &file_dirname($file);

    print DEBUG "File is $file\n" if debug;
    print DEBUG "logging to $home/alltxns.log\n" if $debug;

    open(LOG, ">>$home/alltxns.log");
    print LOG &log_entry($name, $key, $value, $desc);
    close(LOG);
}


# Format of log item is:
# [modtime]===[account]===[key]===[value]===[comment]
sub log_entry {
  local ($file, $key, $value, $comment) = @_;
  local ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) 
	= localtime(time);
  local ($now) = sprintf("%04d/%02d/%02d %02d:%02d:%02d", $year, $mon+1, 
  			 $mday, $hour, $min, $sec);
  sprintf ("%s===%s===%s===%s===%s\n", $now, $file, $key, $value, 
  	   $comment);
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: log.pl,v $
# Revision 1.2  1995/01/23  03:17:06  curt
# Fixed an off by one [order of magnitude -- not really :) ] bug in log
# printing.
#
# Revision 1.1  1994/11/01  22:39:16  clolson
# Added log.pl --> implemented logging.
# Worked on install script.
#
