#!/usr/local/bin/perl
#  install.pl - the cbb install utility
#              This script installs cbb
#
#  Written by Curtis Olson.  Started October 11, 1994.
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: install.pl,v 1.12 1995/02/23 05:13:14 curt Exp $
# (Log is kept at end of this file)


require "common.pl";


# perl includes
@perl_incs = ("categories.pl", "common.pl", "engine.pl", "export.pl", 
	      "import.pl", "log.pl", "memorized.pl", "reports.pl");

# tcl includes
@tcl_incs = ("categories.tk", "help.tk", "reports.tk");

# get home directory
@pw = getpwuid($<);

$HOME = $pw[7]
     || $ENV{HOME}
     || $ENV{LOGDIR}
     || die "No home directory";

$home_dir = &file_dirname($HOME);
$home_base = &file_basename($HOME);
 
# default paths
$def_perlpath = "";
@perl_poss = ("/usr/bin/perl", "/usr/local/bin/perl");
$def_wishpath = "";
@wish_poss = ("/usr/bin/wish", "/usr/bin/X11/wish", "/usr/local/bin/wish");
$def_binpath = "/usr/local/bin";
$def_libpath = "/usr/local/lib/cbb";
$def_cbb = "cbb";
$def_engine = "wrapper.pl";
$def_cat = "default.cat";
$def_version = "Version";
$def_icon = "cbb.xbm";
$def_xbm = "author.xbm";
$def_src = "csh.src";


print "\nInstalling and Configuring CBB:\n";
print "Press ^C at any time to abort.\n\n";
print "WARNING: This script hasn't been extensively tested.  Please let me\n";
print "         know if you find a problem with it.  <curt\@sledge.mn.org>\n\n";


# Ok, first lets find out the current version

open( VERSION, "$def_version" );
$version = <VERSION>;
chop($version);

print "Current version is \"$version\"\n\n";

print "    NOTE:  You may use ~ and ~user to specify a home directory as\n";
print "           part of an installation directory.\n\n";

# Now, make sure we have the prerequisites.

foreach $tmp (@perl_poss) {
    if ( (-e $tmp) && ($def_perlpath eq "") ) {
	$def_perlpath = $tmp;
    }
}

$perlpath = "";
while ( $perlpath eq "" ) {
    print "Where is perl located? [$def_perlpath] ";
    $perlpath = <STDIN>;
    chop($perlpath);

    if ( $perlpath eq "" ) {
	$perlpath = $def_perlpath;
    }

    # psuedo-glob
    if ( $perlpath =~ m/~\// ) {
        # ~/blah form
        $perlpath =~ s/~/$HOME/;
    } else {
        # ~user/blah from
        $perlpath =~ s/~/$home_dir/;
    }

    if ( ! -e $perlpath ) {
	$perlpath = "";
    }
}
print "    Using $perlpath\n";

foreach $tmp (@wish_poss) {
    if ( (-e $tmp) && ($def_wishpath eq "") ) {
	$def_wishpath = $tmp;
	break;
    }
}

$wishpath = "";
while ( $wishpath eq "" ) {
    print "Where is wish located? [$def_wishpath] ";
    $wishpath = <STDIN>;
    chop($wishpath);

    if ( $wishpath eq "" ) {
	$wishpath = $def_wishpath;
    }

    # psuedo-glob
    if ( $wishpath =~ m/~\// ) {
        # ~/blah form
        $wishpath =~ s/~/$HOME/;
    } else {
        # ~user/blah from
        $wishpath =~ s/~/$home_dir/;
    }

    if ( ! -e $wishpath ) {
	$wishpath = "";
    }
}
print "    Using $wishpath\n";


# Now, where do we want to install things ...

$binpath = "";
while ( $binpath eq "" ) {
    print "Where should the binaries be installed? [$def_binpath] ";
    $binpath = <STDIN>;
    chop($binpath);

    if ( $binpath eq "" ) {
	$binpath = $def_binpath;
    }

    # psuedo-glob
    if ( $binpath =~ m/~\// ) {
	# ~/blah form
	$binpath =~ s/~/$HOME/;
    } else {
	# ~user/blah from
	$binpath =~ s/~/$home_dir/;
    }

    if ( ! -e $binpath || ! -d $binpath ) {
	print "    $binpath does not exist.  Should I create it? [y] ";
	$result = <STDIN>;
	chop($result);
	if ( ($result =~ /^[Yy]/) || ($result eq "") ) {
	    $status = system( "mkdir $binpath" );
	    if ( $status ) {
		$code = $status / 256;
		print"\'mkdir $binpath\' failed with an exit code of ";
		print"$code.\n";
		exit( $code );
	    }
	} else {
	    print "    Very well ... but you better do it yourself. ;)\n";
	}
    }

    if ( $binpath =~ m/wish$/ ) {
	print "    Warning:  cbb cannot run with wish, it requires bin.\n";
	print "    See the README file for more information.\n";
	$binpath = "";
    }
}
print "    Using $binpath\n";

# derive a default $libpath from $binpath
$tmp = $binpath;
if ( substr($tmp, length($tmp) - 1) eq "/" ) {
    chop($tmp);
}
$def_libpath = &file_dirname($tmp) . "lib/cbb";

$libpath = "";
while ( $libpath eq "" ) {
    print "Where should the support files be installed? [$def_libpath] ";
    $libpath = <STDIN>;
    chop($libpath);

    if ( $libpath eq "" ) {
	$libpath = $def_libpath;
    }

    # psuedo-glob
    if ( $libpath =~ m/~\// ) {
        # ~/blah form
        $libpath =~ s/~/$HOME/;
    } else {
        # ~user/blah from
        $libpath =~ s/~/$home_base/;
    }

    if ( ! -e $libpath || ! -d $libpath ) {
	print "    $libpath does not exist.  Should I create it? [y] ";
	$result = <STDIN>;
	chop($result);
	if ( ($result =~ /^[Yy]/) || ($result eq "") ) {
	    $status = system( "mkdir $libpath" );
	    if ( $status ) {
		$code = $status / 256;
		print"\'mkdir $libpath\' failed with an exit code of ";
		print"$code.\n";
		exit( $code );
	    }
	} else {
	    print "    Very well ... but you better do it yourself. ;)\n";
	}
    }

    if ( $libpath =~ m/wish$/ ) {
	print "    Warning:  cbb cannot run with wish, it requires lib.\n";
	print "    See the README file for more information.\n";
	$libpath = "";
    }
}
print "    Using $libpath\n";


# install cbb

print ( "\nNow installing CBB:\n\n" );
print ( "Creating $binpath/$def_cbb from ./$def_cbb\n" );

open( CBBIN, "<./$def_cbb" ) || die "Cannot open ./$def_cbb";
open( CBBOUT, ">$binpath/$def_cbb" ) || die "Cannot create $binpath/$def_cbb";

$junk = <CBBIN>;	# ignore first line
print( CBBOUT "#!$wishpath -f\n" );

while ( <CBBIN> ) {
    s/^ *set lib_path.*$/set lib_path \"$libpath\"/;
    s/\"Version.*\"/\"$version\"/;
    print( CBBOUT $_ );
}

close( CBBIN );
close( CBBOUT );

chmod(0755, "$binpath/$def_cbb") || die "Cannot chmod $binpath/$def_cbb";


# install engine

print ( "Creating $binpath/$def_engine from ./$def_engine\n" );

open( ENGINEIN, "<./$def_engine" ) || die "Cannot open ./$def_engine";
open( ENGINEOUT, ">$binpath/$def_engine" ) 
	|| die "Cannot create $binpath/$def_engine";

$junk = <ENGINEIN>;	# ignore first line
print( ENGINEOUT "#!$perlpath\n" );

while ( <ENGINEIN> ) {
    s/^ *\$cbb_incl_dir = .*$/\$cbb_incl_dir = \"$libpath\";/;
    print( ENGINEOUT $_ );
}

close( ENGINEIN );
close( ENGINEOUT );

chmod(0755, "$binpath/$def_engine") || die "Cannot chmod $binpath/$def_engine";


# install perl includes

foreach $file (@perl_incs) {
    print ( "Creating $libpath/$file from ./$file\n" );

    open( INCIN, "<./$file" ) || die "Cannot open ./$file";
    open( INCOUT, ">$libpath/$file" ) 
	|| die "Cannot create $libpath/$file";
    
    $junk = <INCIN>;	# ignore first line
    print( INCOUT "#!$perlpath\n" );

    while ( <INCIN> ) {
	s/^ *\$cbb_incl_dir = .*$/\$cbb_incl_dir = \"$libpath\";/;
	print( INCOUT $_ );
    }

    close( INCIN );
    close( INCOUT );

    chmod(0644, "$libpath/$file") || die "Cannot chmod $libpath/$file";
}


# install tcl includes

foreach $file (@tcl_incs) {
    print ( "Creating $libpath/$file from ./$file\n" );

    open( INCIN, "<./$file" ) || die "Cannot open ./$file";
    open( INCOUT, ">$libpath/$file" )
        || die "Cannot create $libpath/$file";
   
    while ( <INCIN> ) {
        print( INCOUT $_ );
    }

    close( INCIN );
    close( INCOUT );

    chmod(0644, "$libpath/$file") || die "Cannot chmod $libpath/$file";
}


# install default.cat

print ( "Creating $libpath/$def_cat from ./$def_cat\n" );

open( CATIN, "<./$def_cat" ) || die "Cannot open ./$def_cat";
open( CATOUT, ">$libpath/$def_cat" ) 
	|| die "Cannot create $libpath/$def_cat";

while ( <CATIN> ) {
    print( CATOUT $_ );
}

close( CATIN );
close( CATOUT );

chmod(0644, "$libpath/$def_cat") || die "Cannot chmod $libpath/$def_cat";


# install icon.xbm

print ( "Creating $libpath/$def_icon from ./$def_icon\n" );

open( ICONIN, "<./$def_icon" ) || die "Cannot open ./$def_icon";
open( ICONOUT, ">$libpath/$def_icon" ) || 
    die "Cannot create $libpath/$def_icon";

while ( <ICONIN> ) {
    print( ICONOUT $_ );
}

close( ICONIN );
close( ICONOUT );

chmod(0644, "$libpath/$def_icon") || die "Cannot chmod $libpath/$def_icon";


# install author.xbm

print ( "Creating $libpath/$def_xbm from ./$def_xbm\n" );

open( XBMIN, "<./$def_xbm" ) || die "Cannot open ./$def_xbm";
open( XBMOUT, ">$libpath/$def_xbm" ) || die "Cannot create $libpath/$def_xbm";

while ( <XBMIN> ) {
    print( XBMOUT $_ );
}

close( XBMIN );
close( XBMOUT );

chmod(0644, "$libpath/$def_xbm") || die "Cannot chmod $libpath/$def_xmb";


# install csh.src

print ( "Creating $libpath/$def_src from ./$def_src\n" );

open( CSHIN, "<./$def_src" ) || die "Cannot open ./$def_src";
open( CSHOUT, ">$libpath/$def_src" ) || die "Cannot create $libpath/$def_src";

while ( <CSHIN> ) {
    print( CSHOUT $_ );
}

close( CSHIN );
close( CSHOUT );

chmod(0644, "$libpath/$def_src") || die "Cannot chmod $libpath/$def_src";


# ----------------------------------------------------------------------------
# $Log: install.pl,v $
# Revision 1.12  1995/02/23  05:13:14  curt
# Removed dependencies on tclX (wishx).
#
# Revision 1.11  1995/01/23  04:15:17  curt
# Added psuedo-globbing.
#
# Revision 1.10  1994/12/01  12:47:52  clolson
# Added an icon bitmap
#
# Revision 1.9  1994/11/29  19:03:34  curt
# Smartened the bad boy up.
#
# Revision 1.8  1994/11/28  18:55:32  clolson
# Added reports.pl & reports.tk
#
# Revision 1.7  1994/11/07  23:14:04  clolson
# Working on interactive category viewing/editing
#
# Revision 1.6  1994/11/07  19:16:12  clolson
# Added latex2tkhlp to install.
#
# Revision 1.5  1994/11/01  22:39:13  clolson
# Added log.pl --> implemented logging.
# Worked on install script.
#
# Revision 1.4  1994/10/31  16:04:56  curt
# Beginning some massive changes to start tracking towards cbbsh.
#
# Revision 1.3  1994/10/14  19:06:42  clolson
# Fixed a problem:  didn't add -f to the end of wish in the installed cbb.
#
# Revision 1.2  1994/10/14  03:04:49  curt
# First working version.
#
# Revision 1.1  1994/10/11  21:21:17  clolson
# Initial add to repository
#
