########################################################################
#  Elvis color additions for C/C++ color editing.
#
#  By Brian Kral
#  gt5462a@prism.gatech.edu
#
#
#  Foreground/Background color choices
#	black
#	blue
#	green
#	cyan
#	red
#	magenta
#	brown
#	white
#
#  Foreground color choices
#	bold_black	(a.k.a. gray)
#	bold_blue	(a.k.a. light blue)
#	bold_green	(a.k.a. light green)
#	bold_cyan	(a.k.a. light cyan)
#	bold_red	(a.k.a. light red)
#	bold_magenta	(a.k.a. light magenta)
#	bold_brown	(a.k.a. yellow)
#	bold_white	(a.k.a. high-intensity white)
#
#	The two modifiers are:
#		bold_	- (a.k.a. high intensity, light, or bright)
#		blink_	- 
#
#-----------------------------------------------------------------------
#  Autodetection:
#	This is a list of the suffixes you want elvis to turn color
#	"ON" during editing.  Otherwise it is turned "OFF".
#
#  Currently, only 20 suffixes are allowed.  After that, the rest are
#  ignored.  But do you really need >20?
#
AUTODETECT	.c
AUTODETECT	.C
AUTODETECT	.cc
AUTODETECT	.cxx
AUTODETECT	.h
#AUTODETECT	.H
#AUTODETECT	.hh
#AUTODETECT	.hxx

AUTODETECT	.f	fortran

#-----------------------------------------------------------------------
#  Selection Color:
#       This is the color (usually reverse gray) used to highlight
#       wanted text.  In elvis the key is 'v' and by default uses the
#       termcap entry 'so'.  This option allows you to override the
#       default termcap entry and select your own.
#
#  BTW, This doesn't work yet!
SELECTION	THIS_IS_BROKEN


#-----------------------------------------------------------------------
#  C preprocessors:  
#         example:  #include <stdio.h>
#
PREPROCESSOR	bold_green


#-----------------------------------------------------------------------
#  Punctuation:
#      example:  . -> , [] () - + = * / %= *= += ++   ...etc
#
PUNCTUATION	bold_white


#-----------------------------------------------------------------------
#  Strings in quotes:
#            example:  "This is a string in quotes."
#
STRING		bold_cyan


#-----------------------------------------------------------------------
#  Char strings in single quotes:
#                        example:  '\n', '\056', 'g', ...etc
#
CHAR		bold_cyan


#-----------------------------------------------------------------------
#  Key words:
#    example:  void, struct, class, char, int, float, ...etc
#
KEYWORD		bold_white


#-----------------------------------------------------------------------
#  Comments:
#   example:  /* */  and //
#
COMMENT		white


#-----------------------------------------------------------------------
#  Decimal numbers:
#          example:  4, 4L, 4U, 4e4, 4e-4, 4E+4L, 4e+4f
#
DECIMAL		bold_cyan


#-----------------------------------------------------------------------
#  Hex numbers:
#      example:  0x04, 0x4L, 0x4U
#
HEX		bold_cyan


#-----------------------------------------------------------------------
#  Octal numbers:
#        example:  04, 04L, 04U
#
OCTAL		red


#-----------------------------------------------------------------------
#  Normal Text:
#      example:  What ever you want
#
NORMAL		bold_brown


#-----------------------------------------------------------------------
#  Illegal Parse Errors:
#               example:  0x0g
#
ERROR		black		red

# end .exrc.color
