;;; hm--programming-menu.el: 
;;; v1.20; 30.06.93
;;; Copyright (C) 1993  Heiko Muenkel
;;; email: muenkel@tnt.uni-hannover.de
;;;
;;;  This program is free software; you can redistribute it and/or modify
;;;  it under the terms of the GNU General Public License as published by
;;;  the Free Software Foundation; either version 1, or (at your option)
;;;  any later version.
;;;
;;;  This program is distributed in the hope that it will be useful,
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;  GNU General Public License for more details.
;;;
;;;  You should have received a copy of the GNU General Public License
;;;  along with this program; if not, write to the Free Software
;;;  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;
;;; 
;;; Description:
;;;
;;;	Functions, which are used in different programming menus like
;;; 	hm--elisp-menu.el, hm--c-menu.el and hm--c++-menu.el.
;;;	You need also the following lisp files:
;;;		hm--date.el
;;;		blink-paren.el
;;;		compile.el
;;;
;;;	The files blink-paren.el and compile.el should be in the normal l
;;;	emacs distribution !
;;; 
;;; Installation: 
;;;   
;;;	You must only put this file in one of your lisp
;;;	load path directories (i.e. in .../lisp/packages).
;;;	The file will be loaded, if one of the above listed menu files
;;;	are loaded.
;;;


(provide 'hm--programming-menu)


(defun hm--init-blinking-parenthesis ()
  "Inits the blinking parenthesis feature from devin@lucid.com."
  (interactive)
  (load-library "blink-paren.el")
  (add-menu-item '("Programming" "Mode Properties")
		 "Time of blinking parent"
		 'hm--change-time-of-blinking-parenthesis
		 t
		 "Init blinking parenthesis")
  (delete-menu-item '("Programming" 
		      "Mode Properties" 
		      "Init blinking parenthesis"))
  (add-menu-item '("Programming" "Mode Properties")
		 "Open parenthesis match"
		 'hm--set-matching-open-parenthesis
		 t
		 "No open parenthesis match")
  (delete-menu-item '("Programming" 
		      "Mode Properties" 
		      "No open parenthesis match"))
  )


(defun hm--change-time-of-blinking-parenthesis (value)
  "Function changes the value of the variable blink-paren-timeout."
  (interactive 
   "nNew value for the timeout of the blinking parenthesis (* 10): ")
  (setq blink-paren-timeout (/ (+ 0.0 value) 10.0)))


(defun hm--unset-matching-open-parenthesis ()
  "Unsets the feature 'matching open parenthesis, when close parenthesis"
  (interactive)
  (setq blink-matching-paren nil)
  (add-menu-item '("Programming" "Mode Properties")
		 "Open parenthesis match"
		 'hm--set-matching-open-parenthesis
		 t
		 "No open parenthesis match")
  (delete-menu-item '("Programming" 
		      "Mode Properties" 
		      "No open parenthesis match"))
  )


(defun hm--set-matching-open-parenthesis ()
  "Sets the feature 'matching open parenthesis, when close parenthesis"
  (interactive)
  (setq blink-matching-paren t)
  (add-menu-item '("Programming" "Mode Properties")
		 "No open parenthesis match"
		 'hm--unset-matching-open-parenthesis
		 t
		 "Open parenthesis match")
  (delete-menu-item '("Programming" 
		      "Mode Properties" 
		      "Open parenthesis match"))
  )


;; For the 'compile command


(defvar hm--compile-menu nil "*List with the menu \"Compile\".")


(setq hm--compile-menu
      '("Compile Menu"
	["Kill compilation" kill-compilation t]
	["Goto error" compile-goto-error t]
	["Next error" next-error t]
	["Previous error" previous-error t]))


(defun hm--compile-directory nil 
  "The directory of the last 'hm--compile command.")


(defun hm--compile ()
  "Wrap around for the function compile."
  (interactive) 
  (require 'compile)
  (let ((command (read-string "Compile command: " compile-command
			      'minibuffer-compile-history)))
    (setq hm--compile-directory default-directory)
    (compile command))
  (save-excursion
    (switch-to-buffer "*compilation*")
    (hm--set-popup-menu 'hm--compile-menu)))


(defun hm--repeat-compile ()
  "Repeat the last 'hm--compile command."
  (interactive)
    (let ((old-default-directory default-directory))
      (save-excursion
	(setq default-directory hm--compile-directory)
	(compile compile-command)
	(switch-to-buffer "*compilation*")
	(hm--set-popup-menu 'hm--compile-menu))
      (setq default-directory old-default-directory)))


;; Insert C- and C++- Header

(defun hm--insert-header (emacsvariable-header-name 
			  &optional environmentvariable-header-name
			  &optional insert-add-begin-of-file)
  "Inserts a header in the current buffer.
The function uses the file which is determined by the 
'environmentvariable-header-name', or if the variable doesn't exist
the file detemined by the parameter 'emacsvariable-header-name'.
The header is insert at the current point, if 'insert-add-beginn-of-file'
is nil or at the begin of the file, if it is non nil."
  (interactive "fName of the Headerfile: \n")
  (let ((header-name))
    (if environmentvariable-header-name
	(progn
	  (setq header-name (getenv environmentvariable-header-name))
	  (if (not header-name)
	      (setq header-name emacsvariable-header-name)))
      (setq header-name emacsvariable-header-name))
    (if insert-add-begin-of-file
	(progn
	  (goto-char (point-min))
	  (insert-file-contents header-name)
	  (goto-char (point-min))
	  (hm--header-insert-filename)
	  (hm--header-insert-version)
	  (hm--header-insert-modulname))
      (beginning-of-line)
      (insert-file-contents header-name))
    ))
	    
	
;;
;; Headerfiles
;;

(defvar hm--c-file-header "~/data/header/c/c-file.header"
  "*Filename for the c-file header")


(defvar hm--h-file-header "~/data/header/c/h-file.header"
  "*Filename for the h-file header.")


(defvar hm--c-function-header "~/data/header/c/c-function.header"
  "*Filename for the c-function header.")


(defvar hm--h-macro-header "~/data/header/c/h-macro.header"
  "*Filename for the h-macro header.")


(defvar hm--c++-class-header "~/data/header/c/h-c++.header"
  "*Filename for the c++-class header.")


(require 'hm--date)


(defvar hm-regexp-version " * \\VERSION:"
  "Regular expression string for the version in a header.")


(defun hm--header-insert-version ()
  "Inserts the version date and username in the fileheader."
  (save-excursion
    (goto-char (point-min))
    (if (search-forward-regexp hm-regexp-version)
	(progn
	  (end-of-line)
	  (insert "1.0\t" (hm--date) "\t" (user-full-name))))))


(defvar hm-regexp-filename " \\* FILE:"
  "Regular expression string for the filename in a header.")

(defun hm--header-insert-filename ()
  "Inserts the filename in the fileheader."
  (save-excursion
    (goto-char (point-min))
    (if (search-forward-regexp hm-regexp-filename)
	(progn
	  (end-of-line)
	  (if buffer-file-name
	      (insert (file-relative-name buffer-file-name))
	    (insert (buffer-name)))))))


(defvar hm-regexp-modulname " \\* MODULE-NAME:"
  "Regular expression string for the modulname in a header.")


(defun hm--header-insert-modulname ()
  "Inserts the modulname in the fileheader."
  (save-excursion
    (goto-char (point-min))
    (if (search-forward-regexp hm-regexp-modulname)
	(progn
	  (end-of-line)
	  (if buffer-file-name
	      (insert (substring (file-relative-name buffer-file-name)
				 (string-match "[^.]*"
					       (file-relative-name 
						buffer-file-name))
				 (match-end 0)))
	    (insert (substring (buffer-name)
			       (string-match "[^.]*"
					     (buffer-name))
			       (match-end 0))))))))

;; Insert braces

(defun hm--c-insert-braces ()
  "Inserts 2 braces."
  (interactive)
  (insert ?{)
  (newline)
  (c-indent-line)
  (save-excursion
    (newline)
    (insert ?})
    (c-indent-line)))


;; Autoloads

