;;; hm--menu.el: 
;;; v1.10; 30 Jun 1993
;;; Copyright (C) 1993  Heiko Muenkel
;;; email: muenkel@tnt.uni-hannover.de
;;;
;;;  This program is free software; you can redistribute it and/or modify
;;;  it under the terms of the GNU General Public License as published by
;;;  the Free Software Foundation; either version 1, or (at your option)
;;;  any later version.
;;;
;;;  This program is distributed in the hope that it will be useful,
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;  GNU General Public License for more details.
;;;
;;;  You should have received a copy of the GNU General Public License
;;;  along with this program; if not, write to the Free Software
;;;  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;
;;; 
;;; Description:
;;;
;;;	Provides general popup and pulldown menus for the lemacs.
;;;	For example a menu with functions related to the windows, a
;;;     misc menu with submenus with register, search, replace, repeat
;;;     and customize functions. With the customize menu you can set
;;;     mayor and minor modes, the global popup menu and set and kill
;;;     buffer local popup menus. 
;;; 
;;;     For some menu-items you need also some other files like:
;;;     	hm--elisp-menu.el
;;;		hm--c-menu.el 
;;;		hm--c++-menu.el
;;;     	hm--programming-menu.el
;;;		hm--date.el
;;;
;;; Installation: 
;;;   
;;;	Put this file in a directory, which is in your lisp load path
;;;	(for example: lisp/packages).
;;;
;;;     Write the following line in your .emacs-file:
;;;     (load-library "hm--menu")
;;;


(provide 'hm--menu)


;;
;; Menue "Window"
;;

(delete-menu-item '("Window"))

(defvar hm--window-menu nil "*Liste mit dem Menue Window.")

(setq hm--window-menu
       '("Window Menu"
	 ["Goto line..." goto-line t]
	 ["What line" what-line t]
	 ["Compare windows" compare-windows t]
	 ("Scroll"
	  ["Line up" (scroll-up 1) t]
	  ["Line down" (scroll-down 1) t]
	  ["5 Lines up" (scroll-up 5) t]
	  ["5 Lines down" (scroll-down 5) t]
	  ["Incr scroll up" (incr-scroll-up 10000) t]
	  ["Incr scroll down" (incr-scroll-down 10000) t]
	  "----"
	  ["Page up" scroll-up t]
	  ["Page down" scroll-down t]
	  ["Filestart" beginning-of-buffer t]
	  ["Fileend" end-of-buffer t]
	  )
	 ("Size"
	  ["Balance window" balance-windows t]
	  "----"
	  ["Enlarge window 1 line" (enlarge-window 1) t]
	  ["Enlarge window 5 lines" (enlarge-window 5) t]
	  "----"
	  ["Shrink window  1 line" (shrink-window 1) t]
	  ["Shrink window  5 lines" (shrink-window 5) t]
	  )
	 ("Split & Delete"
	  ["Split window vertically" split-window-vertically t]
	  ; ["Split window horizontally" split-window-horizontally nil]
	  ["Delete window" delete-window t]
	  ["Delete other windows" delete-other-windows t]
	  "----"
	  ["Delete other screens" one-screen t]
	  )
	 ))

(add-menu nil "Window"  (cdr hm--window-menu))



;;
;; Menue "Misc  "
;;

(delete-menu-item '("Misc  "))

(defvar hm--misc-menu nil "*List with the menu Misc.")

(setq hm--misc-menu
      '("Misc Menu"
	("Repeat"
	 ["Repeat complex command..." repeat-complex-command t]
	 ["Repeat matching complex command..." 
	  repeat-matching-complex-command t]
	 )
	("Customize"
	 ("Global Popup Menus"
	  ["C Programming Menu" 
	   (set-default 'hm--global-popup-menu-v 'hm--c-programming-menu) 
	   t]
	  ["C++ Programming Menu" 
	   (set-default 'hm--global-popup-menu-v 'hm--c++-programming-menu) 
	   t]	  
	  ["Lisp Programming Menu"  
	   (set-default 'hm--global-popup-menu-v 'hm--lisp-programming-menu) t]
	  ["Misc Menu" (set-default 'hm--global-popup-menu-v 'hm--misc-menu) t]
	  ["Register Menu" 
	   (set-default 'hm--global-popup-menu-v 'hm--register-menu) t]
	  ["Replace Menu" 
	   (set-default 'hm--global-popup-menu-v 'hm--replace-menu) t]
	  ["Search Menu" 
	   (set-default 'hm--global-popup-menu-v 'hm--search-menu) t]
	  ["Window Menu" 
	   (set-default 'hm--global-popup-menu-v 'hm--window-menu) t]
	  )
	 ("Local Popup Menus"
	  ["C Programming Menu" 
	   (hm--set-popup-menu 'hm--c-programming-menu) t]
	  ["C++ Programming Menu" 
	   (hm--set-popup-menu 'hm--c++-programming-menu) t]
	  ["Lisp Programming Menu"
	   (hm--set-popup-menu 'hm--lisp-programming-menu) t]
	  ["Misc Menu" (hm--set-popup-menu 'hm--misc-menu) t]	  
	  ["Register Menu" (hm--set-popup-menu 'hm--register-menu) t]
	  ["Replace Menu" (hm--set-popup-menu 'hm--replace-menu) t]
	  ["Search Menu" (hm--set-popup-menu 'hm--search-menu) t]
	  ["Window Menu" (hm--set-popup-menu 'hm--window-menu) t]
	  "----"
	  ["Kill Local Menu" (kill-local-variable 'hm--global-popup-menu-v) t]
	  )
	 ("Modi"
	  ["Describe mode" describe-mode t]
	  ["Set default mode" normal-mode t]
	  ("Major"
	   ["awk-mode" awk-mode t]
	   ["c-mode" c-mode t]
	   ["c++-mode" c++-mode t]
	   ["c++-c-mode" c++-c-mode t]
	   ["edit-abbrevs-mode" edit-abbrevs-mode t]
	   ["emacs-lisp-mode" emacs-lisp-mode t]
	   ["fortran-mode" fortran-mode t]
	   ["fundamental-mode" fundamental-mode t]
	   ["html-mode" html-mode t]
	   ["latex-mode" latex-mode t]
	   ["lisp-interaction-mode" lisp-interaction-mode t]
	   ["lisp-mode" lisp-mode t]
	   ["outline-mode" outline-mode t]
	   ["tex-mode" tex-mode t]
	   ["texinfo-mode" texinfo-mode t]
	   ["text-mode" text-mode t]
	   )
	  ("Minor"
	   ["auto-fill-mode" auto-fill-mode t]
	   ["abbrev-mode" abbrev-mode t]
	   ["font-lock-mode" font-lock-mode t]
	   ["outline-minor-mode" outline-minor-mode t]
	   ["overwrite-mode" overwrite-mode t]
	   ["picture-mode" picture-mode t]
	   )
	  )
	 )
	))


(add-menu nil "Misc  " (cdr hm--misc-menu))


;;
;;  Register- Untermenue
;;

(defvar hm--register-menu nil "*Liste mit dem Menue Register.")

(setq hm--register-menu
      '("Register"
	("copy-to-register" 
	 ["A" (hm--copy-to-register 65 "A") t]
	 ["B" (hm--copy-to-register 66 "B") t]
	 ["C" (hm--copy-to-register 67 "C") t]
	 ["D" (hm--copy-to-register 68 "D") t]
	 ["E" (hm--copy-to-register 69 "E") t]
	 ["F" (hm--copy-to-register 70 "F") t]
	 )
	("copy-rectangle-to-register"
	 ["A" (hm--copy-rectangle-to-register 65 "A") t]
	 ["B" (hm--copy-rectangle-to-register 66 "B") t]
	 ["C" (hm--copy-rectangle-to-register 67 "C") t]
	 ["D" (hm--copy-rectangle-to-register 68 "D") t]
	 ["E" (hm--copy-rectangle-to-register 69 "E") t]
	 ["F" (hm--copy-rectangle-to-register 70 "F") t] 
	 )
	("append-to-register" 
	 ["A" (append-to-register 65 (region-beginning) (region-end)) nil]
	 ["B" (append-to-register 66 (region-beginning) (region-end)) nil]
	 ["C" (append-to-register 67 (region-beginning) (region-end)) nil]
	 ["D" (append-to-register 68 (region-beginning) (region-end)) nil]
	 ["E" (append-to-register 69 (region-beginning) (region-end)) nil]
	 ["F" (append-to-register 70 (region-beginning) (region-end)) nil]
	 )
	("prepend-to-register" 
	 ["A" (prepend-to-register 65 (region-beginning) (region-end)) nil]
	 ["B" (prepend-to-register 66 (region-beginning) (region-end)) nil]
	 ["C" (prepend-to-register 67 (region-beginning) (region-end)) nil]
	 ["D" (prepend-to-register 68 (region-beginning) (region-end)) nil]
	 ["E" (prepend-to-register 69 (region-beginning) (region-end)) nil]
	 ["F" (prepend-to-register 70 (region-beginning) (region-end)) nil]
	 )
	("view-copy-register"
	 ["A" (view-register 65) nil]
	 ["B" (view-register 66) nil]
	 ["C" (view-register 67) nil]
	 ["D" (view-register 68) nil]
	 ["E" (view-register 69) nil]
	 ["F" (view-register 70) nil] 
;	 ["A-F" (hm--view-register-A-F) nil]
	 )
	("insert-register"
	 ["A" (hm--insert-register 65) nil]
	 ["B" (hm--insert-register 66) nil]
	 ["C" (hm--insert-register 67) nil]
	 ["D" (hm--insert-register 68) nil]
	 ["E" (hm--insert-register 69) nil]
	 ["F" (hm--insert-register 70) nil] 
	 )
	"----"
	("point-to-register" 
	 ["U" (hm--point-to-register 85 "U") t]
	 ["V" (hm--point-to-register 86 "V") t]
	 ["W" (hm--point-to-register 87 "W") t]
	 ["X" (hm--point-to-register 88 "X") t]
	 ["Y" (hm--point-to-register 89 "Y") t]
	 ["Z" (hm--point-to-register 90 "Z") t]
	 )
	("jump-to-register"
	 ["U" (jump-to-register 85) nil]
	 ["V" (jump-to-register 86) nil]
	 ["W" (jump-to-register 87) nil]
	 ["X" (jump-to-register 88) nil]
	 ["Y" (jump-to-register 89) nil]
	 ["Z" (jump-to-register 90) nil] 
	 )
	("view-point-register"
	 ["U" (view-register 85) nil]
	 ["V" (view-register 86) nil]
	 ["W" (view-register 87) nil]
	 ["X" (view-register 88) nil]
	 ["Y" (view-register 89) nil]
	 ["Z" (view-register 90) nil] 
	 )
	)
      )

(delete-menu-item '("Misc  " "Register"))

(add-menu '("Misc  ") 
	  "Register" 
	  (cdr hm--register-menu) 
	  "Customize")

(setq hm--register-menu-prefix '("Misc  "))

(defun hm--copy-to-register (reg &optional reg-string)
  "Interface-Funktion fr copy-to-register."
  (interactive "cRegister: ")
  (enable-menu-item 
   (append 
    hm--register-menu-prefix 
    '("Register")
    '("insert-register")
    (list reg-string)))
  (enable-menu-item 
   (append 
    hm--register-menu-prefix 
    '("Register")
    '("view-copy-register")
    (list reg-string)))
  (enable-menu-item 
   (append 
    hm--register-menu-prefix 
    '("Register")
    '("append-to-register")
    (list reg-string)))
  (enable-menu-item 
   (append 
    hm--register-menu-prefix 
    '("Register")
    '("prepend-to-register")
    (list reg-string)))
  (copy-to-register reg (region-beginning) (region-end)))

(defun hm--copy-rectangle-to-register (reg &optional reg-string)
  "Interface-Funktion fr copy-rectangle-to-register."
  (interactive "cRegister: ")
  (enable-menu-item 
   (append 
    hm--register-menu-prefix 
    '("Register")
    '("insert-register")
    (list reg-string)))
  (enable-menu-item 
   (append 
    hm--register-menu-prefix 
    '("Register")
    '("view-copy-register")
    (list reg-string)))
  (copy-rectangle-to-register reg (region-beginning) (region-end)))

(defun hm--insert-register (reg)
  "Interface-Funktion fr insert-register."
  (interactive "cRegister: ")
  (insert-register reg))

(defun hm--view-register-A-F ()
  "Zeigt den Inhalt der Register A bis F an.
FUNKTIONIRT NOCH NICHT !"
  (interactive)
  (view-register 65)
  (view-register 66)
  (view-register 67)
  (view-register 68)
  (view-register 69)
  (view-register 70))

(defun hm--point-to-register (reg &optional reg-string)
  "Interface-Funktion fr point-to-register."
  (interactive "cRegister: ")
  (enable-menu-item 
   (append 
    hm--register-menu-prefix 
    '("Register")
    '("jump-to-register")
    (list reg-string)))
  (enable-menu-item 
   (append 
    hm--register-menu-prefix 
    '("Register")
    '("view-point-register")
    (list reg-string)))
  (point-to-register reg))


;;
;;  Search- Untermenue
;;

(defvar hm--search-menu nil "*Liste mit dem Menue Search.")

(setq hm--search-menu
      '("Search"
	["Isearch forward..." isearch-forward t]
	["Isearch backward..." isearch-backward t]
	("Advanced Isearch"
	 ["Isearch forward regexp..." isearch-forward-regexp t]
	 ["Isearch backward regexp..." isearch-backward-regexp t]
	 "----"
	 ("Repeat"
	  ["Isearch repeat forward" isearch-repeat-forward t]
	  ["Isearch repeat backward" isearch-repeat-backward t]
	  ["Isearch ring retreat edit..." isearch-ring-retreat t]
	  ["Isearch ring advance edit..." isearch-ring-advance t]
	  )
	 "----"
	 ["Isearch yank word" isearch-yank-word t]
	 ["Isearch exit" isearch-exit t]
	 ("Case"
	  ["Ignore case OFF" hm--isearch-ignore-case-off t]
	  ["Ignore case ON" hm--isearch-ignore-case-on t]
	  )
	 "----"
	 ("Help on search"
	  ["Isearch mode help" isearch-mode-help t]
	  ["Goto Info Node Regexps" (Info-goto-node "(emacs)Regexps") t]
	  )
	 )
	"----"
	("Search"
	 ["Search forward" hm--search-forward t]
	 ["Search backward" hm--search-backward t]
	 ["Search repeat forward" hm--search-repeat-forward t]
	 ["Search repeat backward" hm--search-repeat-backward t]
	 "----"
	 ["Regexp search forward" re-search-forward t]
	 ["Regexp search backward" re-search-backward t]
	 ["Word search forward" word-search-forward t]
	 ["Word search backward" word-search-backward t]
	 )
	("Search over files"
	 ["grep..." hm--grep t]
	 ["Tags search..." tags-search t]
	 )
	))
      
(delete-menu-item '("Misc  " "Search"))

(add-menu '("Misc  ") 
	  "Search" 
	  (cdr hm--search-menu) 
	  "Customize")

(setq hm--search-menu-prefix '("Misc  "))

(defun hm--isearch-ignore-case-off ()
  "Sorgt dafr, dass beim Suchen die Gross-/Kleinschreibung nicht
ignoriert wird."
  (interactive)
  (setq case-fold-search nil)
  )

(defun hm--isearch-ignore-case-on ()
  "Sorgt dafr, dass beim Suchen die Gross-/Kleinschreibung 
ignoriert wird."
  (interactive)
  (setq case-fold-search t)
  )

(defun hm--grep (directory arg-text)
  "Ruft die Funktion grep auf."
  (interactive "DDirectory for grep: \nsSearchstring and Files: ")
  (cd directory)
  (grep arg-text)
  (let ((menu-path (append 
		    hm--search-menu-prefix 
		    '("Search")
		    '("Search over files"))))
    (delete-menu-item (append menu-path (list "First occurance")))
    (delete-menu-item (append menu-path (list "Next occurance")))
    (add-menu-item menu-path 
		   "First occurance" 
		   'hm--jump-to-next-line 
		   t 
		   "grep"))
  )

(defun hm--jump-to-next-line ()
  "Ruft die Funktion next-error auf"
  (interactive)
  (next-error)
  (let ((menu-path (append 
		    hm--search-menu-prefix 
		    '("Search")
		    '("Search over files"))))
    (delete-menu-item (append menu-path (list "First occurance")))
    (add-menu-item menu-path 
		   "Next occurance" 
		   'hm--jump-to-next-line 
		   t 
		   "grep"))
  )


(defvar hm--search-string nil
  "Last string from search with hm--search-forward or hm--search-backward.")


(defun hm--search-forward (string)
  "Wrap around for 'search-forward' which use the variable hm--search-string."
  (interactive "sSearch: ")
  (setq hm--search-string string)
  (search-forward string))


(defun hm--search-backward (string)
  "Wrap around for 'search-backward' which use the variable hm--search-string."
  (interactive "sSearch: ")
  (setq hm--search-string string)
  (search-backward string))


(defun hm--search-repeat-forward ()
  "Repeat 'search-forward' with the variable hm--search-string."
  (interactive)
  (search-forward hm--search-string))


(defun hm--search-repeat-backward ()
  "Repeat 'search-backward' with  the variable hm--search-string."
  (interactive)
  (search-backward hm--search-string))


;;
;;  Replace- Untermenue
;;

(defvar hm--replace-menu nil "*Liste mit dem Menue Register.")

(setq hm--replace-menu
      '("Replace"
	["Query replace..." query-replace t]
	["Query replace regexp..." query-replace-regexp t]
	["Replace string..." replace-string t]
	["Replace regexp..." replace-regexp t]
	["Tags query replace..." tags-query-replace t]
	"----"
	("Case"
	 ["Ignore case OFF" hm--isearch-ignore-case-off t]
	 ["Ignore case ON" hm--isearch-ignore-case-on t]
	 ["Convert case OFF" hm--replace-ignore-case-off t]
	 ["Convert case ON" hm--replace-ignore-case-on t]
	 )
	"----"
	("Help on replace"
	 ["Goto Info Node Replace" (Info-goto-node "(emacs)Replace") t]
	 ["Goto Info Node Regexps" (Info-goto-node "(emacs)Regexps") t]
	 )
	))
      
(delete-menu-item '("Misc  " "Replace"))

(add-menu '("Misc  ") 
	  "Replace" 
	  (cdr hm--replace-menu) 
	  "Customize")

(defun hm--replace-ignore-case-off ()
  "Sorgt dafr, dass beim Suchen die Gross-/Kleinschreibung nicht
ignoriert wird."
  (interactive)
  (setq case-replace nil)
  )

(defun hm--replace-ignore-case-on ()
  "Sorgt dafr, dass beim Suchen die Gross-/Kleinschreibung 
ignoriert wird."
  (interactive)
  (setq case-replace t)
  )



;;
;; Popup-Menues
;;

(defvar hm--global-popup-menu-v nil "*Legt das Globale Popup-Menu fest.")

(make-variable-buffer-local 'hm--global-popup-menu-v)

(set-default 'hm--global-popup-menu-v 'hm--replace-menu)

(defun hm--popup-menu (e)
  "Gibt Popup-Menu aus."
  (interactive "@e")
  (popup-menu hm--global-popup-menu-v))

(defun hm--set-popup-menu (menu)
  "Aendert das global Popup-Menu."
  (interactive "vMenu Name: ")
  (setq hm--global-popup-menu-v menu))

      
;; autoloads

(autoload 'c++-c-mode "c++-mode" 
	  "Major mode for editing K&R and ANSI C code. Revision: 2.261 
This mode is based on c++-mode. Documentation for this mode is
available by doing a \"C-h d c++-mode\".")







