;;
;; Default configuration for ilisp with cmulisp
;; Stefan Strobel '94
;;

;;;
;;; function for ilisp
;;;

(defun eval-buffer-ilisp ()
  "eval the buffer and go to ilisp"
  (interactive)
  (eval-region-and-go-lisp 1 (point-max)))

;;;
;;; Settings for ilisp
;;;
;;;

;;; If you always want partial minibuffer completion
;;;(require 'completer)

(autoload 'run-ilisp "ilisp" "Select a new inferior LISP." t)
;;; Autoload based on your LISP.  You only really need the one you use.
;;; If called with a prefix, you will be prompted for a buffer and
;;; program.
;;; 
(autoload 'cmulisp      "ilisp" "Inferior CMU Common LISP." t)
;;;(autoload 'clisp     "iclisp" "Inferior CLISP." t)
;;;(autoload 'clisp     "ilisp" "Inferior Generic Common LISP." t)
;;;(autoload 'kcl       "ilisp" "Inferior Kyoto Common LISP." t)
(autoload 'akcl         "ilisp" "Inferior Austin Kyoto Common LISP." t)
;;;(autoload 'ibcl      "ilisp" "Ibuki Common LISP." t)
;;;(autoload 'scheme    "ilisp" "Inferior generic Scheme." t)
;;;(autoload 'oaklisp   "ilisp" "Inferior Oaklisp Scheme." t)

;;; Define where LISP programs are found.  (This may already be done
;;; at your site.)
(setq cmulisp-program "/usr/local/bin/cmulisp")
(setq akcl-program    "/usr/local/bin/akcl")

;;; If you run cmu-cl then set this to where your source files are.
(setq cmulisp-local-source-directory 
      "/usr/local/cmulisp/source")

(setq lisp-no-popper t)

;;; This makes reading a lisp file load in ilisp.
(set-default 'auto-mode-alist
	     (append '(("\\.lisp$" . lisp-mode)) 
		     '(("\\.cl$" . lisp-mode))
		     '(("\\.lsp$" . lisp-mode))
		     auto-mode-alist))

(add-hook 'lisp-mode-hook 
	  '(lambda () 
	     (require 'ilisp)
	     (font-lock-mode 1)
	     (abbrev-mode 1)
	     (define-key lisp-mode-map [menu-bar ilisp] 
	       (cons "Ilisp" (make-sparse-keymap "ilisp")))
	     (define-key lisp-mode-map [menu-bar ilisp il-evalbu]
	       '("Eval Buffer" . eval-buffer-ilisp))
	     (define-key lisp-mode-map [menu-bar ilisp il-tracede]
	       '("Trace Defun" . trace-defun-lisp))
	     (define-key lisp-mode-map [menu-bar ilisp il-evaldef]
	       '("Eval Defun and go" . eval-defun-and-go-lisp))
	     (define-key lisp-mode-map [menu-bar ilisp il-load]
	       '("Load Lisp File" . load-file-lisp))
	     (define-key lisp-mode-map [menu-bar ilisp il-switchto]
	       '("Switch to Lisp" . switch-to-lisp))
	     (define-key lisp-mode-map [menu-bar ilisp il-start]
	       '("Start CMU Lisp" . cmulisp))))


(add-hook 'ilisp-load-hook 
	  '(lambda ()
	     ;; Change default key prefix to C-c
	     (setq ilisp-prefix "\C-c")
	     (condition-case nil
		 (lisp-directory "~/" t)
	       (error nil))))

