# Abbreviation completion module
if $edit_flag {

set abbrev_match ""
set old_abbrev ""
set old_abbrev_loc ""
set abbrev_words ""
set abbrev_list ""
set abbrev_wordlist ""

# Abbreviation list maintainance

# Does a binary search on a sorted list. Index returned is either index of
# item, or index of element immediately before item.
proc slist_bisearch {list item} {
	set min -1
	set max [llength $list]
	while {($min < [expr $max - 1])} {
		set i [expr [expr $min + $max] / 2]
		set r [lindex $list $i]
		if {$item < $r} {set max $i ; continue
		} elseif {$item > $r} {set min $i ; continue
		} else {return $i}
	}
	return $min
}

proc abbrev {abb word} {
	global abbrev_list abbrev_wordlist
	if {$abbrev_list == ""} {
		set abbrev_list $abb
		set abbrev_wordlist [list $word]
		return
	}
	set i [slist_bisearch $abbrev_list $abb]
	if {$i == -1} {set abbrev_list [concat [list $abb] $abbrev_list]
		set abbrev_wordlist [concat [list $word] $abbrev_wordlist]
	} elseif {[lindex $abbrev_list $i] == $abb} {
		set abbrev_wordlist [lreplace $abbrev_wordlist $i $i $word]
	} else {incr i
		if {$i == [llength $abbrev_list]} {
			lappend abbrev_list $abb
			lappend abbrev_wordlist $word
		} else {set abbrev_list [linsert $abbrev_list $i $abb]
			set abbrev_wordlist [linsert $abbrev_wordlist $i $word]
}}
	return
}

proc add_abbrev_aux {t l e} {
	abbrev [$t get "insert -1c wordstart" insert] [$e get]
	destroy_f_entry $t $l $e
}

proc add_abbrev {t f} {
	create_f_entry $t $f.abbl $f.abbe
	$f.abbl configure -text "Expand abbreviation to:"
	global Keys
	parse_bindings $f.abbe $Keys(C_m) "add_abbrev_aux $t $f.abbl $f.abbe"
}

# Prints out abbrevs into file, or stdout if file is empty
proc write_abbrevs {{file ""}} {
	if {$file == ""} {set f ""
	} else {set f [open $file "w"]}

	global abbrev_list abbrev_wordlist
	set line "# Abbreviation lists"
	if {$f == ""} {puts $line} else {puts $f $line}
	set line "set abbrev_list \{\{[join $abbrev_list "\}\n\t\{"]\}\}"
	if {$f == ""} {puts $line} else {puts $f $line}
	set line "set abbrev_wordlist \{\{[join $abbrev_wordlist "\}\n\t\{"]\}\}"
	if {$f == ""} {puts $line} else {puts $f $line}
	set line "return"
	if {$f == ""} {puts $line} else {puts $f $line}
	if {$f != ""} {close $f}
}

# Returns prefix which is either the word before insert, or a prefix of this
# word (i.e. the word has recently been extended.)
proc get_prefix {t} {
	global old_abbrev old_abbrev_loc abbrev_match
	set old_wordstart [$t index "insert -1c wordstart"]
	set word [$t get $old_wordstart insert]
	if {[string length $word] == 1} {return ""}
	if {($old_abbrev_loc != $old_wordstart) || ($old_abbrev != [string range $word 0 [expr [string length $old_abbrev] - 1]])} {
		set old_abbrev_loc $old_wordstart
		set old_abbrev $word
		set abbrev_match ""
	}
	return $old_abbrev
}

# Returns a unique completion of prefix in t, or "" if unsuccessful.
proc get_another_completion {t prefix} {
	global abbrev_match abbrev_words
	set old_wordstart [$t index "insert -1c wordstart"]
	while {1} {
		if {$abbrev_match == ""} {
			set abbrev_words ""
			set abbrev_match $old_wordstart}
		if {$abbrev_match == "end"} {
			set abbrev_match [text_string_last $t $prefix $abbrev_match]
			if {$abbrev_match == ""} {return ""}
		} else {set abbrev_match [text_string_last $t $prefix "$abbrev_match -1c"]
			if {$abbrev_match == ""} {set abbrev_match end ; continue}}
		if {[$t compare "$abbrev_match -1c wordstart" == $old_wordstart]} {
			set abbrev_match "" ; return ""}
		if {[$t compare "$abbrev_match -1c wordstart" != "$abbrev_match -1c"]} {continue}
		set new_word [$t get $abbrev_match "$abbrev_match wordend"]
		if {[lsearch -exact $abbrev_words $new_word] >= 0} {continue}
		lappend abbrev_words $new_word
		return $new_word
}}

proc complete_abbrev {t} {
	if {[set prefix [get_prefix $t]] == ""} {
		$t insert insert \t
		return}
	global abbrev_list abbrev_wordlist
	set i [slist_bisearch $abbrev_list $prefix]
	if {[lindex $abbrev_list $i] == $prefix} {
		set word [lindex $abbrev_wordlist $i]
	} elseif {[set word [get_another_completion $t $prefix]] == ""} {
		beep; return}
	$t delete "insert -1c wordstart" insert
	$t insert insert $word
	global modified ;	set modified 1
}

proc show_abbrev_completions {t} {
	if {[set prefix [get_prefix $t]] == ""} {beep ; return}
	while {[get_another_completion $t $prefix] != ""} {}
	global abbrev_words
	if {$abbrev_words == ""} {beep ; return}
	set word [tk_dialog_listbox .conf "Completion Dialog" \
	"Possible completed words:" $abbrev_words [string length $prefix]]
	if {$word == ""} {return}
	$t delete "insert -1c wordstart" insert
	$t insert insert $word
	global modified ;	set modified 1
}


proc abbrevbind {f t m} {
	parse_bindings all \
C-g		"+catch \{destroy_f_entry %W $f.abbl $f.abbe\}"

	parse_bindings Text \
Tab		{complete_abbrev %W} \
C-Tab		{show_abbrev_completions %W} \
M-a		"add_abbrev %W $f "

	if {[winfo exists $m]} {parse_menu $m \
{Abbreviations 0 		{"Complete Word" 0 Tab}
				{"Show Completion Info" 16 C-Tab}
				{"Add Abbreviation" 4 M-a}}

		$m.abbreviations.m add command -label "Save Fixed Abbrevs" \
			-underline 0 -command "setup_wish_cmd $t $f {Abbreviation Save Command: (Enter a file)} abbrev_save_cmd"
		$m.abbreviations.m add command -label "Load Fixed Abbrevs" \
			-underline 0 -command "setup_wish_cmd $t $f {Abbreviation Load Command: (Enter a file)} abbrev_load_cmd"
}}


abbrevbind $frame $text $menu

set abbrev_save_cmd "write_abbrevs "
set abbrev_load_cmd "source "
set tab_completion_defined 1
}
