# Bindings to execute keybindings under different contexts


# Default number of times a command gets iterated through universal argument
# (if no value is entered)
set default_universal_number 10

proc universal_key_execute {t f w c k} {
	if {(![regexp . $c])} {return}
	set n [$f.unie get]
	if {($n == "")} {global default_universal_number ; set n $default_universal_number}
	if {$k == ""} {set k $c}
	if {$k == "Control-g"} {eval [bind all <Control-g>] ; return}
	if {$k == "Escape"} {eval [bind Entry <Escape>] ; return}
	destroy_f_entry $t $f.unil $f.unie
	set cmd [return_menubinding $k $c]
	for {set i 1} {($i <= $n)} {incr i} {eval $cmd}
# If we want beth to go busy during universal-key, we'll use this line instead.
#	beth_busy $t iterate_cmd $n $t $f $cmd
}

proc uke_key {t f w c k} {
	if {([regexp {[0-9]} $c])} {$w insert end $c
	} else {universal_key_execute $t $f $w $c $k}
}

proc universal_key_setup {t f} {
	create_f_entry $t $f.unil $f.unie
	$f.unil configure -text "Universal Argument:"
	$f.unie configure -width 4

	parse_bindings $f.unie \
Key			"uke_key $t $f %W %A %K" \
C-Key			"universal_key_execute $t $f %W %A Control-%K" \
M-Key			"universal_key_execute $t $f %W %A Meta-%K" \
M-C-Key			"universal_key_execute $t $f %W %A Meta-Control-%K" \
}


# Procs to send key functions to other Beth interpreters

proc exit_all {t f} {
	catch "destroy_f_entry $t $f.alll $f.alle"
	parse_bindings $t {M-k M-K} ""
	global menu
	menuentries_change_state $menu.extras.m.send normal 0 1 2 3
	menuentries_change_state $menu.extras.m.send disabled 5 6
}

proc do_single_keybinding {f t k c} {
	exit_all $t $f
	after 1 [return_menubinding $k $c]
}

# Performs function associated with keybinding in all interpreters, indluding
# this one (last).  c and events are as in return_keybinding. deiconify_flag
# if 1 sends to all interps, otherwise, just to mapped ones.
proc remote_execute_keybinding {t f deiconify_flag k c} {
	if {![regexp . $c]} {return}
	if {$k == ""} {set k $c}
	global all_status
	if {($all_status != "permanent")} {exit_all $t $f}
	remote_execute_keybinding_aux $t $f $deiconify_flag $k $c
# If we want beth to go busy during all-keybinding events (which often take
# some time anyway) use the following line instead:
#	beth_busy $t remote_execute_keybinding_aux $t $f $deiconify_flag $k $c
}

proc remote_execute_keybinding_aux {t f deiconify_flag k c} {
	global all_status all_interps me old_focus
	foreach interp $all_interps {
		if {($interp == $me)} {continue}
		if {(![check_send $interp {winfo ismapped .}]) && ($deiconify_flag == 0)} {continue}
		check_send $interp [list do_single_keybinding $f $t $k $c]
	}
	if {[catch "focus $old_focus"]} {focus $t}
# Dont execute the keybinding on the all entry, that would make an infinite loop
	if {$old_focus == "$f.alle"} {switch_focus}
	eval [return_menubinding $k $c]
	set old_focus [focus]
	if {![winfo exists $f.alle]} {exit_all $t $f ; return}
	if {($all_status == "permanent")} {	focus $f.alle}
}

proc toggle_all {f t} {
	global all_status
	if {($all_status == "temporary")} {
		set all_status "permanent"
		set all [$f.alle get]
		$f.alle delete 0 end
		$f.alle insert 0 "$all Permanent"
		$f.alle configure -width [string length "$all Permanent"]
		focus $f.alle
		global menu
		menuentries_change_state $menu.extras.m.send disabled 5
	} else {exit_all $t $f
}}

proc all_mode_setup {t f deiconify_flag} {
	if {($deiconify_flag)} {set all "All"} else {set all "All Shown"}
	global old_focus all_status
	set old_focus [focus]
	set all_status temporary

	create_f_entry $t $f.alll $f.alle
	pack forget $f.alll
	pack $f.alle -expand no -fill none
	$f.alle insert 0 $all
	$f.alle configure -width [string length $all]

	global menu
	menuentries_change_state $menu.extras.m.send disabled 0 1 2 3
	menuentries_change_state $menu.extras.m.send normal 5 6

	foreach binding [bind $f.alle] {bind $f.alle $binding ""}
	parse_bindings $f.alle \
{M-k M-K}	"toggle_all $f $t" \
Key		"remote_execute_keybinding $t $f $deiconify_flag %K %A" \
C-Key		"remote_execute_keybinding $t $f $deiconify_flag Control-%K %A"\
M-Key		"remote_execute_keybinding $t $f $deiconify_flag Meta-%K %A" \
C-M-Key		"remote_execute_keybinding $t $f $deiconify_flag \
							Control-Meta-%K %A"

	parse_bindings $t \
{M-k M-K}	[bind $f.alle <Meta-k>]
}


# 'Key' bindings. f is a frame widget to put messages in.
proc keybind {f t m} {
	parse_bindings all \
C-g			"+catch \{destroy_f_entry $t $f.unil $f.unie\}" \
M-K			"all_mode_setup %W $f 1" \
M-k			"all_mode_setup %W $f 0" \
C-u			"universal_key_setup %W $f"

	if {[winfo exists $m]} {parse_menu $m \
{Extras 1 {"Send Key to" 0 ""	{"All Interpreters" 0 M-K}
				{"All Shown Interpreters" 4 M-k}
				{"All Interpreters Permanantly" 4 {-}}
				{"All Shown Interpreters Permanantly" 23 {-}}
					separator
				{"Switch to Permanant" 1 M-k}
				{"Stop sending key" 1 {-}}}
				{"Universal Argument" 0 C-u}}
		menuentries_change_state $m.extras.m.send disabled 5 6
		$m.extras.m.send entryconfigure 2 -accel "" -command \
			"all_mode_setup $t $f 1 ; toggle_all $f $t"
		$m.extras.m.send entryconfigure 3 -accel "" -command \
			"all_mode_setup $t $f 0 ; toggle_all $f $t"
		$m.extras.m.send entryconfigure 6 -accel "" -command \
			"exit_all $t $f"
}}


keybind $frame $text $menu
