#
# Module for performing searches in Listbox widgets
#


# Searches for next occurrence of string in w.
proc th_Listbox_find {w string {next 1} {direction "forward"} {type "string"}} {
  global TH
  set was_search [$w nearest 0]
  if {$TH(Search,Select,[winfo class $w]) == "sel"} {$w select clear}
  if $next {
    set border(forward) [expr $was_search +1]
    set border(backward) [expr $was_search -1]
  } else {
    set border(forward) $was_search
    set border(backward) $was_search
  }

  if {[catch "set TH(Search,Failed,$w)"]} {set TH(Search,Failed,$w) 0}
  if $TH(Search,Failed,$w) {
    set border(forward) 0
    set border(backward) end
  }

  set length [string length $string]
  if {($length == 0)} {return 0}

  set found [th_Listbox_[set type]_[set direction] $w $border($direction) $string]
  if {($found != -1)} {
    if {$TH(Search,Select,[winfo class $w]) == "sel"} {
      $w select from $found
      $w select to $found
    }
    $w yview $found
    set TH(Search,Failed,$w) 0
    return 1
  } else {
    set TH(Search,Failed,$w) 1
    return 0
}}


# Finds first occurrence of string after point in widget w
# Returns index of found occurrence, or -1 if unsuccessful.
proc th_Listbox_string_forward {w point string} {
  global TH
  set end [$w size]
  if {$point == "end"} {set point $end}
  for {set x $point} {$x < $end} {incr x} {
    set text [$w get $x]
    if $TH(Search,Case,$w) {set text [string tolower $text]}
    if {([string first $string $text] != -1)} {return $x}
  }
  return -1
}

# Finds last occurrence of string before point in widget w
# Returns start and end of occurance or "" if unsuccessful.
proc th_Listbox_string_backward {w point string} {
  global TH
  set end [$w size]
  if {$point == "end"} {set point $end}
  for {set x $point} {$x >= 0} {incr x -1} {
    set text [$w get $x]
    if $TH(Search,Case,$w) {set text [string tolower $text]}
    if {([string first $string $text] != -1)} {return $x}
  }
  return -1
}


# The glob routines find first occurrence of string after point in widget
# w, using Tcl's string match command (which uses glob expressions).
# Returns index of match, or -1 if unsuccessful.

proc th_Listbox_glob_forward {w point string} {
  global TH
  set end [$w size]
  if {$point == "end"} {set point $end}
  for {set x $point} {$x < $end} {incr x} {
    set text [$w get $x]
    if $TH(Search,Case,$w) {set text [string tolower $text]}
    if {[string match $string $text]} {return $x}
  }
  return -1
}

proc th_Listbox_glob_backward {w point string} {
  global TH
  set end [$w size]
  if {$point == "end"} {set point $end}
  for {set x $point} {$x >= 0} {incr x -1} {
    set text [$w get $x]
    if $TH(Search,Case,$w) {set text [string tolower $text]}
    if {[string match $string $text]} {return $x}
  }
  return -1
}


# Finds first occurrence of string after point in widget w using regexp.
# Returns start and end of occurance or "" if unsuccessful.
proc th_Listbox_regexp_forward {w point string} {
  global TH
  set end [$w size]
  if {$point == "end"} {set point $end}
  for {set x $point} {$x < $end} {incr x} {
    if $TH(Search,Case,$w) {
      if {[catch {regexp -nocase -- $string [$w get $x]} result]} {th_beep ; return -1}
    } else {if {[catch {regexp -- $string [$w get $x]} result]} {th_beep ; return -1}}
    if $result {return $x}
  }
  return -1
}

# Like regexp_forward, but searches from beginning to point.
proc th_Listbox_regexp_backward {w point string} {
  global TH
  set end [$w size]
  if {$point == "end"} {set point $end}
  for {set x $point} {$x >= 0} {incr x -1} {
    if $TH(Search,Case,$w) {
      if {[catch {regexp -nocase -- $string [$w get $x]} result]} {th_beep ; return -1}
    } else {if {[catch {regexp -- $string [$w get $x]} result]} {th_beep ; return -1}}
    if $result {return $x}
  }
  return -1
}


# Cleans up widget from searching.
proc th_Listbox_search_exit {w} {
  global TH
  if {$TH(Search,Select,[winfo class $w]) == "sel"} {$w select clear}
}


