#
# Operations for Lisp function/comment manipulation in Text widgets.
#


# Function boundary routines

proc th_check_defun {w index} {
  scan [$w index $index] "%d.%d" row column
  if {$column != 1} {return 0}
  set op "\(" ;   set cp "\)"
  if {[$w get "$row.0"] != $op} {return 0}
  return 1
}

proc th_defun_begin {w index} {
  global TH
  if {[file extension $TH(File,$w)] == ".scm"} {set function_begin "define"
  } else {set function_begin "defun"}
  set index "$index +[string length $function_begin] c +1c"
  while {[set index [th_Text_string_last $w $function_begin $index]] != ""} {
    if {[th_check_defun $w $index]} {  return "$index -1c"}
  }
  return ""
}

proc th_defun_end {w index} {
  if {[set begin [th_defun_begin $w $index]] == ""} {return ""}
  set e [th_Text_right_exp $w "$begin +1c" [list "\(" "\)"]]
  if {$e == ""} {return ""}
  set end "$e +1c"
  th_Text_add_tag_range $w function $begin $end
  return $end
}

proc th_defun_next {w index} {
  global TH
  if {[file extension $TH(File,$w)] == ".scm"} {set function_begin "define"
  } else {set function_begin "defun"}
  set index "$index +2c"
  while {[set index [th_Text_string_first $w $function_begin $index]] != ""} {
    if {[th_check_defun $w $index]} {  return "$index -1c"}
  }
  return ""
}

proc th_defun_prev {w index} {
  if {[$w compare [set begin [th_defun_begin $w $index]] != $index]} {
    return $begin 
  } else {return [th_defun_begin $w "$index -1c"]
}}

proc th_defun_select {w} {
  set s [th_defun_begin $w insert] ; set e [th_defun_end $w insert]
  if {($s == "") || ($e == "")} {th_beep ; return}
  th_Text_select_range $w $s $e
  th_Text_add_tag_range $w function $s $e
}


# Comment boundary routines

proc th_lispcomment_begin {w index} {
  scan [$w index $index] "%d.%d" i dummy
  if {[$w get "$i.0"] != ";"} {return ""}
  for {} {$i > 0} {incr i -1} {
    if {([$w get "$i.0"] == ";") && ([$w get "$i.0 -1 line"] != ";")} {
      return "$i.0"
  }}
  if {[$w get 1.0] == ";"} {return 1.0} else {return ""}
}

proc th_lispcomment_end {w index} {
  scan [$w index $index] "%d.%d" i dummy
  scan [$w index end] "%d.%d" e dummy
  if {[$w get "$i.0"] != ";"} {return ""}
  for {} {$i < $e} {incr i} {
    if {([$w get "$i.0"] != ";")} {return "$i.0 -1c"}}
  if {[$w get "$e.0"] == ";"} {return end} else {return ""}
}

proc th_lispcomment_next {w index} {
  scan [$w index $index] "%d.%d" i dummy
  scan [$w index end] "%d.%d" e dummy
  for {} {$i < $e} {incr i} {
    if {([$w get "$i.0"] != ";") &&
      ([$w get "$i.0 +1l"] == ";")} {return "$i.0 +1l"}}
  return ""
}

proc th_lispcomment_prev {w index} {
  if {[$w compare [set begin [th_lispcomment_begin $w $index]] != $index]} {
    return $begin 
  } else {return [th_lispcomment_begin $w "$index -1c"]
}}


# Adjusts selected region to fit in length columns, so that no lines wrap
# If unspecified, length defaults to window width.
proc th_lispcomment_format {w start end {length ""}} {
  if {$start == ""} {th_beep ; return}
  set s [$w index $start] ; set e [$w index $end]
  if {($length == "")} {set length [lindex [$w configure -width] 4]}
  set chars [$w get $s $e]
  set m1 [th_gensym] ; set m2 [th_gensym]
  $w mark set $m1 $s ; $w mark set $m2 $e
  th_Text_register_undoable_cmd $w [list th_Text_undo_filter $w $m1 $m2 \
		 $chars] "Adjust $chars" "$m1 $m2"
  set prefix ""
  for {set i 0} {[string first [$w get "$s +$i c"] "; "] >= 0} {incr i} {
    append prefix [$w get "$s +$i c"]
  }
  th_Text_delete_prefix $w $m1 $m2 $prefix
  th_Text_format $w $m1 $m2 [expr $length - [string length $prefix]]
  th_Text_add_prefix $w $m1 $m2 $prefix
  $w mark set $m1 "$m1 linestart"
  th_Text_add_tag_range $w comment $m1 $m2
}


proc th_lisp_mark {w} {
  th_Text_insert $w "\n"
  if {[$w get "insert -1l linestart"] == ";"} {
    th_Text_add_tag_range $w comment [th_lispcomment_begin $w "insert -1c"] "insert-1c"
  }
  if {[$w get "insert -2c"] == "\)"} {
    th_Text_balance_add_tag_range $w function th_defun_begin [list "\(" "\)"]
}}


