#
# Module to perform iteration on a widget
#


proc th_iterate_binding {w} {
  set f [th_show_entry $w iterate]
  $f.l configure -text "Iteration Argument:"
  $f.e configure -width 4
  $f.e delete 0 end
  bind $f.e <Key> "th_iterate_aux $w $f %A %K"
  bind $f.e <Control-Key> "th_do_iteration $w $f %A Control-%K"
  bind $f.e <Meta-Key> "th_do_iteration $w $f %A Meta-%K"
  bind $f.e <Control-Meta-Key> "th_do_iteration $w $f %A Control-Meta-%K"
}

proc th_iterate_aux {w f c b} {
  if {([regexp {[0-9]} $c])} {$f.e insert end $c
  } else {th_do_iteration $w $f $c $b}
}

proc th_do_iteration {w f c b} {
  if {(![regexp . $c])} {return}
  th_hide_entry $w iterate
  global TH
  if {([set n [$f.e get]] == "")} {set n $TH(Iterate,Default)}
  if {$b == ""} {set b $c}
  if {![catch "set TH(Binding,Cancel)"]} {
    if {[lsearch $TH(Binding,Cancel) $b] >= 0} {
      eval [bind $w $b]
      return
  }}
  if {[set cmd [th_return_binding $w $b $c]] == ""} {th_beep ; return}
  for {set i 1} {($i <= $n)} {incr i} {eval $cmd}
}

# Given a key, returns its keybinding in the current widget.
proc th_return_binding {widget binding {c ""}} {
  set key_binding [th_general_bind $binding]
  if {[string length $binding] == 1} {set binding "Key-$binding"}
  foreach spec "$widget [winfo class $widget] all" {
    if {[set cmd [bind $spec <$binding>]] != ""} {break}
    if {[set cmd [bind $spec <$key_binding>]] != ""} {break}
    if {[set cmd [bind $spec <Any-$binding>]] != ""} {break}
    if {[set cmd [bind $spec <Any-$key_binding>]] != ""} {break}
  }
  if {$cmd == ""} {return ""}

  if {[regsub -all {%K} $cmd $binding new_cmd]} {set cmd $new_cmd}
  if {[regsub -all {%W} $cmd $widget new_cmd]} {set cmd $new_cmd}
  if {$c != ""} {if {[regsub -all {%A} $cmd [th_char_protect $c] new_cmd]} {
        set cmd $new_cmd}}
  return $cmd
}

# Returns a keybinding's generalization (Ex: Control-x -> Control-Key)
proc th_general_bind {binding} {
  set list [split $binding {-}]
  set length [llength $list]
  incr length -2
  if {$length == -1} {return Key
  } else {return "[join [lrange $list 0 $length] {-}]-Key"}
}

# Protects certain chars by preceding them with a \.
proc th_char_protect {c} {
  if {($c == {[}) || ($c == {]}) || ($c == " ") ||
    ($c == "{") || ($c == "}")} {
    return "\\$c"} else {return $c}
}


