#
# Module for managing grids in Entry widgets
#

# Called by a Entry widget to tell w what to view
proc th_Entry_view {w dummy1 dummy2 y dummy4} {$w view $y}

# Turns on or off the horizontal grid on w
# Args are packing info for the grid.
proc th_Entry_toggle_grid_x {w args} {
  set g $w ; append g "gridx"
  global TH
  if {[winfo exists $g]} {
# turn grid off
    set TH(Grid_X,$w) 0

# Reset w's scrollcommand to its scrollbar or nothing if it didn't have one.
    if {[scan [lindex [$g configure -scrollcommand] 4] "%s set" sc] >= 0} {
      $w configure -scrollcommand "$sc set"
    } else {$w configure -scrollcommand {}}
    destroy $g
  } else {
    set TH(Grid_X,$w) 1
# turn grid on
    entry $g -relief ridge -font [lindex [$w configure -font] 4] \
      -width [lindex [$w configure -width] 4] -borderwidth 2
    eval pack $g -before $w $args

# Disable scanning on g.
    foreach binding {<2> <B2-Motion>} { bind $g $binding {info tclversion} }

# Fill g with column numbers
    set width [string length [$w get]] ; incr width -1
    $g delete 0 end
    for {set column 0} {$column <= $width} {incr column} {
      set char [string index $column [expr [string length $column] - 1]]
      if {$char == 0} {$g insert end "_"
      } else {$g insert end $char}}
    $g configure -state disabled

# Tie w's scrollcommand over to g.
    $g view [$w index @0]
    if {[scan [lindex [$w configure -scrollcommand] 4] "%s set" sc] >= 0} {
# Give g the responsibility of moving w's scrollbar.
      $g configure -scrollcommand "$sc set"
    }
    $w configure -scrollcommand "th_Entry_view $g"
}}
