#
# Module for editing Misc widgets
#

# Prints the last undoable command.
proc th_look_undo {w} {
  global TH
  if {[catch "set TH(Undo,Data,$w)"]} {set TH(Undo,Data,$w) ""}
  if {([llength $TH(Undo,Data,$w)] == 0)} {th_beep ; return}
  set text "Last: [lindex [lindex $TH(Undo,Data,$w) 0] 1]"
  if {([string length $text] > $TH(Undo,Label,Max))} {
    set text "[string range $text 0 $TH(Undo,Label,Max)]..."}
  th_flash_label $w -text $text
}

# Clears the undo log.
proc th_kill_undos {w} {
  global auto_index
  if {([info procs th_[winfo class $w]_kill_undos] != "") || \
     ([lsearch [array names auto_index] th_[winfo class $w]_kill_undos] >= 0)} {
    th_[winfo class $w]_kill_undos $w
  }
  global TH ; set TH(Undo,Data,$w) ""
}


# Quoting

proc th_quote {w} {
  set f [th_frame $w]
  label $f.quote -text "Quote"
  pack $f.quote -side right
  set old_focus [focus]
  focus $f.quote
  bind $f.quote <Key> "th_quote_abort $w $old_focus %A"
  bind $f.quote <Control-Key> "th_unquote $w $old_focus %A"
}

proc th_quote_abort {w focus c} {
  if {(![regexp . $c])} {return}
  th_beep
  destroy [th_frame $w].quote
  focus $focus
}

proc th_unquote {w focus c} {
  th_[winfo class $w]_insert $w $c
  set f [th_frame $w]
  destroy $f.quote
  focus $focus
}


# Some filters to do to strings

proc th_string_tolower {s} {return [string tolower $s]}
proc th_string_toupper {s} {return [string toupper $s]}
proc th_string_capitalize {s} {return "[string toupper [string index $s 0]][string tolower [string range $s 1 end]]"
}


# Entry for specifying indenting for text.

proc th_indent {w fn} {
  if {[set f [th_show_entry $w indent]] == ""} {th_beep ; return}
  $f.l configure -text "Indent Prefix:"
  th_bind $f.e OK "$fn $w"
}


