#
# Module for browsing around in Text widgets
#

# Puts cursor at $where, where is an acceptable text index, or an integer,
# which means the beginning of that line.
proc th_Text_goto {w where {dont_stay 1}} {
  if {[regexp {[0-9]*} $where howmuch] && 
      ([string length $howmuch] == [string length $where]) &&
      ($howmuch == $where)} {
    set where "$where.0 linestart"
  }
  if {[catch {$w compare insert == $where} flag]} {th_beep ; return 0}
  if {$dont_stay && $flag} {th_beep ; return 0}

  $w mark set insert $where
  if {[lindex [$w configure -state] 4] == "disabled"} {
    $w yview insert } else {  $w yview -pickplace insert}
  return 1
}

# Moves view to where, and puts insert in view, if it isn't in already.
proc th_Text_scroll {w where {v ""}} {
  if {[$w compare $where == @0,0]} {th_beep ; return 0}
  $w yview $where
  if {($v == "")} {set v [lindex [$w configure -height] 4]}
  if {![th_Text_visible_insert $w $v]} {
    $w mark set insert "@0,0 +[expr "$v/2"] lines"
  }
  return 1
}

# Returns 1 if insert is visible.
proc th_Text_visible_insert {w {v ""}} {
  if {($v == "")} {set v [lindex [$w configure -height] 4]}
  if {([$w compare insert < @0,0]) ||
      ([$w compare insert >= "@0,0 +$v lines"])} {
    return 0} else {return 1
}}

# d is +n or -n, for some n>0
proc th_Text_adjacent_line {w d} {
  global TH
  if {[catch "set TH(Column,$w)"]} {set TH(Column,$w) 0}
  scan [$w index insert] "%d.%d" r c
  if {[$w compare insert == "insert $d lines"]} {
    if {([string first "+" $d] != -1)} {
      $w mark set insert end ; th_beep
    } else {$w mark set insert 1.0 ; th_beep}
  } elseif {($c < $TH(Column,$w)) && [$w compare insert == {insert lineend}]} {
    $w mark set insert "insert $d lines linestart"
    if {[$w compare "insert +$TH(Column,$w) chars" <= "insert lineend"]} {
      $w mark set insert "insert +$TH(Column,$w) chars"
    } else {$w mark set insert "insert lineend"}
  } elseif {[$w compare "insert $d lines" == "insert $d lines lineend"]} {
    $w mark set insert "insert $d lines"
    set TH(Column,$w) $c
  } else {$w mark set insert "insert $d lines"}

  if {[$w compare insert != {insert lineend}]} {  set TH(Column,$w) 0}
  th_Text_goto $w insert 0
}

proc th_Text_select_next_line {w} {
  if {[catch "$w index sel.last"]} { set start insert
  } elseif {([$w compare insert < sel.first]) ||
      ([$w compare insert > sel.last])} {
    $w tag remove sel sel.first sel.last
    set start insert
  } else {set start sel.first}
  if {($start == "insert")} {  set near $start
  } else { set near sel.last}
  if {([$w get $near] == "\n")} {
    $w tag add sel $start "$near +1 chars"
    } else {$w tag add sel $start "$near lineend"}
  th_Text_goto $w sel.last
}

proc th_Text_select_range {w start end} { 
  if {([$w compare $start >= $end])} {th_beep ; return}
  set s [$w index $start]
  set e [$w index $end]
  catch {$w tag remove sel sel.first sel.last}
  $w tag add sel $s $e
}
 
proc th_Text_select_region {w} {
  if {![catch {set m [$w index mark]}]} {
    if {[$w compare $m <= insert]} {
      th_Text_select_range $w $m insert
    } else {th_Text_select_range $w insert $m}
  } else {th_beep
}}

proc th_Text_exchange_mark {w} {
  if {[catch {set m [$w index mark]}]} {th_beep ; return}
  $w mark set mark insert
  th_Text_goto $w $m
}


