#
# Module for browsing around in Misc widgets
#

# Brings up an entry for goto operation, then calls appropriate goto proc.
proc th_goto {w} {
  if {[set f [th_show_entry $w goto]] == ""} {th_beep ; return}
  $f.l configure -text "Goto:"
  th_bind $f.e OK "th_hide_entry $w goto ; th_[winfo class $w]_goto $w \"\[%W get\]\""
}


# In these procedures, d is 'x' or 'y'

# Returns value of w's scrollbar.
proc th_Misc_scrollvalue {w d} {
  return [[lindex [lindex [$w configure -[set d]scroll] 4] 0] get]
}

proc th_Misc_line {w d i} {
  set s [th_Misc_scrollvalue $w $d]
  $w [set d]view [expr $i + [lindex $s 2]]
}

proc th_Misc_page_backward {w d} {
  set s [th_Misc_scrollvalue $w $d]
  set delta [expr [lindex $s 3] - [lindex $s 2]]
  if {$delta < 3} {set delta 3}
  $w [set d]view [expr [lindex $s 2] - $delta + 1]
}

proc th_Misc_page_forward {w d} {
  set s [th_Misc_scrollvalue $w $d]
  set delta [expr [lindex $s 3] - [lindex $s 2]]
  if {$delta < 3} {set delta 3}
  $w [set d]view [expr [lindex $s 2] + $delta -1]
}

proc th_Misc_edge_end {w d} {
  set s [th_Misc_scrollvalue $w $d]
  $w [set d]view [lindex $s 0]
}


# Word traversal in strings

proc th_is_alphanumeric {c} {return [string match {[A-Za-z0-9_]} $c]}

# Returns start of word containing index in string, which may be index.
proc th_string_wordstart {s index} {
  if {![th_is_alphanumeric [string index $s $index]]} {return $index}
  set curs [expr $index-1]
  if {$curs < 0} {return 0}
  for {set x $curs} {$x >= 0} {incr x -1} {
    if {![th_is_alphanumeric [string index $s $x]]} {break}}
  return [incr x]
}

# Returns end of word containing index in string, which must be after index.
proc th_string_wordend {s index} {
  if {![th_is_alphanumeric [string index $s $index]]} {return [expr $index +1]}
  set curs [expr $index+1]
  set end [string length $s]
  if {$curs >= $end} {return $end}
  for {set x $curs} {$x < $end} {incr x} {
    if {![th_is_alphanumeric [string index $s $x]]} {break}}
  return $x
}


