#
# File to help extend & stylize the widgets used by the hypertools
#


proc update_arguments {var value} {
  global Arg_Count argc argv 
  if {[catch "set Arg_Count"]} {set Arg_Count 0}
  if {$argc > $Arg_Count} {uplevel #0 set $var \{[lindex $argv $Arg_Count]\}
  } elseif {$value != "var"} { uplevel #0 set $var \{$value\} }
  incr Arg_Count
  return [uplevel #0 set $var]
}

# Creates an entry. The entry lives in frame w, also created. A historyth menu
# is given, named 'prompt:', and the entry is tied to variable var, and set
# with initial value value. If value is var, it is set to the current value of
# var. (got that?)
proc create_form_entry {w prompt var {value var}} {
  set val [update_arguments $var $value]
  frame $w
  eval pack $w -f x -expand no
  uplevel #0 entry $w.e -textvariable $var
  pack $w.e -f x -expand no -s bottom
  th_make_history_menu $w.e
  $w.thistory configure -text "$prompt:"
  if {$val != ""} {th_add_history $w.thistory $w.e $val $val}
}

# Creates a scale, named w, with text prompt, and tied to variable var, and set
# with initial value value. Args are additional arguments to give to the scale.
# (such as -from 10 -to 20)
proc create_form_scale {w prompt var {value var} args} {
  set val [update_arguments $var $value]
  scale $w -label $prompt -command "set $var" -orient horizontal
  eval $w configure $args
  pack $w -s top -expand no -f x
  $w set $val
}

# Creates a checkbutton, named w, with text prompt, and tied to variable var,
# and set with initial value value, packed on side side.
proc create_form_checkbutton {w prompt var {value var} {side top}} {
  set val [update_arguments $var $value]
  checkbutton $w -text $prompt -variable $var
  pack $w -f x -expand yes -f x -s $side
}

# Shows the help window, inserting text if necessary.
proc show_help {} {
  wm deiconify .tl ; raise .tl
  if {[.tl.t compare 1.0 != end]} {return}

  global Help ; .tl.t insert insert $Help
  set index [string length [.tl.t get 1.0 end]]
  while {[set new_index [string last "\n\n" [.tl.t get 1.0 "1.0 +$index c"]]] >= 0} {
    set i [.tl.t index "1.0 +$new_index c +2 l linestart"]
    if {([.tl.t get "$i +1l linestart"] == "\n")} {
	.tl.t tag add header $i "$i lineend"
    }
    set index $new_index
  }
  .tl.t tag add header 1.0 "1.0 wordend"
  .tl.t configure -state disabled
}

# Create the help window.
if {![catch {toplevel .tl}]} {
  wm withdraw .tl
  text .tl.t -relief sunken -setgrid true -yscrollcommand ".tl.s set"
  wm title .tl "Help [wm title .]"
  wm iconname .tl "Help [wm title .]"
  scrollbar .tl.s -relief raised -command ".tl.t yview"
  .tl.t tag configure header -u 1 -relief raised -border 5
  
  # This code was created by taggeth
  global TH
  set TH(Tag,Menu,Length) 30
  set TH(Tag,Start) 1
  set TH(Tag,End) 0
  set TH(Tag,Empty) 0
  set TH(Tag,Entries,Max) 20
  frame .tl.t_mb
  pack .tl.t_mb -f x -s top -anchor e
  
  menubutton .tl.t_mb.extras -m .tl.t_mb.extras.m -text Index -u 0
  pack .tl.t_mb.extras -in .tl.t_mb -s left
  menu .tl.t_mb.extras.m
  .tl.t_mb.extras.m add cascade -l Tags -u 0 -m .tl.t_mb.extras.m.tags
  menu .tl.t_mb.extras.m.tags
  .tl.t_mb.extras.m.tags add command -l {Useless} -u 0 -acc {} -co {if {[winfo exists .tl.t]} {
    
  } else {
    destroy .tl.t_mb}}
  .tl.t_mb.extras.m entryconfigure last -co {th_Text_make_tags_menu .tl.t .tl.t_mb.extras.m.tags}
  
  button .tl.t_mb.quit -text "OK" -co "wm withdraw .tl"
  pack .tl.t_mb.quit -s right -f x -expand yes
  pack .tl.t -s right -expand yes -f both
  pack .tl.s -s right -f y


  # Add standard completion to entry widgets.
  set auto_path "$TH_Dir/lib $auto_path"
  set TH(Binding,Complete_Word) {<Tab>}

  set Entry_Completions {{th_line_complete {th_cascading_menu_entries \
      "[winfo parent %W].thistory"} none}
   {th_substring_replace th_string_tcl_result {[}}
   {th_substring_replace th_string_global_value {$}}
   {th_substring_replace th_string_glob_files { }}
   {th_substring_complete th_filter_cmds {[}}
   {th_substring_complete th_filter_vars {$}}
   {th_substring_complete th_filter_glob { }}
  }
  
  bind Entry <Tab> "th_Entry_complete_multiple %W [list $Entry_Completions]"
  bind Entry <Control-Tab> {th_Entry_completion_dialog %W}
}


