#
# Bindings for Paragrath
#


set Bindings(Paragraph) {
  {Begin_Para 		{th_Text_goto %W [th_para_begin %W insert]}}
  {End_Para		{th_Text_goto %W [th_para_end %W insert]}}
  {Next_Para		{th_Text_goto %W [th_para_next %W insert]}}
  {Prev_Para		{th_Text_goto %W [th_para_prev %W insert]}}
  {Select_Para		{th_para_select %W}}
  {Delete_Para_Backward	{th_Text_delete_range %W [th_para_begin %W insert] insert}}
  {Delete_Para_Forward	{th_Text_delete_range %W insert [th_para_end %W insert]}}
  {Kill_Para		{th_Text_kill_range %W [th_para_begin %W insert] [th_para_end %W insert]}}
  {Split_Para		{th_Text_insert %W "\n" ; if {[%W get "insert-2c"] != "\n"} {th_para_format %W [th_para_begin %W "insert -1c"] "insert -1c"}}}
  {Reformat_Para	{th_para_format %W [th_para_begin %W insert] [th_para_end %W insert]}}
  {Indent_Region        {th_indent %W th_Text_indent_add_para}}
  {Delete_Indent        {th_indent %W th_Text_indent_delete_para}}
  {Update_Para 		{th_Text_tag_regions %W paragraph th_para_begin th_para_end th_para_next}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Begin_Para End_Para Next_Para Prev_Para Select_Para
	Delete_Para_Backward Delete_Para_Forward Kill_Para Split_Para
	Reformat_Para Indent_Region Delete_Indent Update_Para}


set TH_Bindings_Help {
Paragraph Functions

This module introduces the concept of paragraphs to text widgets. A paragraph is
any text bounded by two newlines (i.e. one blank line) on beginning and end. It
adds some simple editing and browsing commands for paragraphs. One can traverse
between paragraphs with Control-N and Control-P. Control-N puts the cursor at
the beginning of the next paragraph, and Control-P puts the cursor at the
beginning of the previous paragraph (or current one if it is not already there).
One can select the current paragraph with Control-J. And Control-A moves to the
beginning of the current paragraph, while Control-E goes to the end.

				Control-
				   P
Paragraph:	Traversal:	 A + E
				   N
		Select:		   J

Several editing functions are also added. Control-D deletes from the cursor to
the end of the paragraph, and Control-H deletes from cursor to beginning of the
paragraph. Neither can be yanked, but both are undoable. Finally, Control-U
kills the current paragraph, it can be yanked, though not undone.

				Control-
Region:		Delete:		 H + D
		Kill:		   U

There are two functions to alleviate the problem between logical lines and
physical lines of text. A logical line is the contents of the widget actually
known to the program, while a physical line is what you see on the screen. A
physical line cannot be wider than the width of the text widget, but a logical
line can. The difference between these can lead to confusion when examining
files under a different editor, or printing them.

This program provides two functions to help alleviate this problem. First of
all, whenever you hit <Return>, the previous line of text (which will usually
have just been entered by you) is split up into sizes the width of the window;
i.e. into logical lines small enough that they match the physical lines you see
on the screen.

The other command is Meta-j, which reformats the paragraph. Not only does it
break up long lines, but it merges together short ones. Meta-j works on the
current paragraph containing the cursor. It does this adjustment by first
removing the newlines in the paragraph, making it into one long logical line,
then breaking it up into screen-size logical lines, just like Return does.
Paragraph:	Adjust:		Meta-j

Paragrath also works with taggeth to provide an index of paragraphs. If taggeth
is included, it adds a menu option called "Update Paragraphs" to the Index menu.
This option adds a 'paragraph' tag to each paragraph. This does not visibly
alter the text, but one can then go to any paragraph quickly using the Tags
submenu off the Index menu. Normally, the program tries to maintain the tags so
you don't have to use this option. It tags all the paragraphs upon startup, and
several functions, such as Select-Paragraph also will adjust this tag, so you
often can edit the file without explicitly calling this option.
}


