/********************************************************************
 *                                                                  *
 *    CRISP - Custom Reduced Instruction Set Programmers Editor     *
 *                                                                  *
 *    This is the terminal description file for XTERM, with         *
 *    Jeff Jennings' modifications to make it actually work.        *
 ********************************************************************/

# include   "tty.h"
void
main()
{
      
	/***********************************************/
	/*   Set   characters   used   for   extended  */
	/*   graphics support when drawing windows.    */
	/***********************************************/
	set_term_characters(
		"l",	/* Top left of window.			    */
		"k",	/* Top right of window.			    */
		"m",	/* Bottom left of window.		    */
		"j",	/* Bottom right of window.		    */
		"x",	/* Vertical bar for window sides.	    */
		"q",	/* Top and bottom horizontal bar for window.*/
		"w",	/* Top join.				    */
		"v",	/* Bottom join.				    */
		"n",	/* Window 4-way intersection.		    */
		"u",	/* Left hand join.      		    */
		"t"	/* Right hand join.      		    */
		);
         /***********************************************/
         /*   Define   escape   sequences   used   for  */
         /*   special optimisations on output.		*/
         /***********************************************/
	set_term_features(
            NULL,         /* Sequence to clear 'n' spaces.	  */
                          /* ("\x1B[%dX" almost works, but	  */
                          /* doesn't preserve standout mode,      */
                          /* so help menus don't look right.)     */
            NULL,         /* Sequence to print characters with top*/
                          /* bit set.                             */
            NULL,         /* Insert-mode cursor.                  */
            NULL,         /* Overwrite-mode cursor.               */
            NULL,         /* Insert-mode cursor (on virtual space)*/
            NULL,         /* Overwrite-mode cursor (on virtual space)*/
            NULL,         /* Print ESCAPE character graphically.  */
            NULL,         /* Escape sequence to repeat last character*/
            FALSE,        /* ESC [0m resets color.                */
            FALSE,        /* Terminal supports color.             */
            "\x1B[%dC",   /* Sequence to move cursor on same line.*/
            TRUE,         /* ESC[K gives us a black erased line.  */
            FALSE,        /* Allow scrolling (ins/del)		  */
            "\x1B(0",     /* Enter graphics mode.                 */
            "\x1B(B"      /* Exit graphics mode.                  */
            );
      
         /***********************************************/
         /*   Define  keyboard  layout  for  non-ascii  */
         /*   characters.  These  can only be used for  */
         /*   the console).                */
         /***********************************************/
  set_term_keyboard(
         F1_F12, quote_list(
             "\x1B[11~", "\x1B[12~", "\x1B[13~", "\x1B[14~", 
             "\x1B[15~", "\x1B[17~", "\x1B[18~", "\x1B[19~",
             "\x1B[20~", "\x1B[21~", "\x1B[23~", "\x1B24~" ),
     
         CTRL_F1_F12, quote_list(
             "\x1B[CF1~", "\x1B[CF2~", "\x1B[CF3~", "\x1B[CF4~", 
             "\x1B[CF5~", "\x1B[CF6~", "\x1B[CF7~", "\x1B[CF8~",
             "\x1B[CF9~", "\x1B[CF10~", "\x1B[CF11~", "\x1B[CF12~"),
        
         SHIFT_F1_F12, quote_list(
             "\x1B[SF1~", "\x1B[SF2~", "\x1B[SF3~", "\x1B[SF4~", 
             "\x1B[SF5~", "\x1B[SF6~", "\x1B[SF7~", "\x1B[SF8~",
             "\x1B[SF9~", "\x1B[SF10~", "\x1B[SF11~", "\x1B[SF12~"),
     
         /***********************************************/
         /*   These are the ALT-letter keys.           */
         /***********************************************/
         ALT_A_Z, quote_list(
             "\x1Ba", "\x1Bb", "\x1Bc", "\x1Bd", "\x1Be",
             "\x1Bf", "\x1Bg", "\x1Bh", "\x1Bi", "\x1Bj",
             "\x1Bk", "\x1Bl", "\x1Bm", "\x1Bn", "\x1Bo",
             "\x1Bp", "\x1Bq", "\x1Br", "\x1Bs", "\x1Bt",
             "\x1Bu", "\x1Bv", "\x1Bw", "\x1Bx", "\x1By",
             "\x1Bz"),
     
         /***********************************************/
         /*   These   are   the   LEFT-letter  Numeric  */
         /*   keys.  Not  all  of these are accessible  */
         /*   from openwin.                   */
         /***********************************************/
         ALT_0_9, quote_list(
             "\x1B0", "\x1B1", "\x1B2", "\x1B3", "\x1B4",
             "\x1B5", "\x1B6", "\x1B7", "\x1B8", "\x1B9"),
     
         KEYPAD_0_9, quote_list(
            "\x1B[2~",    "\x1BOw",    "\x1BOB", "\x1B[6~",
            "\x1BOD",    "\x1B[218z", "\x1BOC", "\x1BOq",
            "\x1BOA",    "\x1B[5~"),
                             
         CTRL_KEYPAD_0_9, quote_list(
            "\x1B[KC0~", "\x1B[KC1~", "\x1B[KC2~", "\x1B[KC3~",
            "\x1B[KC4~", "\x1B[KC5~", "\x1B[KC6~", "\x1B[KC7~",
            "\x1B[KC8~", "\x1B[KC9~" ),
/*            
         SHIFT_KEYPAD_0_9, quote_list(
            "\x1B[KS0~", "\x1B[KS1~", "\x1B[KS2~", "\x1B[KS3~",
            "\x1B[KS4~", "\x1B[KS5~", "\x1B[KS6~", "\x1B[KS6~",
            "\x1B[KS8~", "\x1B[KS9~" ),
*/            
                                     
          SHIFT_KEYPAD_2, "\x1BKS2~",
          SHIFT_KEYPAD_4, "\x1BKS4~",
          SHIFT_KEYPAD_6, "\x1BKS6~",
          SHIFT_KEYPAD_8, "\x1BKS8~",
          SHIFT_KEYPAD_MINUS, "\x1b[KS-",
          SHIFT_KEYPAD_PLUS,  "\x1b[KS+",
          
          KEY_CUT,     "\x1B[K-",
          KEY_COPY,    "\x1B[K+",
          KEY_UNDO,    "\x1B[K*",
          KEY_DEL,     "\x7f",
          
          CTRL_KEYPAD_MINUS, "\x1B[KC-",
          CTRL_KEYPAD_PLUS,  "\x1b[KC+",
          
          KEYPAD_PRTSC,    "\x1b[209z",
          KEYPAD_SCROLL,    "\x1b[210z"
  );
}
/**********************************************************************/
/*   Following  function  should  be  appended  to  BTERM  when  the  */
/*   hpfont is figured out on your system.                            */
/**********************************************************************/
void
hpfont()
{
    /***********************************************/
    /*   Set   characters   used   for   extended  */
    /*   graphics support when drawing windows.    */
    /***********************************************/
	set_term_characters(
		"l",	/* Top left of window.			    */
		"k",	/* Top right of window.			    */
		"m",	/* Bottom left of window.		    */
		"j",	/* Bottom right of window.		    */
		"x",	/* Vertical bar for window sides.	    */
		"q",	/* Top and bottom horizontal bar for window.*/
		"w",	/* Top join.				    */
		"v",	/* Bottom join.				    */
		"n",	/* Window 4-way intersection.		    */
		"u",	/* Left hand join.      		    */
		"t"	/* Right hand join.      		    */
		);
}

/**********************************************************************/
/*   Macro  called  when  a  mouse  button is hit from an Xterm when  */
/*   the mouse option is enabled in the window.                  */
/**********************************************************************/
int    mouse_cnt = 0;
void
xterm_mouse()
{    int    ch1, ch2, ch3;

    ch1 = read_char(0);
    ch2 = read_char(0);
    ch3 = read_char(0);
    message("Mouse hit %d! %s%s%s (%d,%d)", 
        mouse_cnt++,
        ch1 == ' ' ? "o" : "-",
        ch1 == '!' ? "o" : "-",
        ch1 == '"' ? "o" : "-",
        ch2 - ' ', ch3 - ' '
        );
    /***********************************************/
    /*   Let  CRISP  do  the real work of working  */
    /*   out whats happened to the mouse keys.     */
    /***********************************************/
    process_mouse(ch1 == ' ', ch1 == '!', ch1 == '"', 
        ch2 - ' ' - 1, 
        ch3 - ' ' - 1);
}

