/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *      (C) Paul Fox, 1989                                          *
 *                                                                  *
 *    Please See COPYRIGHT notice.                                  *
 *                                                                  *
 *   Terminal  description  file  for  Linux Console Colour display *
 ********************************************************************/

# include	"tty.h"

void
main()
{

	/***********************************************/
	/*   Set   characters   used   for   extended  */
	/*   graphics support when drawing windows.    */
	/***********************************************/
	set_term_characters(
		"l",	/* Top left of window.			    */
		"k",	/* Top right of window.			    */
		"m",	/* Bottom left of window.		    */
		"j",	/* Bottom right of window.		    */
		"x",	/* Vertical bar for window sides.	    */
		"q",	/* Top and bottom horizontal bar for window.*/
		"w",	/* Top join.				    */
		"v",	/* Bottom join.				    */
		"n",	/* Window 4-way intersection.		    */
		"u",	/* Left hand join.      		    */
		"t"	/* Right hand join.      		    */
		);

	/***********************************************/
	/*   Define   escape   sequences   used   for  */
	/*   special optimisations on output.	       */
	/***********************************************/
	set_term_features(
		NULL,		/* Sequence to clear 'n' spaces.	 */
		NULL,		/* Sequence to print characters with top */
		     		/* bit set.				 */
		NULL,		/* Insert-mode cursor.			 */
		NULL,		/* Overwrite-mode cursor.		 */
		NULL,		/* Insert-mode cursor (on virtual space).*/
		NULL,		/* Overwrite-mode cursor (on virtual space).*/
		NULL,		/* Print ESCAPE character graphically.	    */
		NULL,		/* Escape sequence to repeat last character.*/
		FALSE,		/* ESC [0m resets color.		    */
		TRUE,		/* Terminal supports color.		    */
		"\x1B[%dC",	/* Sequence to move cursor on same line.    */
		TRUE,		/* ESC[K gives us a black erased line.	  */
		FALSE,		/* Allow scrolling (ins/del)		  */
		"\x1B(0",	/* Enter graphics mode.			  */
		"\x1B(B"	/* Exit graphics mode.			  */
		);

	/***********************************************/
	/*   Define  keyboard  layout  for  non-ascii  */
	/*   characters.  These  can only be used for  */
	/*   the console).			       */
	/***********************************************/
	set_term_keyboard(
		ALT_KEYPAD_MINUS, "\x1BN-",
		F1_F12,	quote_list(
			"\x1B[11~", "\x1B[12~", "\x1B[13~", "\x1B[14~", "\x1B[15~", 
			"\x1B[17~", "\x1B[18~", "\x1B[19~", "\x1B[20~", "\x1B[21~", 
			"\x1B[23~", "\x1B[24~"),

		SHIFT_F1_F12, quote_list(
			"\x1B[SF1~", "\x1B[SF2~", "\x1B[SF3~", "\x1B[SF4~", "\x1B[SF5~",
			"\x1B[SF6~", "\x1B[SF7~", "\x1B[SF8~", "\x1B[SF9~", "\x1B[SF10~",
			"\x1B[SF11~", "\x1B[SF12~" ),
		CTRL_F1_F12, quote_list(
			"\x1BO\x10", "\x1BO\x11", "\x1BO\x12", "\x1BO\x13", 
			"\x1BO\x14", "\x1BO\x15", "\x1BO\x16", "\x1BO\x17", 
			"\x1BO\x18", "\x1BO\x19", "\x1BO\x1a", "\x1BO\x1B"),
		ALT_A_Z, quote_list(
			"\x1Ba", "\x1Bb", "\x1Bc", "\x1Bd", "\x1Be",
			"\x1Bf", "\x1Bg", "\x1Bh", "\x1Bi", "\x1Bj", 
			"\x1Bk", "\x1Bl", "\x1Bm", "\x1Bn", "\x1Bo", 
			"\x1Bp", "\x1Bq", "\x1Br", "\x1Bs", "\x1Bt", 
			"\x1Bu", "\x1Bv", "\x1Bw", "\x1Bx", "\x1By", 
			"\x1Bz"),
		KEYPAD_0_9, quote_list(
			"\x1B[2~", "\x1B[4~", "\x1B[B", "\x1B[6~", "\x1B[D",
			"\x1B[G", "\x1B[C", "\x1B[1~", "\x1B[A", "\x1B[5~"),
		CTRL_KEYPAD_0_9, quote_list("\x1B?0", "\x1B?1", "\x1B?2", "\x1B?3", "\x1B?4",
			"\x1B?5", "\x1B?6", "\x1B?7", "\x1B?8", "\x1B?9"),
		ALT_0_9, quote_list(
			"\x1B0", "\x1B1", "\x1B2", "\x1B3", "\x1B4",
			"\x1B5", "\x1B6", "\x1B7", "\x1B8", "\x1B9"),
		CUT,	"\x1B[S",
		COPY,	"\x1B[T",
		BACK_TAB, "\x1B[Z",
		KEYPAD_SCROLL, "\x1bO1",
		SHIFT_KEYPAD_0, "\x1BO4",
		SHIFT_KEYPAD_PLUS, "\x1BO3",
		SHIFT_KEYPAD_MINUS, "\x1BO2",
		SHIFT_KEYPAD_2, "?D",
		SHIFT_KEYPAD_4, "?L",
		SHIFT_KEYPAD_6, "?R",
		SHIFT_KEYPAD_8, "?U"
		);
}

/**********************************************************************/
/*   Called  if  -mono  is  part  of  the suffix list of BTERM. Note  */
/*   this  is  called  after  _init  above so we only change what we  */
/*   need.							      */
/**********************************************************************/
void
mono()
{
	set_term_features(
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		FALSE	/* Terminal does not supports color. */
		);
}
void
v43()
{
	set_term_features(
		NULL,
		NULL,
		"\x1B[=6;8C",		/* Insert-mode cursor.			    */
		"\x1B[=1;13C",		/* Overwrite-mode cursor.		    */
		"\x1B[=4;8C",		/* Insert-mode cursor (on virtual space).   */
		"\x1B[=1;3C"		/* Overwrite-mode cursor (on virtual space).*/
		);
		
	/***********************************************/
	/*   Make sure cursor comes on.		       */
	/***********************************************/
	insert_mode();
	insert_mode();
}
