
/* qddb/Utils/qedit.c
 * Edit a selected set of records (one at a time) given several
 * sets manipulated by the set operations union, intersection and
 * exclusion.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

void PrintKeyList _ANSI_ARGS_((Schema *, KeyList *));

void main(argc, argv)
    int				argc;
    char			**argv;
{
    Schema			*schema;
    char			Relation[BUFSIZ], *relname;
    char			*attr_and = NULL, *attr_or = NULL;
    KeyList			*list, *LastList = NULL;
    size_t			Length;
    int				i;
    int				startit;
    Qddb_SearchArg		search_args;
    
    if (argc < 3) {
	fprintf(stderr, "Usage: qprvals RelationDir [SearchString] [-attr_and Attribute]\
 [-attr_or Attribute] [-a SearchString] [-o SearchString]\
 [-r RegExp] [-n Number] [-nr Number-Number] [-sr SearchString-SearchString]\n");
	fflush(stderr);
	exit(1);
    }
    Qddb_Init();
    if ((relname = Qddb_FindRelation(argv[1])) == NULL)
	PANIC("Cannot find relation; please set QDDBDIRS");
    strcpy(Relation, relname);
    schema = Qddb_InitSchema(Relation);
    if (schema == NULL) {
	if (qddb_errmsg != NULL) {
	    fprintf(stderr, "%s", qddb_errmsg);
	} else {
	    fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
	}
	fflush(stderr);
	exit(1);
    }
    if (strcmp(argv[2], "-r") != 0 && strcmp(argv[2], "-n") != 0 &&
	strcmp(argv[2], "-sr") != 0 && strcmp(argv[2], "-nr") != 0 &&
	strcmp(argv[2], "-attr_or") != 0 && strcmp(argv[2], "-attr") != 0 &&
	strcmp(argv[2], "-attr_and") != 0) {
	search_args.Alpha = argv[2];
	search_args.Type = ALPHA;
	list = Qddb_Search(schema, &search_args, &Length, -1);
	LastList = list;
	startit = 3;
    } else
	startit = 2;
    for (i = startit; i < argc; i++) {
	char		ch;
	int		flag;

	flag = 0;
	ch = argv[i][1];
	if (argv[i][0] != '-') {
	    i--;
	    /* default to intersection, at Raphie's 
	     * request.
	     */
	    ch = 'a';
	    flag = 1;
	}
	switch (ch) {
	case 'a':
	    if (flag == 1 || strlen(argv[i]) == 2) { /* -a */
		search_args.Alpha = argv[i+1];
		search_args.Type = ALPHA;
		list = Qddb_Search(schema, &search_args, &Length, -1);
		if (attr_and != NULL) {
		    list = Qddb_KeyListProcess(schema, list, attr_and, QDDB_KEYLIST_PROC_PRUNE,
					       QDDB_KEYLIST_FLAG_PRUNEBYATTR);
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_INTERSECTION, 0);
		} else if (attr_or != NULL) {
		    list = Qddb_KeyListProcess(schema, list, attr_or, QDDB_KEYLIST_PROC_PRUNE,
					       QDDB_KEYLIST_FLAG_PRUNEBYATTR);
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION, 0);
		} else
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_INTERSECTION, 0);
		attr_and = attr_or = NULL;
		i++;
	    } else {
#ifdef ATTRIBUTED_SEARCH
		char			buf[BUFSIZ];

		/* -attr Attribute SearchString */
		if (strcmp("-attr", argv[i]) == 0 || strcmp("-attr_and", argv[i]) == 0) {
		    attr_or = NULL;
		    attr_and = argv[i+1];
		} else if (strcmp("-attr_or", argv[i]) == 0) {
		    attr_or = argv[i+1];
		    attr_and = NULL;
		} else {
		    fprintf(stderr, "bad option %s\n", argv[i]);
		    exit(1);
		}
		strcpy(buf, argv[i+1]);
		if (Qddb_ConvertAttributeNameToNumber(schema, buf) < 0) {
		    fprintf(stderr, "Attribute '%s' does not exist\n", argv[i+1]);
		    exit(1);
		}
		i++;
#else
		fprintf(stderr, "Attributed searches not supported.  Recompile QDDB \
with -DATTRIBUTED_SEARCH.\n");
		exit(1);
#endif
	    }
	    break;
	case 'o':
	    search_args.Alpha = argv[i+1];
	    search_args.Type = ALPHA;
	    list = Qddb_Search(schema, &search_args, &Length, -1);
	    if (attr_and != NULL) {
		list = Qddb_KeyListProcess(schema, list, attr_and, QDDB_KEYLIST_PROC_PRUNE,
					   QDDB_KEYLIST_FLAG_PRUNEBYATTR);
	    } else if (attr_or != NULL) {
		list = Qddb_KeyListProcess(schema, list, attr_or, QDDB_KEYLIST_PROC_PRUNE,
					   QDDB_KEYLIST_FLAG_PRUNEBYATTR);
	    }
	    attr_and = attr_or = NULL;
	    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION, 0);
	    i++;
	    break;
	case 'r':
	    search_args.Alpha = argv[i+1];
	    search_args.Type = REGEXP_V8;
	    list = Qddb_Search(schema, &search_args, &Length, -1);
	    if (attr_and != NULL) {
		list = Qddb_KeyListProcess(schema, list, attr_and, QDDB_KEYLIST_PROC_PRUNE,
					   QDDB_KEYLIST_FLAG_PRUNEBYATTR);
		LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_INTERSECTION, 0);
	    } else if (attr_or != NULL) {
		list = Qddb_KeyListProcess(schema, list, attr_or, QDDB_KEYLIST_PROC_PRUNE,
					   QDDB_KEYLIST_FLAG_PRUNEBYATTR);
		LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION, 0);
	    } else 
		LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION, 0);
	    i++;
	    attr_and = attr_or = NULL;
	    break;
	case 'n':
	    if (argv[i][2] == 'r') {
		NumericRange	nr;
		char		*range;
		
		nr.LowerExists = (argv[i+1][0] != '-');
		nr.UpperExists = (argv[i+1][strlen(argv[i+1])-1] != '-');
		range = argv[i+1];
		if (nr.LowerExists == True) {
		    int		index, len;
		    
		    len = strlen(argv[i+1]);
		    for (index = 0; index < len; index++)
			if (argv[i+1][index] == '-')
			    break;
		    argv[i+1][index] = '\0';
		    nr.Lower = strtod(argv[i+1], NULL);
		    range = argv[i+1]+index+1;
		} else {
		    nr.Lower = 0.0;
		    range++;
		}
		if (nr.UpperExists == True)
		    nr.Upper = strtod(range, NULL);
		else
		    nr.Upper = 0.0;
		search_args.UpperNum = nr.Upper;
		search_args.UpperExists = nr.UpperExists;
		search_args.LowerNum = nr.Lower;
		search_args.LowerExists = nr.LowerExists;
		search_args.Type = NUMERICRANGE;
		list = Qddb_Search(schema, &search_args, &Length, -1);
		if (attr_and != NULL) {
		    list = Qddb_KeyListProcess(schema, list, attr_and, QDDB_KEYLIST_PROC_PRUNE,
					       QDDB_KEYLIST_FLAG_PRUNEBYATTR);
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_INTERSECTION, 0);
		} else if (attr_or != NULL) {
		    list = Qddb_KeyListProcess(schema, list, attr_or, QDDB_KEYLIST_PROC_PRUNE,
					       QDDB_KEYLIST_FLAG_PRUNEBYATTR);
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION, 0);
		} else
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION, 0);
	    } else {
		search_args.Type = NUMERIC;
		search_args.Number = strtod(argv[i+1], NULL);
		list = Qddb_Search(schema, &search_args, &Length, -1);
		if (attr_and != NULL) {
		    list = Qddb_KeyListProcess(schema, list, attr_and, QDDB_KEYLIST_PROC_PRUNE,
					       QDDB_KEYLIST_FLAG_PRUNEBYATTR);
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_INTERSECTION, 0);
		} else if (attr_or != NULL) {
		    list = Qddb_KeyListProcess(schema, list, attr_or, QDDB_KEYLIST_PROC_PRUNE,
					       QDDB_KEYLIST_FLAG_PRUNEBYATTR);
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION, 0);
		} else
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION, 0);
	    }
	    i++;
	    attr_and = attr_or = NULL;
	    break;
	case 's':
	    if (argv[i][2] == 'r') {
		StringRange		nr;
		char		*range, *tmpstr;
		unsigned int	z, len;
		
		len = strlen(argv[i+1]);
		tmpstr = Malloc(len);
		strcpy(tmpstr, argv[i+1]);
		for (z = 0; z < len; z++)
		    if (_isupper(tmpstr[z]))
			tmpstr[z] = _tolower(tmpstr[z]);
		nr.LowerExists = (tmpstr[0] != '-');
		nr.UpperExists = (tmpstr[len-1] != '-');
		range = tmpstr;
		if (nr.LowerExists == True) {
		    int		index, len;
		    
		    len = strlen(tmpstr);
		    for (index = 0; index < len; index++)
			if (tmpstr[index] == '-')
			    break;
		    tmpstr[index] = '\0';
		    nr.Lower = tmpstr;
		    range = tmpstr+index+1;
		} else {
		    nr.Lower = NULL;
		    range++;
		}
		if (nr.UpperExists == True)
		    nr.Upper = range;
		else
		    nr.Upper = NULL;
		search_args.Type = ALPHARANGE;
		search_args.UpperStr = nr.Upper;
		search_args.UpperExists = nr.UpperExists;
		search_args.LowerStr = nr.Lower;
		search_args.LowerExists = nr.LowerExists;
		list = Qddb_Search(schema, &search_args, &Length, -1);
		if (attr_and != NULL) {
		    list = Qddb_KeyListProcess(schema, list, attr_and, QDDB_KEYLIST_PROC_PRUNE,
					       QDDB_KEYLIST_FLAG_PRUNEBYATTR);
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_INTERSECTION, 0);
		} else if (attr_or != NULL) {
		    list = Qddb_KeyListProcess(schema, list, attr_or, QDDB_KEYLIST_PROC_PRUNE,
					       QDDB_KEYLIST_FLAG_PRUNEBYATTR);
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION, 0);
		} else
		    LastList = Qddb_KeyListOp(schema, list, LastList, QDDB_KEYLIST_OP_UNION, 0);
		attr_and = attr_or = NULL;
	    } else
		PANIC("Bad option -s");
	    i++;
	    break;
	default:
	    fprintf(stderr, "Unknown option: %s\n", argv[i]);
	    PANIC("Cannot handle option");
	}
    }
    LastList = Qddb_KeyListProcess(schema, LastList, NULL, QDDB_KEYLIST_PROC_NULLOP, 
				   QDDB_KEYLIST_FLAG_DELDUP_SAMEENTRY);
    PrintKeyList(schema, LastList);
    exit(0);
}

void PrintKeyList(schema, list)
    Schema		*schema;
    KeyList		*list;
{
    Entry		ThisEntry = NULL;
    char		*out;
    int			DBFile;

    DBFile = OpenDatabase(schema->RelationName, 0);
    while (list != NULL) {
	if (Qddb_ReadEntryByKeyList(DBFile, schema->RelationName, &ThisEntry, list, True) == -1) { 
	    /* invalid entry */
	    list = list->next;
	    continue;
	}
	Qddb_ReducedAttrToFullAttr(schema, ThisEntry);
	out = (char *)Qddb_Convert(schema, QDDB_ENTRYTYPE_EXTERNAL, ThisEntry, QDDB_ENTRYTYPE_TCLEXTERNAL);
	printf("%s\n", out);
	list = list->next;
    }
    close(DBFile);
}

