
proc gp_isnum {n} {
    return [expr [catch "expr double($n)"] == 0]
}

proc gp_isdate {dt} {
    if {[qddb_util isdate $dt]} {
        return 1
    }
    return 0
}

proc gp_isword {w} {
    set w [string trim $w]
    set res [regexp -nocase {[a-z0-9]*} $w nw]
    if {[string compare $w $nw] == 0} {
	return 1
    }
    return 0
}

proc gp_isrange {r} {
    set r [split $r "-"]
    if {[llength $r] == 2} {
        return 1
    }
    return 0
}

proc gp_singlett {s pruneby} {
    global gv_schema gv_debug

    if {[gp_isrange $s] == 1} {
        set r [split $s "-"]
        set r1 [lindex $r 0]
        set r2 [lindex $r 1]
        if {[string compare $pruneby any] != 0 && \
		[string compare [qddb_schema option type $gv_schema $pruneby] date] == 0 && \
		[gp_isdate $r1] && [gp_isdate $r2]} {
	    set validrange 1
	    set rangetype dr
	    set r1 "$r1 12:00AM"
	    set r2 "$r2 11:59PM"
        } elseif {[gp_isnum $r1] && [gp_isnum $r2]} {
	    set validrange 1
	    set rangetype nr
        } elseif {[gp_isword $r1] && [gp_isword $r2]} {
	    set validrange 1
	    set rangetype wr
	} else {
	    set validrange 0
	}
	if {$validrange} {
            if {[catch {set retval [qddb_search $gv_schema -prunebyattr $pruneby \
					$rangetype $r1 - $r2]} ret_error]} {
		return [list error $ret_error]
	    } else {
		return $retval
	    }
        } else { # regexp
            if {[catch {set retval [qddb_search $gv_schema -prunebyattr $pruneby r $s]} ret_error]} {
		return [list error $ret_error]
	    } else {
		return $retval
	    }
        }
    } elseif {[string compare $pruneby any] != 0 && \
		  [string compare [qddb_schema option type $gv_schema $pruneby] date] == 0 && \
		  [gp_isdate $s] == 1} {
	if {[catch {set retval [qddb_search $gv_schema -prunebyattr $pruneby dr "$s 12:00AM" - "$s 11:59PM"]} ret_error]} {
	    return [list error $ret_error]
	} else {
	    return $retval
	}
    } elseif {[gp_isnum $s] == 1} {
	if {[catch {set retval [qddb_search $gv_schema -prunebyattr $pruneby n $s]} ret_error]} {
	    return [list error $ret_error]
	} else {
	    return $retval
	}
    } elseif {[gp_isword $s] == 1} {
	if {[catch {set retval [qddb_search $gv_schema -prunebyattr $pruneby $s]} ret_error]} {
	    return [list error $ret_error]
	} else {
	    return $retval
	}
    } else { # regexp
	if {[catch {set retval [qddb_search $gv_schema -prunebyattr $pruneby r $s]} ret_error]} {
	    return [list error $ret_error]
	} else {
	    return $retval
	}
    }
}

proc gp_intersect {s1 s2 exact pruneby} {
    set k1 [gp_multiop $s1 $exact $pruneby]
    if {[llength $k1] > 1} {
	return $k1
    }
    set k2 [gp_multiop $s2 $exact $pruneby]
    if {[llength $k2] > 1} {
	return $k2
    }
    return [qddb_keylist op intersection -exact $exact $k1 $k2]
}

proc gp_union {s1 s2 exact pruneby} {
    set k1 [gp_multiop $s1 $exact $pruneby]
    if {[llength $k1] > 1} {
	return $k1
    }
    set k2 [gp_multiop $s2 $exact $pruneby]
    if {[llength $k2] > 1} {
	return $k2
    }
    return [qddb_keylist op union -exact $exact $k1 $k2]
}

proc gp_exclude {s1 s2 exact pruneby} {
    set k1 [gp_multiop $s1 $exact $pruneby]
    if {[llength $k1] > 1} {
	return $k1
    }
    set k2 [gp_multiop $s2 $exact $pruneby]
    if {[llength $k2] > 1} {
	return $k2
    }
    return [qddb_keylist op exclusion -exact $exact $k1 $k2]
}

proc gp_binop {s1 op s2 exact pruneby} {
    switch -exact $op {
	" " {return [gp_intersect $s1 $s2 $exact $pruneby]}
	"," {return [gp_union $s1 $s2 $exact $pruneby]}
	"!" {return [gp_exclude $s1 $s2 $exact $pruneby]}
	default {return [gp_intersect $s1 $s2 $exact $pruneby]}
    }
}

proc gp_multiop {s {exact off} {pruneby any}} {
    set len [llength $s]
    if {$len == 3 && [string match {[!,]} [string trim [lindex $s 1]]]} {
	set result [gp_binop [lindex $s 0] [lindex $s 1] [lindex $s 2] $exact $pruneby]
    } elseif {$len == 2} {
	set result [gp_binop [lindex $s 0] " " [lindex $s 1] $exact $pruneby]
    } else {
        set result [gp_singlett [lindex $s 0] $pruneby]
	if {[llength $result] > 1} {
	    return $result
	}
        for {set i 1} {$i < $len} {incr i} {
	    if {[catch {
		switch -exact [lindex $s $i] {
		    "," {
			incr i
			set nresult [gp_multiop [lindex $s $i] $exact $pruneby]
			if {[llength $nresult] > 1} {
			    return $nresult
			}
			set result [qddb_keylist op union -exact $exact $result $nresult]
		    }
		    "!" {
			incr i
			set nresult [gp_multiop [lindex $s $i] $exact $pruneby]
			if {[llength $nresult] > 1} {
			    return $nresult
			}
			set result [qddb_keylist op exclusion -exact $exact $result $nresult]
		    }
		    default {
			set nresult [gp_multiop [lindex $s $i] $exact $pruneby]
			if {[llength $nresult] > 1} {
			    return $nresult
			}
			set result [qddb_keylist op intersection -exact $exact $result $nresult]
		    }
		}
	    } ret_error]} {
		return [list error "Bad query, respecify."]
	    }
	}
    }
    return $result
}

proc gp_search {} {
    global gv_mode_variable gv_status_variable gv_tuple_changed
    global gv_tuple gv_view gv_lastsearch gv_searchbox_variable
    global gv_schema gv_searchvars gv_config
    global gv_inprog gv_attr_vnames gv_status_msg

    if {[string compare $gv_mode_variable "Search Mode"] != 0} {
	set gv_status_variable "You must be in \"Search Mode\" to search"
	return
    }
    if {[info exists gv_inprog(gp_search)]} {
        return
    }
    set gv_inprog(gp_search) 1
    gp_disable .top
    set gv_status_variable "Searching..."
    update idletasks
    set k ""
    set nothing 1
    if {[catch "llength [list $gv_searchbox_variable]" error] != 0} {
	set gv_status_variable "Invalid Tcl list in \"Search For:\" field"
	set gv_status_msg $error
	gp_enable .top
	unset gv_inprog(gp_search)
	return
    }
    if {$error != 0} {
	if {$error == 1} {
	    set gv_searchbox_variable [lindex $gv_searchbox_variable 0]
	}
	set k [gp_multiop $gv_searchbox_variable]
	if {[llength $k] > 1} {
	    set gv_status_variable "Qddb Input Error"
	    set gv_status_msg [lindex $k 1]
	    update idletasks
	    unset gv_inprog(gp_search)
	    gp_enable .top
	    return
	}
	set nothing 0
    }
    set attrs_used {}
    foreach i [qddb_schema leaves $gv_schema] {
	if {[catch "llength [list $gv_searchvars($i)]" error] != 0} {
	    set gv_status_variable "Invalid Tcl list in \"$gv_attr_vnames($i)\" field"	
	    set gv_status_msg $error
	    gp_enable .top
	    unset gv_inprog(gp_search)
	    return
	}
        if {$error == 0} {
	    continue
	}
	set nothing 0
	if {$error == 1} {
	    set gv_searchvars($i) [lindex $gv_searchvars($i) 0]
	}
	set k1 [gp_multiop $gv_searchvars($i) on $i]
	if {[llength $k1] > 1} {
	    set gv_status_variable "Qddb Input Error"
	    update idletasks
	    tk_dialog .dialog "Qddb Input Error" [lindex $k1 1] error 0 OK
	    unset gv_inprog(gp_search)
	    gp_enable .top
	    return
	}
#	set k1 [qddb_keylist process prune -prunebyattr $i $k1]
	lappend attrs_used $i
	if {[string compare $k ""] == 0} {
	    set k $k1
	    set k1 ""
	} else {
	    set k [qddb_keylist op intersection $k $k1]
	}
    }
    if {[string compare $k ""] != 0} {	
	set k1 [qddb_keylist process nullop -copy on -deldup_sameentry on $k]
	set nk1 [qddb_keylist length $k1]
	catch [list qddb_keylist delete $k1]
	if {$nk1 > 200} {
	    set ans [tk_dialog .dialog "Soft limit reached" "Your query has matched $nk1 tuples. \
If you choose to continue, it may take a while.   Would you like to continue?" warning 0 OK Cancel]
	    if {$ans == 1} {
		set gv_status_variable "Search cancelled."
		gp_enable .top
		unset gv_inprog(gp_search)
		catch [list qddb_keylist delete $k]
		return
	    }
	}
	catch [list qddb_tuple delete all]
        if {![info exists gv_config(conf,\$search\$)]} {
            set gv_config(conf,\$search\$) {}
            foreach i [lrange [qddb_schema leaves $gv_schema] 0 4] {
                lappend gv_config(conf,\$search\$) ${i}:10
            }
        }
        if {![info exists gv_config(conf,,\$search\$)]} {
            set gv_config(conf,,\$search\$) {}
            foreach i $gv_config(conf,\$search\$) {
                lappend gv_config(conf,,\$search\$) [lindex [split ${i} ":"] 0]
            }
        }
        set fmt $gv_config(conf,\$search\$)
	if {[llength $attrs_used] == 0} {
	    set gv_lastsearch \
	        [qddb_rows select -print $fmt -suppress on $k]
        } else {
	    set gv_lastsearch \
	        [qddb_rows select -attrs $attrs_used -print $fmt -suppress on $k]
        }
	qddb_keylist delete $k
        set len [llength $gv_lastsearch]
    } else {
        set len 0
    }
    if {$nothing} {
	set gv_status_variable "No query specified"
	gp_enable .top
        unset gv_inprog(gp_search)
	return
    } elseif {$len == 0} {
	set gv_status_variable "No entries found"
	gp_enable .top
        unset gv_inprog(gp_search)
	return
    } else {
	set gv_status_variable "$len rows found"
	if {$len == 1} {
	    gp_new_tuple $gv_lastsearch .t.l.listbox
            gp_enable .top
            unset gv_inprog(gp_search)
	    return
	}
    }
    gp_lastsearch
    unset gv_inprog(gp_search)
}

proc gp_lastsearch {} {
    global gv_mode_variable gv_status_variable gv_tuple_changed
    global gv_tuple gv_view gv_lastsearch gv_searchbox_variable
    global gv_schema gv_attr gv_attr_pairs gv_default_font gv_config gv_attr_vnames
    global gv_results_button

    if {![info exists gv_lastsearch] || [string compare $gv_lastsearch ""] == 0} {
        return
    }
    if {[gp_check_tuple] == 1} {
	return
    }
    $gv_results_button configure -state normal
    gp_disable .top
    if {![info exists gv_config(geom,\$lastsearch\$)]} {
        set gv_config(geom,\$lastsearch\$) 100x100+[expr [winfo width .] / 2]+[expr [winfo height .] / 2]
    }
    foreach i $gv_lastsearch {
        lappend res1 [lindex $i 1]
        set lv_s([lindex $i 1]) $i
    }
    if {![info exists gv_config(conf,ascendsort,\$search\$)]} {
	if {[info exists gv_config(conf,sort,\$search\$)]} {
	    set gv_config(conf,ascendsort,\$search\$) $gv_config(conf,sort,\$search\$)
	} else {
	    set gv_config(conf,ascendsort,\$search\$) $gv_config(conf,,\$search\$)
	}
    }
    if {![info exists gv_config(conf,unsorted,\$search\$)]} {
	set gv_config(conf,unsorted,\$search\$) off
    }
    if {[string compare $gv_config(conf,unsorted,\$search\$) "on"] != 0} {
	if {[info exists gv_config(conf,sort,\$search\$)]} {
	    set res1 [qddb_rows sort -ascending $gv_config(conf,ascendsort,\$search\$) \
			  $gv_config(conf,sort,\$search\$) $res1]
	} else {
	    set res1 [qddb_rows sort -ascending $gv_config(conf,ascendsort,\$search\$) \
			  $gv_config(conf,,\$search\$) $res1]
	}
    }
    set gv_lastsearch {}
    foreach i $res1 {
        lappend gv_lastsearch $lv_s($i)
    }
    set res {}
    if {[info exists gv_config(conf,print,\$search\$)]} {
        foreach i $res1 {
	    regsub -all "\n" [qddb_rows getval $gv_config(conf,print,\$search\$) $i] " " a
            lappend res $a
	}
        foreach i $gv_config(conf,print,\$search\$) {
            lappend headers $gv_attr_vnames($i)
        }
        foreach i $gv_config(conf,print,\$search\$) {
            set j [lsearch -glob $gv_config(conf,\$search\$) "${i}*"]
            set sx [split [lindex $gv_config(conf,\$search\$) $j] ":"]
            if {[llength $sx] > 1} {
                lappend widths [lindex $sx 1]
            } else {
                lappend widths 10
            }
        }
    } else {
        foreach i $res1 {
	    regsub -all "\n" [qddb_rows getval $gv_config(conf,,\$search\$) $i] " " a
            lappend res $a
        }
        foreach i $gv_config(conf,,\$search\$) {
            lappend headers $gv_attr_vnames($i)
        }
        foreach i $gv_config(conf,\$search\$) {
            set sx [split $i ":"]
            if {[llength $sx] > 1} {
                lappend widths [lindex $sx 1]
            } else {
                lappend widths 10
            }
        }
    }
    if {![info exists headers]} {
	gp_enable .top
	set gv_status_variable "No attributes selected for viewing"
	return
    }
    catch [list destroy .t]
    toplevel .t
    set gm [split $gv_config(geom,\$lastsearch\$) "+"]
    set gm "+[lindex $gm 1]+[lindex $gm 2]"
    wm geometry .t $gm
    wm title .t "Search Results"
    update idletasks
    frame .t.f0
    pack .t.f0 -expand on -fill x -side top
    set x .t.f0
    menubutton $x.close -text "Close" -relief raised -bd 2  \
        -font "$gv_default_font" -underline 0
    pack $x.close -side left -anchor w
    checkbutton $x.tack -variable gv_config(tack,\$lastsearch\$) -font $gv_default_font \
	-text Pin
    pack $x.tack -side left -anchor e
    menubutton $x.print -text "Print" -relief raised -bd 2  \
        -font "$gv_default_font" -underline 0
    pack $x.print -side right -anchor e

    set oldfocus [focus]
    while {[catch "grab .t"] != 0} {}
    frame .t.f
    pack .t.f -side top
    set x .t
    if {![info exists gv_config(conf,boxheight,\$search\$)]} {
	set gv_config(conf,boxheight,\$search\$) 10
    }
    set boxes [gp_def_listbox $x.f $headers $widths $gv_config(conf,boxheight,\$search\$)]
    set numunits 0
    foreach i $res {
	incr numunits
        gp_append_listbox $x.f $i $widths
    }
    set wwid [wm geometry .t]
    set wwid [split [lindex [split $wwid "+"] 0] "x"]
    set wht  [lindex $wwid 1]
    set wwid [lindex $wwid 0]
    set numboxes 0
    foreach i $boxes {
	$i configure -geometry [lindex $widths $numboxes]x[gp_max $numunits $wht]
	incr numboxes
        bind $i <ButtonRelease-1> +[list gp_searchexec .t .t.f.f0.l0]
        bind $i <Return> [list gp_searchexec .t .t.f.f0.l0]
        $i select from 0
    }
    wm geometry .t ${wwid}x[gp_min $numunits ${wht}]
    focus $x.f.f0.l0
    gp_bind_menubutton .t.f0.close c $boxes "
        set [list gv_config(geom,\$lastsearch\$)] \[wm geometry .t\]
        catch {destroy .t}
        update idletasks
        set gv_tuple_changed 0
        catch {tkwait window .t}
    "
    gp_bind_menubutton .t.f0.print p $boxes [list gp_print_boxes $headers $widths $res]
    wm minsize .t $wwid 1
    wm maxsize .t $wwid $numunits
    update idletasks
    bind .t <Configure> {
	set gv_config(conf,boxheight,\$search\$) \
	    [lindex [split [lindex [split [wm geometry .t] "+"] 0] "x"] 1]
    }
    tkwait window .t
    focus $oldfocus
    grab release .t
    gp_enable .top
#    if {[string compare $gv_mode_variable "Search Mode"] == 0} {
#	set gv_status_variable "Ready to search"
#    }
}

proc gp_print_boxes {h w r} {
    global gv_commands
    if {![info exists gv_commands(lpr)]} {
	return
    }
    if {![info exists gv_commands(pr)]} {
	set fd [open "| $gv_commands(lpr)" "w"]
    } else {
	set fd [open "| $gv_commands(pr) | $gv_commands(lpr)" "w"]
    }
    set len [llength $h]
    set sumwid 0
    for {set i 0} {$i < $len} {incr i} {
	set wid [lindex $w $i]
	set head [lindex $h $i]
	if {[string length $head] > $wid} {
	    set head [string range $head 0 [expr $wid -1]]
	}
	incr sumwid $wid
	incr sumwid
	puts -nonewline $fd [format "%${wid}s|" $head]
    }
    puts $fd ""
    set dashes ""
    for {set i 0} {$i < $sumwid} {incr i} {
	append dashes "-"
    }
    puts $fd $dashes
    foreach i $r {
	for {set j 0} {$j < $len} {incr j} {
	    set wid [lindex $w $j]
	    set dat [lindex $i $j]
	    if {[string length $dat] > $wid} {
		set dat [string range $dat 0 [expr $wid -1]]
	    }
	    puts -nonewline $fd [format "%${wid}s|" $dat]
	}
	puts $fd ""
    }
    close $fd
}

proc gp_searchexec {w box} {
    global gv_lastsearch gv_config gv_tuple

    if {![winfo exists $w]} {
        return
    }
    catch "qddb_tuple unlock $gv_tuple"
    gp_new_tuple $gv_lastsearch $box
    set gv_config(geom,\$lastsearch\$) [wm geometry $w]
    if {[info exists gv_config(tack,\$lastsearch\$)] && $gv_config(tack,\$lastsearch\$) == 0} {
	catch "destroy $w"
        update
        catch "tkwait window $w"
    }
}


proc gp_search_mode {} {
    global gv_mode_variable gv_status_variable gv_tuple_changed
    global gv_tuple gv_view gv_schema gv_attr_pairs gv_attr gv_lastsearch gv_entryname
    global gv_searchvars gv_config
    global gv_delete_button gv_search_button gv_addmode_button gv_clear_button gv_searchmode_button
    global gv_save_button gv_undo_button gv_view gv_searchbox_name gv_searchbox_label

    if {[string compare $gv_mode_variable "Add Mode"] == 0} {
        if {[gp_check_tuple] != 0} {
            return
        }
    } elseif {[string compare $gv_mode_variable "Change Mode"] == 0} {
        if {[gp_check_tuple] != 0} {
            return
        }
    } elseif {[string compare $gv_mode_variable "Search Mode"] == 0} {
	return
    }
    $gv_searchbox_name configure -state normal
    $gv_searchbox_label configure -state normal
    catch [list qddb_view delete $gv_view]
    gp_bindsearch
    set gv_tuple_changed 0
    $gv_delete_button configure -state disabled
    $gv_search_button configure -state normal
    $gv_addmode_button configure -state normal
    $gv_clear_button configure -state normal
    $gv_searchmode_button configure -state disabled
    $gv_save_button configure -state disabled
    $gv_undo_button configure -state disabled
    gp_template_state read disabled
    gp_template_state write disabled
    gp_template_state last disabled
    set gv_mode_variable "Search Mode"
    set gv_status_variable "Ready to search"
    catch "qddb_tuple unlock $gv_tuple"
    foreach i [array names gv_entryname] {
	set class [winfo class $gv_entryname($i)]
	switch -exact $class {
	    Entry {$gv_entryname($i) delete 0 end}
	    Text  {$gv_entryname($i) delete 0.0 end}
	}
        if {![info exists gv_searchvars($i)]} {
	    set gv_searchvars($i) ""
	} elseif {[info exists gv_config(conf,auto_clear)] && $gv_config(conf,auto_clear) == 1} {
	    set gv_searchvars($i) ""
	}
	switch -exact $class {
	    Entry {
		$gv_entryname($i) insert 0 $gv_searchvars($i)
		$gv_entryname($i) configure -textvariable gv_searchvars($i)
	    }
	    Text  {
		$gv_entryname($i) insert 0.0 $gv_searchvars($i)
		gp_texttrace_search $gv_entryname($i) $i
	    }
	}
    }
}

