
proc gp_texttrace_delete {w n} {
    global gv_attr gv_searchvars gv_thack

    trace vdelete gv_attr($n) w [list gp_refresh_text $w]
    trace vdelete gv_thack($w) w [list gp_refresh_textvar $w gv_attr $n]
    trace vdelete gv_searchvars($n) w [list gp_refresh_text $w]
    trace vdelete gv_thack($w) w [list gp_refresh_textvar $w gv_searchvars $n]
    catch [list unset gv_thack($w)]
}

proc gp_texttrace_search {w n} {
    global gv_attr gv_searchvars gv_thack

    trace vdelete gv_attr($n) w [list gp_refresh_text $w]
    trace vdelete gv_thack($w) w [list gp_refresh_textvar $w gv_attr $n]
    catch [list set gv_thack($w) ""]
    trace variable gv_searchvars($n) w [list gp_refresh_text $w]
    trace variable gv_thack($w) w [list gp_refresh_textvar $w gv_searchvars $n]
}

proc gp_texttrace_modify {w n} {
    global gv_attr gv_searchvars gv_thack

    trace vdelete gv_searchvars($n) w [list gp_refresh_text $w]
    trace vdelete gv_thack($w) w [list gp_refresh_textvar $w gv_searchvars $n]
    set gv_thack($w) ""
    trace variable gv_attr($n) w [list gp_refresh_text $w]
    trace variable gv_thack($w) w [list gp_refresh_textvar $w gv_attr $n]
}

proc gp_refresh_text {w n1 n2 op} {
    global $n1

    set i [$w index insert]
    $w delete 0.0 end
    $w insert 0.0 [set ${n1}($n2)]
    $w mark set insert $i
    $w yview -pickplace insert
}

proc gp_refresh_textvar {w n a {n1 ""} {n2 ""} {op ""}} {
    global $n

    set ${n}($a) [$w get 0.0 end]
}

proc gp_disable {w} {
    foreach i [winfo children $w] {
	catch [list $i configure -cursor watch]
	gp_disable $i
    }
}

proc gp_enable {w} {
    foreach i [winfo children $w] {
	catch [list $i configure -cursor arrow]
	gp_enable $i
    }
}

proc gp_dotypeerror {type val} {
    tk_dialog .dialog "Type error" "Invalid input for entry of type (${type}): $val  Please re-enter." \
	error 0 OK
}

proc gp_typecheck {attr} {
    global gv_entryname gv_schema gv_attr

    set type [qddb_schema option type $gv_schema $attr]
    switch -exact [winfo class $gv_entryname($attr)] {
	Entry {set val [$gv_entryname($attr) get]}
	Text {return}
	default {return}
    }
    set err 0
    switch -exact $type {
	integer {
	    if {[catch "expr int($val)"] == 0} {
		return
	    } else {
		set err 1
	    }
	}
	real {
	    if {[catch "expr double($val)"] == 0} {
		return
	    } else {
		set err 1
	    }
	}
    }
    if {$err != 0} {
	gp_dotypeerror $type [$gv_entryname($attr) get]
	focus $gv_entryname($attr)
    } elseif {[string compare $type "date"] == 0} {
	if {![qddb_util isdate [$gv_entryname($attr) get]]} {
	    gp_dotypeerror $type [$gv_entryname($attr) get]
	    focus $gv_entryname($attr)
	}
    }
}


proc gp_sel_fonts {} {
    global gv_status_variable gv_config_changed
    global gv_default_font gv_config

    set s [gp_font_select $gv_default_font]
    if {[string compare $s "error"] == 0} {
        set gv_config_changed 0	
        set gv_status_variable "Font selection cancelled"
	return
    }
    if {[string compare $s ""] != 0} {
        gp_change_fonts . $s
        gp_set_default_font $s
	if {[info exists gv_config(maingeom)]} {
	    set x [split $gv_config(maingeom) +]
	} else {
	    set x [split [winfo geometry .] +]
	}
	set y [lindex $x 2]
	set height [lindex [split [lindex $x 0] x] 1]
        gp_canv_fit .top .top.canvas .top.canvas.schema $height
        set gv_config_changed 1
    } else {
        set gv_config_changed 0	
        set gv_status_variable "Font selection cancelled"
    }
}

proc gp_min {x y} {
    if {$x < $y} {
        return $x
    }
    return $y
}

proc gp_max {x y} {
    if {$x < $y} {
        return $y
    }
    return $x
}

proc gp_canv_fit {w can canfr {setsize {}}} {
    update idletasks
    set width [winfo reqwidth $canfr] 
    set ocheight [winfo reqheight $canfr]
    set sheight $ocheight
    set parent [winfo parent $w]
    set otoph 0
    foreach i [winfo children $w] {
        if {[string compare $i $can] != 0} {
            incr otoph [winfo height $i]
        }
    }
    set rooth [winfo screenheight .]
    if {$rooth < [expr $otoph+$ocheight]} {
        set cheight [expr $rooth - [expr $rooth / 5]]
    } else {
        set cheight $ocheight
    }
    $can configure -width $width -height $cheight -scrollregion [list 0 0 $width $sheight]
    update idletasks
    set width [winfo reqwidth $parent]
    set toph [winfo reqheight $parent]
    wm minsize [winfo parent $w] ${width} [expr ${toph} / 3]
    set maxht [gp_min ${rooth} [expr ${toph} - ${cheight} + ${sheight}]]
    wm maxsize [winfo parent $w] ${width} ${maxht}
    if {[llength $setsize] == 0} {
	if {${maxht} < ${toph}} {
	    wm geometry [winfo parent $w] "=${width}x${maxht}"
	} else {
	    wm geometry [winfo parent $w] "=${width}x${toph}"
	}
    } else {
	if {${maxht} < ${setsize}} {
	    wm geometry [winfo parent $w] "=${width}x${maxht}"
	} else {
	    wm geometry [winfo parent $w] "=${width}x${setsize}"
	}
    }
    $can configure -height $sheight
}

proc gp_resize {h w} {
    global gv_config

    update idletasks
    set gv_config(maingeom) [wm geometry .]
}

proc gp_clearscreen {} {
    global gv_attr gv_searchvars gv_entryname gv_mode_variable gv_status_variable gv_tuple
    global gv_lastadded gv_searchbox_variable

    if {[string compare $gv_mode_variable "Search Mode"] == 0} {
	foreach i [array names gv_searchvars] {
	    set gv_searchvars($i) ""
	}
	set gv_searchbox_variable ""
	return
    }
    if {[string compare $gv_mode_variable "Add Mode"] == 0} {
	set gv_status_variable "Tuple cleared: ready to add"
	set gv_mode_variable "Search Mode"
	set gv_lastadded ""
	gp_add_mode 1
	return
    }
}

proc gp_resize_entries {{parent .top}} {
    global gv_config

    foreach i [winfo children $parent] {
	set cl [winfo class $i]
	switch -exact $cl {
	    Entry {$i configure -width $gv_config(conf,entry_width)}
	    Text {$i configure -width $gv_config(conf,entry_width)}
	}
	gp_resize_entries $i
    }
}

proc gp_redo_widths {n1 n2 op} {
    global gv_config gv_config_changed

    if {[info exists gv_config(maingeom)]} {
	set height [lindex [split [lindex [split $gv_config(maingeom) +] 0] x] 1]
    } else {
	set height {}
    }
    gp_resize_entries
    gp_canv_fit .top .top.canvas .top.canvas.schema $height
    if {[info exists gv_config(maingeom)]} {
	update idletasks
	set curwidth [lindex [split [lindex [split [wm geometry .] +] 0] x] 0]
	wm geometry . ${curwidth}x${height}
    }
    set gv_config_changed 1
}

proc gp_exit {} {
    global gv_attr gv_config

    if {[gp_check_tuple] != 0} {
        return
    }
    if {$gv_config(conf,auto_save_config)} {
	gp_save_config
    } elseif {[gp_check_config] != 0} {
        return
    }
    qddb_keylist delete all
    qddb_tuple delete all
    qddb_view delete all
    qddb_rows delete all
    qddb_schema close all
    unset gv_attr
    exit 0
}
