'\"
'\" qddb/ManPages/man1/qddb_tuple.n
'\" 
'\" Copyright (C) 1993, 1994 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH qddb_tuple 1 "9 Sept 1994" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 12 Sept 1994
.SH NAME
qddb_tuple \- Manipulate a Qddb tuple.
.SH SYNOPSIS
.ft B
.nf

qddb_tuple new <schema_desc>
qddb_tuple read <schema_desc> <keylist node>
qddb_tuple write <tuple_desc>
qddb_tuple get external|readable|tclexternal|tclvalue <tuple_desc>
qddb_tuple put external|readable|tclexternal|tclvalue <schema_desc> <tuple value>
qddb_tuple lock <tuple_desc>
qddb_tuple unlock <tuple_desc>
qddb_tuple isempty <tuple_desc>
qddb_tuple refresh <tuple_desc>
qddb_tuple flush <tuple_desc>|<schema_desc>|all
qddb_tuple remove <tuple_desc>
qddb_tuple delete <tuple_desc>|<schema_desc>|all

.SH DESCRIPTION
\fIqddb_tuple\fR manipulates a Qddb tuple.
\fI<tuple_desc>\fR is a tuple descriptor returned from a
.nf
	qddb_tuple read <schema_desc> <keylist node>
.fi
command.
\fI<keylist node>\fR is a quadruple generally obtained from a
within a list returned by
.nf
        qddb_keylist get <keylist desc>
.fi
command.   <schema_desc> is a schema descriptor returned from a
.nf
        qddb_schema open <relation directory>
.fi
command.  <tuple value> is a tuple in one of the supported formats
(external, readable, tclexternal, or tclvalue).

.TP
\fIqddb_tuple read\fR
reads a tuple described by <keylist node> into memory from an open
Qddb database described by <schema desc>.  The value returned from
this command is a descriptor that may be used in subsequent Qddb
calls.   If the tuple is invalid (that is, if it has been deleted
or changed), \fBqddb_tuple read\fR returns an empty string ("").
Any locks on the tuple being read are released.

.TP
\fIqddb_tuple write\fR
writes a tuple described by <tuple desc> back into the Qddb database
as a changed entry.

.TP
\fIqddb_tuple get\fR
returns the contents of the tuple described by the given <tuple desc>
in the requested format.   Currently, four formats are available:
external, readable, tclexternal, and tclvalue (See section on
Supported Formats below).

.TP
\fIqddb_tuple put\fR
returns a <tuple_desc> describing a new tuple with the contents 
taken from the <tuple value> argument.   The new tuple may then
be written, or used in any way a normal tuple may be used.
A \fBqddb_tuple write\fR of a tuple created with 
\fBqddb_tuple put\fR is entered into the database as a
completely new tuple, regardless of whether the $NUMBER$
field is supplied (the $NUMBER$ field is supported for 
backward compatibility only).

.TP
\fIqddb_tuple lock\fR
locks a tuple for exclusive writing.  Other Qddb applications honoring
the locking protocol may still read the old tuple's data, but they
may not obtain a lock for that tuple.   \fBqddb_tuple lock\fR implicitly
refreshes the tuple after the lock is obtained; you are guaranteed to
always have the newest version of the tuple after \fBqddb_tuple lock\fR
returns.    If the lock is obtained, \fBqddb_tuple lock\fR returns 1,
otherwise, it returns 0.

.TP
\fIqddb_tuple unlock\fR
removes the lock (if any) on the specified tuple.

.TP
\fIqddb_tuple isempty\fR
check the given tuple for non-blank fields.   If it
contains at least one non-blank field, a 1 is returned.
Otherwise, a 0 is returned.

.TP
\fIqddb_tuple refresh\fR
refreshes the given tuple from the disk.   This command
is generally used to refresh the tuple if changes
are made and discarded.

.TP
\fIqddb_tuple flush\fR
flushes memory used by the tuple, but marks the tuple
to be re-read from disk if the <tuple_desc> is used.
This implements a form of read-on-demand.   If <schema_desc>
is provided instead of <tuple_desc>, then all tuples associated
with the schema described by <schema_desc> are flushed.  If the
special keyword \fBall\fR is used, then all tuples in memory 
associated with any schema are flushed.   Flushing an in-memory
tuple \fIdoes not\fR remove any locks.

.TP
\fIqddb_tuple remove\fR
invalidates the given tuple on disk and
deletes the tuple from memory.

.TP
\fI qddb_tuple delete\fR
deletes the given tuple descriptor and frees all memory
occupied by the tuple.   The given <tuple_desc> may not
be used again.   If <schema_desc>
is provided instead of <tuple_desc>, then all tuples associated
with the schema described by <schema_desc> are flushed.
The special <tuple_desc> \fBall\fR
instructs Qddb to delete all active tuples from memory.
Deleting an in-memory tuple implicitly removes all locks
associated with the tuple.

.SH SUPPORTED FORMATS
For examples in this section, we will use the following
schema:

.nf
        a ( b* c* d* )*
.fi

.TP
\fBexternal\fR
A list of attributes in external format.   The first
element in the list is (optionally):
.nf
        %0 V <unique sequence number>
.fi
and each other element of the list is an attribute in the form:
.nf
{
        {%1.1.1.1 data in the field}
        {%1.2.1.1 more data}
}
.fi
Above we show two separate attributes, both of which describe
a different instance of \fIa.b\fR.    The first line describes
the first instance of \fIa\fR and within that instance, the
first instance of \fIb\fR.   The second line describes
the second instance of \fIa\fR and within that instance, the
first instance of \fIb\fR.   This format is equivalent to the
standard format of the Qddb \fBDatabase\fR file.

.TP
\fBreadable\fR
A single list element containing the Qddb readable form
of the tuple.   The readable form (for the schema above) might
be:
.nf
{
        $NUMBER$ = "319";
        a (
                b = "some data for attribute a.b"
                b = "some data for attribute a.b"
                c = "some data for attribute a.c"
                c = "some data for attribute a.c"
        )
        a (
                d = "some data for attribute a.d"
        )
}
.fi
Here we have two instances of the structured attribute \fIa\fR, each
contains some instances of \fIa\fR's subattributes.   The $NUMBER$
line describes the tuple's unique sequence number and is optional.

.TP
\fBtclexternal\fR
A list containing a number of (attribute,value) pairs.  The
tclexternal form for a tuple in the database described by
the schema above might be:
.nf
{
        {$NUMBER$} 319
        a.b,1.1 "some data for attribute a.b" 
        a.c,2.1 "some data for attribute a.c"
}
.fi
Here we have two instances of the structured attribute \fIa\fR,
each containing data in exactly one attribute.   The $NUMBER$ element
tells us that the next element in the list is the unique
sequence number for that tuple; the first two elements may
be omitted.  This is suggested format for use in network-based 
applications (client/server-style).

.TP
\fBtclvalue\fR
(not yet implemented).

.SH SEE ALSO
qddb_instance(n), qddb_keylist(n),  qddb_rows(n), qddb_schema(n), 
qddb_search(n), qddb_view(n)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS

.SH BUGS
None known.
.SH COPYRIGHT
.nf
Copyright (C) 1993, 1994 Herrin Software Development, Inc.
All rights reserved.
.fi
.PP
This manual page is part of Qddb.
.PP
Qddb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License Version 2
as published by the Free Software Foundation.
.PP
Qddb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with Qddb; see the file LICENSE.  If not, write to:
.sp
.nf
        Herrin Software Development, Inc. 
        R&D Division
        41 South Highland Ave. 
        Prestonsburg, KY 41653 
.fi  