'\"
'\" qddb/ManPages/man1/qddb_keylist.n
'\" 
'\" Copyright (C) 1993, 1994 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH qddb_keylist 1 "3 Oct 1994" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 3 Oct 1994
.SH NAME
qddb_keylist \- Manipulate a Qddb KeyList.
.SH SYNOPSIS
.ft B
.nf
qddb_keylist operation <op> <options> [-exact on|off] <keylist_desc1> <keylist_desc2>
qddb_keylist process prune -prunebyattr attr <options> <keylist_desc>
qddb_keylist process prune -prunebyrow attrlist <options> <keylist_desc>
qddb_keylist process sort|nullop <options> <keylist_desc>
qddb_keylist get <keylist_desc>
qddb_keylist delete <keylist_desc>|all
.SH OPTIONS
.ft B
.nf
<op> is one of intersection|union|exclusion.

<options> may be any combination of:
        -copy on|off
        -deldup_sameentry on|off
        -deldup_sameattr on|off
.fi
.SH DESCRIPTION
.B qddb_keylist
performs various operations on keylists described by keylist descriptors.

.I <keylist_desc>
is returned by qddb_search(n).
It is a token to an internal Qddb data structure that is
difficult to deal with under TCL.  Each node of a KeyList uniquely
describes exactly one tuple and the attribute/instance within
that tuple that matched a query.

.I attr
is the name of a valid attribute for the schema.  For example,
Client.Name.First might be a valid attribute name.
.I attrlist
is a list of attributes used to find the elements of the provided
keylist.

.I <options>
specify the side effects for the operation.
If -copy is on (the default is \fB off\fR), then 
the result is a copy and the original two 
keylist arguments are untouched.   If -copy is off, then the original
two arguments are automatically deleted.   "-deldup_sameentry on" deletes
any duplicate nodes within the same entry, returning a keylist where
each node is a unique tuple in the relation.   "-deldup_sameattr on"
deletes nodes that match exactly, including the attribute and instance
numbers.

.TP
\fIqddb_keylist operation\fR 
performs the given operation (union, intersection, or exclusion)
on the two keylist arguments.   If -exact is on, 
comparisons are performed using exact matching on the keylists, including
instance and attribute.  If -exact is off, comparisons are performed
using only the quadruples (offset, length, number, type).   -exact
is useful for finding multiple keys in a single instance of one attribute.

.TP
\fIqddb_keylist process prune\fR
requires at least one of:
.nf
	-prunebyattr attr
	-prunebyrow  attrlist
.fi
-prunebyattr prunes the keylist of all nodes not matching the
given attribute.   -prunebyrow prunes the keylist of all nodes that
are not part of a single row containing a match for each attribute
in attrlist.

.TP
\fIqddb_keylist process sort\fR
sorts the given keylist, placing nodes referring to the same
tuple next to each other.   This is not necessary unless a keylist
is manipulated manually somehow.

.TP
\fIqddb_keylist process nullop\fR
No special processing is performed except that specified by
the <options>.   For example,
.nf
	set s [qddb_schema open MyRelation]
	set k [qddb_search $s regexp {.*aa.*}]
        set k1 [qddb_keylist process nullop -copy on $k]
.fi
will copy the keylist described by $k and place a new descriptor
in $k1.

.TP
\fIqddb_keylist get\fR
converts the keylist associated with the key into a list of quadruples
(offset, length, number, type).   The returned list of quadruples
is a proper TCL list.   By typing directly into qddb_tclsh, you might
see:
.nf
        $ qddb_tclsh
        % set s [qddb_schema open FamilyMembers]
        qddb_schema0
        % set k [qddb_search $s word george]
        qddb_keylist0
        % set mylist [qddb_keylist get $k]
        {5651458 34643 0 1} {7965698 5346 0 1} {2583639 12842 0 1}
        % set tuple [qddb_tuple read $s [lindex $mylist 0]]
        qddb_tuple0
.fi

.TP
\fIqddb_keylist delete\fR
deletes the internal keylist associated with the given <keylist_desc>.   This
must be done for each unused keylist.  The special <keylist_desc> \fIall\fR
deletes all keylist descriptors.

.SH SEE ALSO
qddb_instance(n), qddb_rows(n), qddb_schema(n), 
qddb_search(n), qddb_tuple(n), qddb_view(n), qddb(1)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS
.B qddb_schema
will report an error if it cannot find the Qddb schema
specified.
.SH BUGS
None known.
.SH COPYRIGHT
.nf
Copyright (C) 1993, 1994 Herrin Software Development, Inc.
All rights reserved.
.fi
.PP
This manual page is part of Qddb.
.PP
Qddb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License Version 2
as published by the Free Software Foundation.
.PP
Qddb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with Qddb; see the file LICENSE.  If not, write to:
.sp
.nf
        Herrin Software Development, Inc. 
        R&D Division
        41 South Highland Ave. 
        Prestonsburg, KY 41653 
.fi
