'\"
'\" qddb/ManPages/man1/qddb_instance.n
'\" 
'\" Copyright (C) 1993, 1994 Herrin Software Development, Inc.
'\" All rights reserved.
'\" 
'\" This file is part of Qddb.
'\" 
'\" Qddb is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License Version 2
'\" as published by the Free Software Foundation.
'\" 
'\" Qddb is distributed in the hope that it will be useful,
'\" but WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'\" GNU General Public License for more details.
'\" 
'\" You should have received a copy of the GNU General Public License
'\" along with Qddb; see the file LICENSE.  If not, write to:
'\" 
'\" 	Herrin Software Development, Inc. 
'\" 	R&D Division
'\" 	41 South Highland Ave. 
'\" 	Prestonsburg, KY 41653 
'\" 
.TH qddb_instance 1 "3 Oct 1994" "QDDB Reference Manual" "Herrin Software Development, Inc."
.DA 3 Oct 1994
.SH NAME
qddb_instance \- Manipulate instances within a Qddb view.
.SH SYNOPSIS
.ft B
.nf
qddb_instance new <view desc> <attribute name>
qddb_instance current <view desc> <attribute name>
qddb_instance getval <view desc> <attribute name> ?<instance number>?
qddb_instance isempty <view desc> <attribute name> <instance number>
qddb_instance maxnum <view desc> <attribute name>
qddb_instance move <view desc> <attribute name> <instnum from> <instnum to>
qddb_instance remove <view desc> <attribute name> <instance number>
qddb_instance setval <view desc> <attribute name> ?<instance number>? <instance value>
qddb_instance switch <view desc> <attribute name> <instance number>


.SH DESCRIPTION
\fBqddb_instance\fR operates on a preexisting view's (created 
with \fBqddb_view(n)\fR) tuple and manipulates the view.

.TP
\fIqddb_instance new\fR 
creates a new instance of the given attribute in the
given view.  For example, a schema containing:

.nf
    Name ( Title First Middle Last* )*
    Address ( Street City State ZipCode )*
    Info ( Date type date Comments* )*
.fi

may have a view consisting of:

.nf
    Name.Title Name.First Name.Middle Name.Last
    Address.Street Address.City Address.State Address.ZipCode
    Info.Date Info.Comments
.fi

If there are currently 3 instances of the \fIName\fR 
expandable attribute in the tuple associated with the view,
then \fBqddb_instance new $view_desc Name\fR will create
the 4th instance and all its subattributes.   Adding a new
instance does not automatically switch the view to that instance.

.TP
\fIqddb_instance current\fR 
returns the current instance number of 
the given attribute in the given view.   This number may be used
to index into arrays or listboxes.    \fBInstance numbers begin with
1\fR.

.TP
\fIqddb_instance getval\fR 
returns the value of 
the given attribute (possibly qualified by instance number) 
in the given view.    If the given attribute contains
subattributes, an error is returned.

.TP
\fIqddb_instance isempty\fR 
check whether the attribute
in the given view contains any non-blank values. 
If non-blank fields exist, 0 is returned.   Otherwise, 1 is
returned.  Attributes of
types \fIint\fR and \fIreal\fR always return 0 because
they are initialized to a value of zero and are never empty.

.TP
\fIqddb_instance maxnum\fR 
returns the instance number of the last instance
of the given attribute in the given view.   This is also the
number of instances of that attribute in the given view.

.TP
\fIqddb_instance move\fR 
moves the instance given by
<instnum from> to the spot given by <instnum to>.   This command changes
the storage order of the instances in memory only.   When the
tuple is saved to disk, the new ordering is saved.

.TP
\fIqddb_instance setval\fR 
sets the value of 
the given attribute (possibly qualified by instance number) 
in the given view.    If the given attribute contains
subattributes, an error is returned.

.TP
\fIqddb_instance switch\fR 
switches the given attribute to the 
given instance number in the given view.  If the given instance
number is out of bounds, an error is returned.

.TP
\fIqddb_instance remove\fR 
removes the given instance from the
in-memory tuple.   If the current instance in the view is removed, then
the view is modified to show one of the other instances.   If no instances
remain, a blank instance is inserted and used in the view.
If the in-memory tuple is saved, then the
removed instance is deleted from the on-disk copy.

.SH SEE ALSO
qddb_keylist(n),  qddb_rows(n), qddb_schema(n), 
qddb_search(n), qddb_tuple(n), qddb_view(n), qddb(1)
.SH REFERENCES
.nf
A Guide to QDDB
Eric H. Herrin II and Raphael A. Finkel

An ASCII Database for Fast Queries of Relatively Stable Data
Eric H. Herrin II and Raphael A. Finkel
Computing Systems, Volume 4 Number 2
University of California Press, Berkeley CA

TCL and the TK Toolkit 
John K. Ousterhout
Addison-Wesley, 1994
ISBN 0-201-63337-X
.fi
.SH DIAGNOSTICS

.SH BUGS
None known.
.SH COPYRIGHT
.nf
Copyright (C) 1993, 1994 Herrin Software Development, Inc.
All rights reserved.
.fi
.PP
This manual page is part of Qddb.
.PP
Qddb is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License Version 2
as published by the Free Software Foundation.
.PP
Qddb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with Qddb; see the file LICENSE.  If not, write to:
.sp
.nf
        Herrin Software Development, Inc. 
        R&D Division
        41 South Highland Ave. 
        Prestonsburg, KY 41653 
.fi
