
/* Qddb/Headers/Qddb_Schema.h 
 * General schema definitions.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#if !defined(_QDDB_SCHEMA_H_)
#define _QDDB_SCHEMA_H_

#define MAXIMUM_SCHEMA_ENTRY		1024
#define MAXIMUM_NUMBER_OF_SCHEMA_LEVELS	16

/* Qddb_RebuildSchema() args
 */
#define QDDB_REBUILDSCHEMA_FROMNODES 0
#define QDDB_REBUILDSCHEMA_FROMTREE  1

#define DEFAULT_SEPARATORS "\t \n\r!@#$%^&*()_+-={}[];':\",./<>?`~\\|"
#define DEFAULT_REAL_SEPARATORS "\t \n\r!@#$%^&*()_={}[];':\",/<>?`~\\|"
#define DEFAULT_INTEGER_SEPARATORS "\t \n\r!@#$%^&*()_={}[];':\",./<>?`~\\|"
#define DEFAULT_DATE_SEPARATORS "\t \n\r!@#$%^&*()_={}[];':\",/<>?`~\\|"

typedef struct attroption {
    int 		option;
    char		*value;
    struct attroption 	*next;
} attroption_t; /* for the Schema Parser only */

typedef enum {
    Typeless = 0,
    Real     = 1,
    Integer  = 2,
    String   = 3,
    Date     = 4
} AttributeType;

typedef struct schemanode {
    char		*Name;
    char		*VerboseName;
    char		*Alias;
    char		*Format;
    char		*Separators;
    Boolean		Exclude;
    AttributeType	Type;
    Boolean		AsteriskPresent;
    size_t		Number;
    size_t		AncestorNumber[MAXIMUM_NUMBER_OF_SCHEMA_LEVELS];
    size_t		Level;
    Boolean		IsLeaf;
} SchemaNode;

typedef struct schematreenode {
    SchemaNode			*schemanode;
    struct schematreenode	**children;
} SchemaTreeNode;

typedef char *ReducedAttrTable;

typedef struct {
    char		*RelationName;
    SchemaNode		*Entries;
    SchemaTreeNode	**Tree;
    size_t		NumberOfAttributes;
    int			hashtable_fd, database_fd;
    Hash		*HashTable;
    Boolean		UseReducedAttributeIdentifiers, UseCachedHashing;
    ReducedAttrTable	*ReducedAttributeTable;
    size_t		TopOfReducedAttributeTable, HashSize, CacheSize, TopOfCache;
    char		*default_date_format;
} Schema;

Schema 		*Qddb_InitSchema _ANSI_ARGS_((char *));
Schema 		*Qddb_RebuildSchema _ANSI_ARGS_((Schema *, int));

void   		ResetSchemaParser _ANSI_ARGS_(());
int    		SchemaParse();	
void 		Qddb_SchemaParse_Set _ANSI_ARGS_((Schema *));
Schema 		*Qddb_SchemaParse_Get _ANSI_ARGS_((void));

void		Qddb_InitHash _ANSI_ARGS_((Schema *));
void		Qddb_MakeHash _ANSI_ARGS_((Schema *, char *));
int		Qddb_GetHashTableEntry _ANSI_ARGS_((Schema *, size_t));

#endif

